/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.base.relations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;
import org.gcube.informationsystem.utils.Utility;

public abstract class RelationElementManagement<SEM extends EntityElementManagement<? extends EntityElement>, TEM extends EntityElementManagement<? extends EntityElement>>
extends ElementManagement<OEdge> {
    protected final Class<? extends EntityElement> sourceEntityClass;
    protected final Class<? extends EntityElement> targetEntityClass;
    protected SEM sourceEntityManagement;
    protected TEM targetEntityManagement;

    protected RelationElementManagement(AccessType accessType, Class<? extends EntityElement> sourceEntityClass, Class<? extends EntityElement> targetEntityClass) {
        super(accessType);
        this.ignoreKeys.add("header");
        this.ignoreKeys.add("source");
        this.ignoreKeys.add("target");
        this.ignoreKeys.add("out".toLowerCase());
        this.ignoreKeys.add("in".toLowerCase());
        this.ignoreKeys.add("out".toUpperCase());
        this.ignoreKeys.add("in".toUpperCase());
        this.sourceEntityClass = sourceEntityClass;
        this.targetEntityClass = targetEntityClass;
        this.sourceEntityManagement = null;
        this.targetEntityManagement = null;
    }

    protected RelationElementManagement(AccessType accessType, Class<? extends EntityElement> sourceEntityClass, Class<? extends EntityElement> targetEntityClass, SecurityContext workingContext, ODatabaseDocument orientGraph) {
        this(accessType, sourceEntityClass, targetEntityClass);
        this.oDatabaseDocument = orientGraph;
        this.setWorkingContext(workingContext);
    }

    public SEM getSourceEntityManagement() throws ResourceRegistryException {
        if (this.sourceEntityManagement == null) {
            OVertex source = ((OEdge)this.getElement()).getVertex(ODirection.OUT);
            this.sourceEntityManagement = this.newSourceEntityManagement();
            this.sourceEntityManagement.setElement((OElement)source);
        }
        this.sourceEntityManagement.setReload(this.reload);
        return (SEM)this.sourceEntityManagement;
    }

    public TEM getTargetEntityManagement() throws ResourceRegistryException {
        if (this.targetEntityManagement == null) {
            OVertex target = ((OEdge)this.getElement()).getVertex(ODirection.IN);
            this.targetEntityManagement = this.newTargetEntityManagement();
            this.targetEntityManagement.setElement((OElement)target);
        }
        this.targetEntityManagement.setReload(this.reload);
        return (TEM)this.targetEntityManagement;
    }

    public void setSourceEntityManagement(SEM sourceEntityManagement) {
        this.sourceEntityManagement = sourceEntityManagement;
    }

    public void setTargetEntityManagement(TEM targetEntityManagement) {
        this.targetEntityManagement = targetEntityManagement;
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        return this.serializeAsJson(true, true);
    }

    public JsonNode serializeAsJson(boolean includeSource, boolean includeTarget) throws ResourceRegistryException {
        JsonNode relation = this.serializeSelfOnly();
        try {
            if (includeSource) {
                EntityElementManagement sourceEntityManagement = this.getSourceEntityManagement();
                ((ObjectNode)relation).replace("source", sourceEntityManagement.serializeSelfOnly());
            }
            if (includeTarget) {
                EntityElementManagement targetEntityManagement = this.getTargetEntityManagement();
                ((ObjectNode)relation).replace("target", targetEntityManagement.serializeAsJson());
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw new ResourceRegistryException((Throwable)e);
        }
        return relation;
    }

    protected OEdge reallyCreate() throws ResourceRegistryException {
        if (this.sourceEntityManagement == null) {
            if (!this.jsonNode.has("source")) {
                throw new ResourceRegistryException("Error while creating relation. No source definition found");
            }
            UUID sourceUUID = Utility.getUUIDFromJsonNode((JsonNode)this.jsonNode.get("source"));
            this.sourceEntityManagement = this.newSourceEntityManagement();
            this.sourceEntityManagement.setUUID(sourceUUID);
        }
        if (this.targetEntityManagement == null) {
            this.targetEntityManagement = this.newTargetEntityManagement();
            if (!this.jsonNode.has("target")) {
                throw new ResourceRegistryException("Error while creating " + this.elementType + ". No target definition found");
            }
            try {
                this.targetEntityManagement.setJsonNode(this.jsonNode.get("target"));
            }
            catch (SchemaException e) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("A ");
                errorMessage.append(this.elementType);
                errorMessage.append(" can be only created beetween ");
                errorMessage.append(this.sourceEntityManagement.getAccessType().getName());
                errorMessage.append(" and ");
                errorMessage.append(this.targetEntityManagement.getAccessType().getName());
                throw new ResourceRegistryException(errorMessage.toString(), (Throwable)e);
            }
            try {
                this.targetEntityManagement.getElement();
            }
            catch (Exception e) {
                this.targetEntityManagement.internalCreate();
            }
        }
        this.logger.trace("Creating {} beetween {} -> {}", new Object[]{this.elementType, this.getSourceEntityManagement().serialize(), this.getTargetEntityManagement().serialize()});
        OVertex source = (OVertex)this.getSourceEntityManagement().getElement();
        OVertex target = (OVertex)this.getTargetEntityManagement().getElement();
        this.element = this.oDatabaseDocument.newEdge(source, target, this.elementType);
        ElementManagement.updateProperties((OClass)this.oClass, (OElement)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        return (OEdge)this.element;
    }

    protected abstract SEM newSourceEntityManagement() throws ResourceRegistryException;

    protected abstract TEM newTargetEntityManagement() throws ResourceRegistryException;

    protected OEdge reallyUpdate() throws ResourceRegistryException {
        JsonNode target;
        this.logger.debug("Trying to update {} : {}", (Object)this.elementType, (Object)this.jsonNode);
        OEdge edge = (OEdge)this.getElement();
        ElementManagement.updateProperties((OClass)this.oClass, (OElement)edge, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        if (this.accessType.compareTo((Enum)AccessType.CONSISTS_OF) == 0 && (target = this.jsonNode.get("target")) != null) {
            FacetManagement fm = new FacetManagement(this.getWorkingContext(), this.oDatabaseDocument);
            fm.setJsonNode(target);
            fm.internalUpdate();
        }
        this.logger.info("{} {} successfully updated", (Object)this.elementType, (Object)this.jsonNode);
        return edge;
    }

    protected boolean reallyDelete() throws RelationNotFoundException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {}. Related {}s will be detached.", new Object[]{this.accessType.getName(), this.uuid, this.targetEntityClass.getSimpleName()});
        ((OEdge)this.getElement()).delete();
        return true;
    }
}

