/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.relations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.isparentof.IsParentOfAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.isparentof.IsParentOfNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.base.relations.RelationElementManagement;

public class IsParentOfManagement
extends RelationElementManagement<ContextManagement, ContextManagement> {
    public IsParentOfManagement() {
        super(AccessType.IS_PARENT_OF, Context.class, Context.class);
    }

    public IsParentOfManagement(ODatabaseDocument oDatabaseDocument) throws ResourceRegistryException {
        this();
        this.oDatabaseDocument = oDatabaseDocument;
        this.getWorkingContext();
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getInstance().getSecurityContextByUUID(DatabaseEnvironment.CONTEXT_SECURITY_CONTEXT_UUID);
        }
        return this.workingContext;
    }

    protected IsParentOfNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
        return new IsParentOfNotFoundException(e.getMessage(), e.getCause());
    }

    protected IsParentOfAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new IsParentOfAlreadyPresentException(message);
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        return this.serializeAsJson(false, true);
    }

    public JsonNode serializeAsJson(boolean includeSource, boolean includeTarget) throws ResourceRegistryException {
        JsonNode relation = this.serializeSelfOnly();
        try {
            OVertex source = ((OEdge)this.element).getVertex(ODirection.OUT);
            ContextManagement sourceContextManagement = new ContextManagement(this.oDatabaseDocument);
            sourceContextManagement.setElement((OElement)source);
            if (includeSource) {
                ((ObjectNode)relation).replace("source", sourceContextManagement.serializeSelfOnly());
            }
            OVertex target = ((OEdge)this.element).getVertex(ODirection.IN);
            ContextManagement targetContextManagement = new ContextManagement(this.oDatabaseDocument);
            targetContextManagement.setElement((OElement)target);
            if (includeTarget) {
                ((ObjectNode)relation).replace("target", targetContextManagement.serializeSelfOnly());
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw new ResourceRegistryException((Throwable)e);
        }
        return relation;
    }

    protected ContextManagement newSourceEntityManagement() throws ResourceRegistryException {
        return new ContextManagement(this.oDatabaseDocument);
    }

    protected ContextManagement newTargetEntityManagement() throws ResourceRegistryException {
        return new ContextManagement(this.oDatabaseDocument);
    }

    protected boolean reallyAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected AvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        throw new UnsupportedOperationException();
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        throw new UnsupportedOperationException();
    }
}

