/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.types.SchemaManagementImpl;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.utils.discovery.SchemaAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaActionImpl
implements SchemaAction {
    private static Logger logger = LoggerFactory.getLogger(SchemaActionImpl.class);

    public <R extends RelationElement<? extends EntityElement, ? extends EntityElement>> void manageRelationClass(Class<R> r) throws Exception {
        try {
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.setTypeName(TypeMapper.getType(r));
            String json = TypeMapper.serializeType(r);
            logger.trace(json);
            if (ConsistsOf.class.isAssignableFrom(r)) {
                schemaManagement.create(json, AccessType.CONSISTS_OF);
            } else if (IsRelatedTo.class.isAssignableFrom(r)) {
                schemaManagement.create(json, AccessType.IS_RELATED_TO);
            } else {
                schemaManagement.create(json, AccessType.RELATION_ELEMENT);
            }
        }
        catch (SchemaAlreadyPresentException sape) {
            logger.warn("{} already exists. It will be ignored", (Object)TypeMapper.getType(r));
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} {}: {}", new Object[]{"RelationElement", r.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }

    public <E extends EntityElement> void manageEntityClass(Class<E> e) throws Exception {
        try {
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.setTypeName(TypeMapper.getType(e));
            String json = TypeMapper.serializeType(e);
            logger.trace(json);
            if (Facet.class.isAssignableFrom(e)) {
                schemaManagement.create(json, AccessType.FACET);
            } else if (Resource.class.isAssignableFrom(e)) {
                schemaManagement.create(json, AccessType.RESOURCE);
            } else {
                schemaManagement.create(json, AccessType.ENTITY_ELEMENT);
            }
        }
        catch (SchemaAlreadyPresentException sape) {
            logger.warn("{} already exists. It will be ignored", (Object)TypeMapper.getType(e));
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} {}: {}", new Object[]{"EntityElement", e.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }

    public <P extends PropertyElement> void managePropertyClass(Class<P> p) throws Exception {
        try {
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.setTypeName(TypeMapper.getType(p));
            String json = TypeMapper.serializeType(p);
            logger.trace(json);
            if (Property.class.isAssignableFrom(p)) {
                if (p.equals(Property.class) || p.equals(Header.class)) {
                    schemaManagement.setSkipTypeDefinitionCreation(true);
                }
                schemaManagement.create(json, AccessType.PROPERTY);
            } else {
                schemaManagement.create(json, AccessType.PROPERTY_ELEMENT);
            }
        }
        catch (SchemaAlreadyPresentException sape) {
            logger.warn("{} already exists. It will be ignored", (Object)TypeMapper.getType(p));
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} {}: {}", new Object[]{"PropertyElement", p.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }
}

