/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.relations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.base.relations.RelationElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.PropagationConstraintOrient;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.gcube.informationsystem.utils.ElementMapper;

public abstract class RelationManagement<T extends EntityManagement<? extends Entity>>
extends RelationElementManagement<ResourceManagement, T> {
    public final PropagationConstraint defaultPropagationConstraint;

    protected RelationManagement(AccessType accessType, Class<? extends Entity> targetEntityClass, PropagationConstraint defaultPropagationConstraint) {
        super(accessType, Resource.class, targetEntityClass);
        this.defaultPropagationConstraint = defaultPropagationConstraint;
    }

    protected RelationManagement(AccessType accessType, Class<? extends Entity> targetEntityClass, SecurityContext workingContext, ODatabaseDocument orientGraph, PropagationConstraint defaultPropagationConstraint) {
        this(accessType, targetEntityClass, defaultPropagationConstraint);
        this.oDatabaseDocument = orientGraph;
        this.setWorkingContext(workingContext);
    }

    public ResourceManagement giveMeSourceEntityManagementAsIs() throws ResourceRegistryException {
        return (ResourceManagement)this.sourceEntityManagement;
    }

    public ResourceManagement getSourceEntityManagement() throws ResourceRegistryException {
        if (this.sourceEntityManagement == null) {
            OVertex source = ((OEdge)this.getElement()).getVertex(ODirection.OUT);
            this.sourceEntityManagement = this.newSourceEntityManagement();
            ((ResourceManagement)this.sourceEntityManagement).setElement((OElement)source);
        }
        ((ResourceManagement)this.sourceEntityManagement).setReload(this.reload);
        return (ResourceManagement)this.sourceEntityManagement;
    }

    public T getTargetEntityManagement() throws ResourceRegistryException {
        if (this.targetEntityManagement == null) {
            OVertex target = ((OEdge)this.getElement()).getVertex(ODirection.IN);
            this.targetEntityManagement = this.newTargetEntityManagement();
            ((EntityManagement)this.targetEntityManagement).setElement((OElement)target);
        }
        ((EntityManagement)this.targetEntityManagement).setReload(this.reload);
        return (T)((EntityManagement)this.targetEntityManagement);
    }

    public void setSourceEntityManagement(ResourceManagement resourceManagement) {
        this.sourceEntityManagement = resourceManagement;
    }

    public void setTargetEntityManagement(T targetEntityManagement) {
        this.targetEntityManagement = targetEntityManagement;
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        return this.serializeAsJson(true, true);
    }

    public JsonNode serializeAsJson(boolean includeSource, boolean includeTarget) throws ResourceRegistryException {
        JsonNode relation = this.serializeSelfOnly();
        try {
            if (includeSource) {
                ResourceManagement sourceEntityManagement = this.getSourceEntityManagement();
                ((ObjectNode)relation).replace("source", sourceEntityManagement.serializeSelfOnly());
            }
            if (includeTarget) {
                EntityManagement targetEntityManagement = this.getTargetEntityManagement();
                ((ObjectNode)relation).replace("target", targetEntityManagement.serializeAsJson());
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw new ResourceRegistryException((Throwable)e);
        }
        return relation;
    }

    protected Map<String, JsonNode> fullSerialize(Map<String, JsonNode> visitedSourceResources) throws ResourceRegistryException {
        OVertex source = ((OEdge)this.getElement()).getVertex(ODirection.OUT);
        String id = source.getIdentity().toString();
        JsonNode sourceResource = visitedSourceResources.get(id);
        ResourceManagement resourceManagement = null;
        if (sourceResource == null) {
            resourceManagement = (ResourceManagement)ElementManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)source);
            if (this instanceof IsRelatedToManagement) {
                sourceResource = resourceManagement.serializeAsJson();
            } else if (this instanceof ConsistsOfManagement) {
                sourceResource = resourceManagement.serializeSelfOnly();
            } else {
                String error = String.format("{%s is not a %s nor a %s. %s", this, IsRelatedToManagement.class.getSimpleName(), ConsistsOfManagement.class.getSimpleName(), "This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(error);
            }
        }
        if (this instanceof IsRelatedToManagement) {
            sourceResource = ResourceManagement.addIsRelatedTo((JsonNode)sourceResource, (JsonNode)this.serializeAsJson());
        } else if (this instanceof ConsistsOfManagement) {
            sourceResource = ResourceManagement.addConsistsOf((JsonNode)sourceResource, (JsonNode)this.serializeAsJson());
        } else {
            String error = String.format("{%s is not a %s nor a %s. %s", this, IsRelatedToManagement.class.getSimpleName(), ConsistsOfManagement.class.getSimpleName(), "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        visitedSourceResources.put(id, sourceResource);
        return visitedSourceResources;
    }

    protected PropagationConstraintOrient getPropagationConstraint(ODocument oDocument) throws ResourceRegistryException {
        PropagationConstraintOrient propagationConstraintOrient = new PropagationConstraintOrient();
        PropagationConstraint propagationConstraint = null;
        if (oDocument == null) {
            propagationConstraint = this.defaultPropagationConstraint;
        } else if (oDocument instanceof PropagationConstraintOrient) {
            propagationConstraint = (PropagationConstraint)oDocument;
        } else {
            try {
                propagationConstraint = (PropagationConstraint)ElementMapper.unmarshal(PropagationConstraint.class, (String)oDocument.toJSON());
            }
            catch (Exception e) {
                this.logger.warn("Unable to recreate {}. {}", (Object)"PropagationConstraint", (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        PropagationConstraint.AddConstraint addConstraint = propagationConstraint.getAddConstraint();
        if (addConstraint == null) {
            addConstraint = this.defaultPropagationConstraint.getAddConstraint();
            this.logger.warn("Unable to get {}. Default value ({}) will be used", (Object)PropagationConstraint.AddConstraint.class.getSimpleName(), (Object)addConstraint);
        }
        propagationConstraintOrient.setAddConstraint(addConstraint);
        PropagationConstraint.RemoveConstraint removeConstraint = propagationConstraint.getRemoveConstraint();
        if (removeConstraint == null) {
            removeConstraint = this.defaultPropagationConstraint.getRemoveConstraint();
            this.logger.warn("Unable to get {}. Default value ({}) will be used", (Object)PropagationConstraint.RemoveConstraint.class.getSimpleName(), (Object)removeConstraint);
        }
        propagationConstraintOrient.setRemoveConstraint(removeConstraint);
        return propagationConstraintOrient;
    }

    protected void checkPropagationConstraint() throws ResourceRegistryException {
        Object object = ((OEdge)this.getElement()).getProperty("propagationConstraint");
        PropagationConstraintOrient pc = this.getPropagationConstraint((ODocument)object);
        ((OEdge)this.getElement()).setProperty("propagationConstraint", (Object)pc, new OType[]{OType.EMBEDDED});
    }

    protected OEdge reallyCreate() throws ResourceRegistryException {
        this.element = super.reallyCreate();
        this.checkPropagationConstraint();
        this.logger.info("{} successfully created", (Object)this.elementType);
        return (OEdge)this.element;
    }

    protected ResourceManagement newSourceEntityManagement() throws ResourceRegistryException {
        return new ResourceManagement(this.getWorkingContext(), this.oDatabaseDocument);
    }

    protected abstract T newTargetEntityManagement() throws ResourceRegistryException;

    protected OEdge reallyUpdate() throws ResourceRegistryException {
        JsonNode target;
        this.logger.debug("Trying to update {} : {}", (Object)this.elementType, (Object)this.jsonNode);
        OEdge edge = (OEdge)this.getElement();
        ElementManagement.updateProperties((OClass)this.oClass, (OElement)edge, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        if (this.accessType.compareTo((Enum)AccessType.CONSISTS_OF) == 0 && (target = this.jsonNode.get("target")) != null) {
            FacetManagement fm = new FacetManagement(this.getWorkingContext(), this.oDatabaseDocument);
            fm.setJsonNode(target);
            fm.internalUpdate();
        }
        this.logger.info("{} {} successfully updated", (Object)this.elementType, (Object)this.jsonNode);
        return edge;
    }

    protected boolean reallyAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        this.getElement();
        PropagationConstraint.AddConstraint addConstraint = PropagationConstraint.AddConstraint.unpropagate;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)Utility.getPropertyDocument(PropagationConstraint.class, (OElement)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getAddConstraint() == null) {
                String error = String.format("%s.%s in %s is null. %s", "propagationConstraint", "add", Utility.toJsonString((OElement)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
                this.logger.error(error);
                throw new ResourceRegistryException(error);
            }
            addConstraint = propagationConstraint.getAddConstraint();
        }
        catch (Exception e) {
            String error = String.format("Error while getting %s from %s while performing AddToContext. %s", "propagationConstraint", Utility.toJsonString((OElement)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
            this.logger.warn(error);
            throw new ResourceRegistryException(error, (Throwable)e);
        }
        switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$properties$PropagationConstraint$AddConstraint[addConstraint.ordinal()]) {
            case 1: {
                this.getTargetEntityManagement().internalAddToContext(targetSecurityContext);
                targetSecurityContext.addElement(this.getElement(), this.oDatabaseDocument);
                break;
            }
            case 2: {
                break;
            }
        }
        return true;
    }

    public boolean forcedAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        this.getElement();
        this.getSourceEntityManagement().internalAddToContext(targetSecurityContext);
        this.getTargetEntityManagement().internalAddToContext(targetSecurityContext);
        targetSecurityContext.addElement(this.getElement(), this.oDatabaseDocument);
        return true;
    }

    protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        this.getElement();
        PropagationConstraint.RemoveConstraint removeConstraint = PropagationConstraint.RemoveConstraint.keep;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)Utility.getPropertyDocument(PropagationConstraint.class, (OElement)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getRemoveConstraint() == null) {
                String error = String.format("%s.%s in %s is null. %s", "propagationConstraint", "remove", Utility.toJsonString((OElement)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
                this.logger.error(error);
                throw new ResourceRegistryException(error);
            }
            removeConstraint = propagationConstraint.getRemoveConstraint();
        }
        catch (Exception e) {
            String error = String.format("Error while getting %s from %s while performing RemoveFromContext. %s", "propagationConstraint", Utility.toJsonString((OElement)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
            this.logger.error(error);
            throw new ResourceRegistryException(error, (Throwable)e);
        }
        targetSecurityContext.removeElement(this.getElement(), this.oDatabaseDocument);
        switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$properties$PropagationConstraint$RemoveConstraint[removeConstraint.ordinal()]) {
            case 1: {
                this.getTargetEntityManagement().internalRemoveFromContext(targetSecurityContext);
                break;
            }
            case 2: {
                OVertex target = (OVertex)this.getTargetEntityManagement().getElement();
                Iterable iterable = target.getEdges(ODirection.IN);
                Iterator iterator = iterable.iterator();
                int count = 0;
                OEdge edge = null;
                while (iterator.hasNext()) {
                    OEdge thisOEdge;
                    edge = (OEdge)iterator.next();
                    if (edge.compareTo((Object)(thisOEdge = (OEdge)this.getElement())) == 0 || thisOEdge.getVertex(ODirection.OUT).compareTo((Object)edge.getVertex(ODirection.OUT)) == 0) continue;
                    ++count;
                    break;
                }
                if (count > 0) {
                    this.logger.trace("{} point to {} which is not orphan ({} exists). Giving {} directive, it will be not remove from .", new Object[]{this.element, target, edge, removeConstraint, targetSecurityContext});
                    break;
                }
                this.getTargetEntityManagement().internalRemoveFromContext(targetSecurityContext);
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }

    protected boolean reallyDelete() throws RelationNotFoundException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {}. Related {}s will be detached.", new Object[]{this.accessType.getName(), this.uuid, this.targetEntityClass.getSimpleName()});
        this.getElement();
        PropagationConstraint.RemoveConstraint removeConstraint = PropagationConstraint.RemoveConstraint.keep;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)Utility.getPropertyDocument(PropagationConstraint.class, (OElement)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getRemoveConstraint() == null) {
                String error = String.format("%s.%s in %s is null. %s", "propagationConstraint", "remove", Utility.toJsonString((OElement)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
                this.logger.error(error);
                throw new ResourceRegistryException(error);
            }
            removeConstraint = propagationConstraint.getRemoveConstraint();
        }
        catch (Exception e) {
            this.logger.warn("Error while getting {} from {}. Assuming {}. {}", new Object[]{"propagationConstraint", Utility.toJsonString((OElement)this.element, (boolean)true), removeConstraint, "This is really strange and should not occur. Please contact the system administrator."});
        }
        OVertex target = (OVertex)this.getTargetEntityManagement().getElement();
        ((OEdge)this.element).delete();
        switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$properties$PropagationConstraint$RemoveConstraint[removeConstraint.ordinal()]) {
            case 1: {
                this.getTargetEntityManagement().internalDelete();
                break;
            }
            case 2: {
                Iterable iterable = target.getEdges(ODirection.IN);
                Iterator iterator = iterable.iterator();
                if (iterator.hasNext()) {
                    this.logger.trace("{} point to {} which is not orphan. Giving {} directive, it will be keep.", new Object[]{this.element, target, removeConstraint});
                    break;
                }
                this.getTargetEntityManagement().internalDelete();
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }

    protected Collection<JsonNode> serializeEdges(Iterable<ODocument> edges, boolean postFilterPolymorphic) throws ResourceRegistryException {
        Map visitedSourceResources = new HashMap();
        for (ODocument d : edges) {
            OEdge edge = (OEdge)d;
            if (postFilterPolymorphic && this.getOClass().isSubClassOf(this.elementType)) continue;
            RelationManagement relationManagement = ElementManagementUtility.getRelationManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OEdge)edge);
            visitedSourceResources = relationManagement.fullSerialize(visitedSourceResources);
        }
        return visitedSourceResources.values();
    }

    protected String serializeJsonNodeCollectionAsString(Collection<JsonNode> collection) throws ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = (ArrayNode)objectMapper.valueToTree(collection);
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ORecordIteratorClass edges = this.oDatabaseDocument.browseClass(this.elementType, polymorphic);
        Collection collection = this.serializeEdges((Iterable)edges, false);
        return this.serializeJsonNodeCollectionAsString(collection);
    }

    public boolean addToContext(UUID contextUUID) throws NotFoundException, ContextException {
        this.logger.debug("Going to add {} with UUID {} to Context with UUID {}", new Object[]{this.accessType.getName(), this.uuid, contextUUID});
        try {
            this.oDatabaseDocument = ContextUtility.getAdminSecurityContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            boolean added = this.forcedAddToContext(targetSecurityContext);
            this.oDatabaseDocument.commit();
            this.logger.info("{} with UUID {} successfully added to Context with UUID {}", new Object[]{this.accessType.getName(), this.uuid, contextUUID});
            boolean bl = added;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {}", new Object[]{this.accessType.getName(), this.uuid, contextUUID, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
        }
    }
}

