/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaCreationException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.types.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.types.SchemaManagementImpl;
import org.gcube.informationsystem.resourceregistry.types.entities.FacetTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.entities.ResourceTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.properties.PropertyTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.relations.ConsistsOfTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.relations.IsRelatedToTypeDefinitionManagement;
import org.gcube.informationsystem.types.OrientDBType;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManagementImpl
implements SchemaManagement {
    private static Logger logger = LoggerFactory.getLogger(SchemaManagementImpl.class);
    protected String typeName;
    protected boolean skipTypeDefinitionCreation = false;
    private static Set<String> baseElementTypes = new HashSet();
    public static Set<String> typeList;

    public boolean isSkipTypeDefinitionCreation() {
        return this.skipTypeDefinitionCreation;
    }

    public void setSkipTypeDefinitionCreation(boolean skipTypeDefinitionCreation) {
        this.skipTypeDefinitionCreation = skipTypeDefinitionCreation;
    }

    protected OClass getOClass(OSchema oSchema, String typeName) throws SchemaException {
        return oSchema.getClass(typeName);
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    private Type getType(OClass oClass) throws SchemaException {
        try {
            PropertyTypeDefinitionManagement erManagement = null;
            if (oClass.isSubClassOf("Property")) {
                erManagement = new PropertyTypeDefinitionManagement();
                erManagement.setName(oClass.getName());
            } else if (oClass.isSubClassOf("Resource")) {
                erManagement = new ResourceTypeDefinitionManagement();
                ((ResourceTypeDefinitionManagement)erManagement).setName(oClass.getName());
            } else if (oClass.isSubClassOf("Facet")) {
                erManagement = new FacetTypeDefinitionManagement();
                ((FacetTypeDefinitionManagement)erManagement).setName(oClass.getName());
            } else if (oClass.isSubClassOf("IsRelatedTo")) {
                erManagement = new IsRelatedToTypeDefinitionManagement();
                ((IsRelatedToTypeDefinitionManagement)erManagement).setName(oClass.getName());
            } else if (oClass.isSubClassOf("ConsistsOf")) {
                erManagement = new ConsistsOfTypeDefinitionManagement();
                ((ConsistsOfTypeDefinitionManagement)erManagement).setName(oClass.getName());
            }
            if (erManagement != null) {
                String ret = erManagement.read();
                return TypeMapper.deserializeTypeDefinition((String)ret);
            }
            throw new SchemaException("You can only request schema of IS Model types and their specilization");
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
    }

    protected String getTypeDefinitionAsString(OClass oClass) throws SchemaException {
        try {
            Type type = this.getType(oClass);
            return TypeMapper.serializeTypeDefinition((Type)type);
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
    }

    protected List<OClass> getSuperclassesAndCheckCompliancy(ODatabaseDocument oDatabaseDocument, Type type, String baseType) throws SchemaException, SchemaNotFoundException {
        Set superClasses = type.getSuperClasses();
        if (baseType != null && (superClasses == null || superClasses.size() == 0)) {
            throw new RuntimeException(String.format("No Superclass found in schema %s. The Type Definition must extend %s", type, baseType));
        }
        OMetadata oMetadata = oDatabaseDocument.getMetadata();
        OSchema oSchema = oMetadata.getSchema();
        ArrayList<OClass> oSuperclasses = new ArrayList<OClass>();
        for (String superClass : superClasses) {
            OClass oSuperClass = this.getOClass(oSchema, superClass);
            if (oSuperClass == null) {
                throw new SchemaNotFoundException("Superclass " + superClass + " does not exists");
            }
            if (baseType != null && type.getName().compareTo(baseType) != 0 && !oSuperClass.isSubClassOf(baseType)) {
                throw new RuntimeException(superClass + " is not a subsclass of " + baseType + ". Each Superclass MUST be a subclass of " + baseType);
            }
            oSuperclasses.add(oSuperClass);
        }
        return oSuperclasses;
    }

    protected void registerTypeSchema(Type type, AccessType baseElementAccessType) throws SchemaAlreadyPresentException, SchemaException {
        try (ODatabaseDocument oDatabaseDocument = null;){
            if (this.typeName.compareTo(type.getName()) != 0) {
                String error = String.format("Provided type name path argument %s does not match with the type name in the definition %S. Please be coherent.", this.typeName, type.getName());
                throw new SchemaCreationException(error);
            }
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            OMetadata oMetadata = oDatabaseDocument.getMetadata();
            OSchema oSchema = oMetadata.getSchema();
            OClass oClass = null;
            if (EntityElement.class.isAssignableFrom(baseElementAccessType.getTypeClass())) {
                oClass = oDatabaseDocument.createVertexClass(type.getName());
            } else if (RelationElement.class.isAssignableFrom(baseElementAccessType.getTypeClass())) {
                oClass = oDatabaseDocument.createEdgeClass(type.getName());
            } else if (PropertyElement.class.isAssignableFrom(baseElementAccessType.getTypeClass())) {
                oClass = oSchema.createClass(type.getName());
            } else {
                String error = String.format("Allowed superclass are %s, %s, %s, or any subclasses of them.", "Entity", "Relation", "Property");
                throw new SchemaCreationException(error);
            }
            try {
                Set propertyDefinitions;
                String description = type.getDescription();
                if (description != null && description.compareTo("") != 0) {
                    try {
                        oClass.setDescription(description);
                    }
                    catch (Exception e) {
                        logger.warn("Unable to set description. This is an orient bug. See https://github.com/orientechnologies/orientdb/issues/7065");
                    }
                }
                try {
                    oClass.setAbstract(type.isAbstract());
                }
                catch (Exception e) {
                    logger.error("Unable to set the Vertex Type {} as abstract. This is an OrientDB <= 2.2.12 bug. The Type will be created as it is not abstract.", (Object)type.getName());
                }
                if (!baseElementTypes.contains(type.getName())) {
                    List oSuperclasses = this.getSuperclassesAndCheckCompliancy(oDatabaseDocument, type, baseElementAccessType.getName());
                    oClass.setSuperClasses(oSuperclasses);
                }
                if (!(type instanceof ResourceType) && (propertyDefinitions = type.getProperties()) != null) {
                    for (PropertyDefinition propertyDefinition : propertyDefinitions) {
                        OType oType = OType.getById((byte)propertyDefinition.getType().byteValue());
                        if (!typeList.contains(type.getName())) {
                            switch (1.$SwitchMap$com$orientechnologies$orient$core$metadata$schema$OType[oType.ordinal()]) {
                                case 1: {
                                    throw new UnsupportedDataTypeException(OrientDBType.OType.PROPERTYLIST + " support is currently disabled due to OrientDB bug see https://github.com/orientechnologies/orientdb/issues/7354");
                                }
                                case 2: {
                                    throw new UnsupportedDataTypeException(OrientDBType.OType.PROPERTYSET + " support is currently disabled due to OrientDB bug see https://github.com/orientechnologies/orientdb/issues/7354");
                                }
                            }
                        }
                        OProperty op = oClass.createProperty(propertyDefinition.getName(), oType);
                        op.setDescription(propertyDefinition.getDescription());
                        op.setMandatory(false);
                        op.setNotNull(false);
                        op.setReadonly(propertyDefinition.isReadonly());
                        op.setRegexp(propertyDefinition.getRegexp());
                        if (propertyDefinition.getLinkedClass() != null) {
                            OClass linkedClass = this.getOClass(oSchema, propertyDefinition.getLinkedClass());
                            if (linkedClass == null) {
                                logger.trace("class {} not found in schema", (Object)propertyDefinition.getLinkedClass());
                                throw new Exception("class " + propertyDefinition.getLinkedClass() + " not found in schema");
                            }
                            if (linkedClass.isEdgeType() || linkedClass.isVertexType()) {
                                throw new Exception("A Property Field cannot be an Entity or a Relation");
                            }
                            op.setLinkedClass(linkedClass);
                            continue;
                        }
                        if (propertyDefinition.getLinkedType() == null) continue;
                        op.setLinkedType(OType.getById((byte)propertyDefinition.getLinkedType().byteValue()));
                    }
                }
                oDatabaseDocument.commit();
                logger.info("{} {} registered successfully", (Object)baseElementAccessType.getName(), (Object)type.getName());
            }
            catch (Exception e) {
                oSchema.dropClass(type.getName());
                throw e;
            }
        }
    }

    protected String getSchema(String typeName, boolean includeSubtypes) throws SchemaNotFoundException, SchemaException {
        try (ODatabaseDocument oDatabaseDocument = null;){
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            OMetadata oMetadata = oDatabaseDocument.getMetadata();
            OSchema oSchema = oMetadata.getSchema();
            OClass baseOClass = oSchema.getClass(typeName);
            if (baseOClass == null) {
                throw new SchemaNotFoundException(typeName + " does not Exists");
            }
            ArrayList<Type> typeDefinitions = new ArrayList<Type>();
            typeDefinitions.add(this.getType(baseOClass));
            if (includeSubtypes) {
                Collection subClasses = baseOClass.getAllSubclasses();
                for (OClass oClass : subClasses) {
                    typeDefinitions.add(this.getType(oClass));
                }
            }
            String string = TypeMapper.serializeTypeDefinitions(typeDefinitions);
            return string;
        }
    }

    public String create(String jsonSchema, AccessType accessType) throws SchemaAlreadyPresentException, SchemaException {
        Type typeDefinition = null;
        try {
            try {
                typeDefinition = TypeMapper.deserializeTypeDefinition((String)jsonSchema);
                logger.info("Trying to register {} {} : {}", new Object[]{accessType.getName(), typeDefinition.getName(), jsonSchema});
            }
            catch (Exception e) {
                logger.error("Error while trying to register {} {}", (Object)accessType.getName(), (Object)jsonSchema);
                throw new SchemaCreationException((Throwable)e);
            }
            this.registerTypeSchema(typeDefinition, accessType);
            PropertyTypeDefinitionManagement erManagement = null;
            switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[accessType.ordinal()]) {
                case 1: {
                    erManagement = new PropertyTypeDefinitionManagement();
                    break;
                }
                case 2: {
                    erManagement = new ResourceTypeDefinitionManagement();
                    break;
                }
                case 3: {
                    erManagement = new FacetTypeDefinitionManagement();
                    break;
                }
                case 4: {
                    erManagement = new IsRelatedToTypeDefinitionManagement();
                    break;
                }
                case 5: {
                    erManagement = new ConsistsOfTypeDefinitionManagement();
                    break;
                }
            }
            String ret = null;
            if (erManagement != null && !this.skipTypeDefinitionCreation) {
                erManagement.setJson(jsonSchema);
                ret = erManagement.create();
            } else {
                ret = TypeMapper.serializeTypeDefinition((Type)typeDefinition);
            }
            return ret;
        }
        catch (SchemaAlreadyPresentException e) {
            throw e;
        }
        catch (SchemaException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SchemaCreationException((Throwable)ex);
        }
    }

    public String read(String typeName, boolean includeSubtypes) throws SchemaNotFoundException, SchemaException {
        return this.getSchema(typeName, includeSubtypes);
    }

    public String update(String typeName, AccessType accessType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException();
    }

    public String delete(String typeName, AccessType accessType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException();
    }

    static {
        baseElementTypes.add("PropertyElement");
        baseElementTypes.add("EntityElement");
        baseElementTypes.add("RelationElement");
        typeList = new HashSet();
        typeList.add("PropertyType");
        typeList.add("LinkedEntity");
        typeList.add("EntityType");
        typeList.add("ResourceType");
        typeList.add("FacetType");
        typeList.add("RelationType");
        typeList.add("IsRelatedToType");
        typeList.add("ConsistsOfType");
    }
}

