/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types.properties;

import com.fasterxml.jackson.databind.JsonNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyTypeDefinitionManagement
extends ElementManagement<OElement> {
    private static Logger logger = LoggerFactory.getLogger(PropertyTypeDefinitionManagement.class);
    protected String name;

    public PropertyTypeDefinitionManagement() {
        super(AccessType.PROPERTY_TYPE);
        this.elementType = "PropertyType";
    }

    public PropertyTypeDefinitionManagement(SecurityContext securityContext, ODatabaseDocument oDatabaseDocument) throws ResourceRegistryException {
        this();
        this.oDatabaseDocument = oDatabaseDocument;
        this.setWorkingContext(securityContext);
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getInstance().getSecurityContextByUUID(DatabaseEnvironment.SCHEMA_SECURITY_CONTEXT_UUID);
        }
        return this.workingContext;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)this.element.getProperty("name");
            }
        }
        return this.name;
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        return this.serializeSelfOnly();
    }

    protected OElement reallyCreate() throws AlreadyPresentException, ResourceRegistryException {
        logger.debug("Going to create {} for {}", (Object)"PropertyType", (Object)this.getName());
        return this.createElement();
    }

    protected OElement reallyUpdate() throws NotFoundException, ResourceRegistryException {
        logger.debug("Going to update {} for {}", (Object)"PropertyType", (Object)this.getName());
        OElement propertyTypeDefinition = this.getElement();
        propertyTypeDefinition = ElementManagement.updateProperties((OClass)this.oClass, (OElement)propertyTypeDefinition, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        return propertyTypeDefinition;
    }

    protected boolean reallyDelete() throws NotFoundException, ResourceRegistryException {
        logger.debug("Going to remove {} for {}", (Object)"EntityType", (Object)this.getName());
        this.getElement().delete();
        return true;
    }

    public OElement getElement() throws NotFoundException, ResourceRegistryException {
        if (this.element == null) {
            try {
                this.element = this.retrieveElement();
            }
            catch (NotFoundException e) {
                throw e;
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else if (this.reload) {
            this.element.reload();
        }
        return this.element;
    }

    public OElement retrieveElement() throws NotFoundException, ResourceRegistryException {
        try {
            if (this.getName() == null) {
                throw new NotFoundException("null name does not allow to retrieve the Element");
            }
            String select = "SELECT FROM " + this.elementType + " WHERE " + "name" + " = \"" + this.getName() + "\"";
            OResultSet resultSet = this.oDatabaseDocument.query(select, new HashMap());
            if (resultSet == null || !resultSet.hasNext()) {
                String error = String.format("No %s with name %s was found", this.elementType, this.getName());
                logger.info(error);
                throw new NotFoundException(error);
            }
            OResult oResult = resultSet.next();
            OElement element = ElementManagement.getElementFromOptional((Optional)oResult.getElement());
            logger.trace("{} with id {} is : {}", new Object[]{this.elementType, this.getName(), Utility.toJsonString((OElement)element, (boolean)true)});
            if (resultSet.hasNext()) {
                throw new ResourceRegistryException("Found more than one " + this.elementType + " with name " + this.getName() + ". This is a fatal error please contact Admnistrator");
            }
            return element;
        }
        catch (NotFoundException e) {
            throw this.getSpecificElementNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    protected OElement createElement() throws AlreadyPresentException, ResourceRegistryException {
        try {
            this.element = new ODocument(this.elementType);
            ElementManagement.updateProperties((OClass)this.oClass, (OElement)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
            logger.debug("Created {} is {}", (Object)"PropertyType", (Object)Utility.toJsonString((OElement)this.element, (boolean)true));
            return this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{OElement.class.getSimpleName(), this.accessType.getName(), this.elementType, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.elementType + " with " + this.jsonNode, e.getCause());
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected boolean reallyAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected NotFoundException getSpecificElementNotFoundException(NotFoundException e) {
        return new SchemaNotFoundException(e.getMessage(), e.getCause());
    }

    protected AlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new SchemaAlreadyPresentException(message);
    }

    protected AvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        throw new UnsupportedOperationException();
    }
}

