/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextUtility {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtility.class);
    private Map<String, UUID> contextUUIDs = new HashMap();
    private Map<UUID, SecurityContext> contexts = new HashMap();
    private static ContextUtility contextUtility;
    private static final InheritableThreadLocal<Boolean> hierarchicMode;

    public static ContextUtility getInstance() {
        if (contextUtility == null) {
            contextUtility = new ContextUtility();
        }
        return contextUtility;
    }

    private ContextUtility() {
    }

    public static InheritableThreadLocal<Boolean> getHierarchicMode() {
        return hierarchicMode;
    }

    private static String getCurrentContextFullName() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    public static SecurityContext getCurrentSecurityContext() throws ResourceRegistryException {
        String fullName = ContextUtility.getCurrentContextFullName();
        if (fullName == null) {
            throw new ContextException("Null Token and Scope. Please set your token first.");
        }
        return ContextUtility.getInstance().getSecurityContextByFullName(fullName);
    }

    public static AdminSecurityContext getAdminSecurityContext() throws ResourceRegistryException {
        AdminSecurityContext adminSecurityContext = (AdminSecurityContext)ContextUtility.getInstance().getSecurityContextByUUID(DatabaseEnvironment.ADMIN_SECURITY_CONTEXT_UUID);
        return adminSecurityContext;
    }

    public synchronized void removeFromCache(UUID uuid, boolean fullNameOnly) throws ResourceRegistryException {
        for (String fullName : this.contextUUIDs.keySet()) {
            UUID uuidKey = (UUID)this.contextUUIDs.get(fullName);
            if (uuidKey.compareTo(uuid) != 0) continue;
            this.contextUUIDs.remove(fullName);
            if (!fullNameOnly) {
                this.contexts.remove(uuid);
            }
            return;
        }
    }

    public synchronized void addSecurityContext(SecurityContext securityContext) {
        this.contexts.put(securityContext.getUUID(), securityContext);
    }

    public synchronized void addSecurityContext(String fullname, SecurityContext securityContext) {
        this.contextUUIDs.put(fullname, securityContext.getUUID());
        this.contexts.put(securityContext.getUUID(), securityContext);
    }

    private synchronized SecurityContext getSecurityContextByFullName(String fullName) throws ContextException {
        try {
            SecurityContext securityContext = null;
            logger.trace("Trying to get {} for {}", (Object)SecurityContext.class.getSimpleName(), (Object)fullName);
            UUID uuid = (UUID)this.contextUUIDs.get(fullName);
            if (uuid == null) {
                logger.trace("{} for {} is not in cache. Going to get it", (Object)SecurityContext.class.getSimpleName(), (Object)fullName);
                OVertex contextVertex = this.getContextVertexByFullName(fullName);
                uuid = Utility.getUUID((OElement)contextVertex);
                securityContext = this.getSecurityContextByUUID(uuid, contextVertex);
                this.addSecurityContext(fullName, securityContext);
            } else {
                securityContext = (SecurityContext)this.contexts.get(uuid);
            }
            return securityContext;
        }
        catch (ContextException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException("Unable to restrive Context UUID from current Context", (Throwable)e);
        }
    }

    public SecurityContext getSecurityContextByUUID(UUID uuid) throws ResourceRegistryException {
        return this.getSecurityContextByUUID(uuid, null);
    }

    public static ODatabaseDocument getCurrentODatabaseDocumentFromThreadLocal() {
        ODatabaseDocumentInternal current = null;
        try {
            current = ODatabaseRecordThreadLocal.instance().get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return current;
    }

    private OVertex getContextVertexByUUID(UUID uuid) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        OVertex oVertex = (OVertex)Utility.getElementByUUID((ODatabaseDocument)ContextUtility.getAdminSecurityContext().getDatabaseDocument(SecurityContext.PermissionMode.READER), (String)"Context", (UUID)uuid, OVertex.class);
        if (current != null) {
            current.activateOnCurrentThread();
        }
        return oVertex;
    }

    private SecurityContext getSecurityContextByUUID(UUID uuid, OVertex contextVertex) throws ResourceRegistryException {
        SecurityContext securityContext = (SecurityContext)this.contexts.get(uuid);
        if (securityContext == null) {
            securityContext = new SecurityContext(uuid);
            try {
                OVertex parentVertex;
                if (contextVertex == null) {
                    contextVertex = this.getContextVertexByUUID(uuid);
                }
                if ((parentVertex = (OVertex)contextVertex.getVertices(ODirection.IN, new String[]{"IsParentOf"}).iterator().next()) != null) {
                    UUID parentUUID = Utility.getUUID((OElement)parentVertex);
                    securityContext.setParentSecurityContext(this.getSecurityContextByUUID(parentUUID, parentVertex));
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.contexts.put(uuid, securityContext);
        }
        return securityContext;
    }

    protected UUID getContextUUIDFromFullName(String fullName) throws ResourceRegistryException {
        OVertex contextVertex = this.getContextVertexByFullName(fullName);
        return Utility.getUUID((OElement)contextVertex);
    }

    private OVertex getContextVertexByFullName(String fullName) throws ResourceRegistryException {
        logger.trace("Going to get {} {} with full name '{}'", new Object[]{"Context", OVertex.class.getSimpleName(), fullName});
        ScopeBean scopeBean = new ScopeBean(fullName);
        String name = scopeBean.name();
        String select = "SELECT FROM " + Context.class.getSimpleName() + " WHERE " + "name" + " = :name";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        OResultSet resultSet = ContextUtility.getAdminSecurityContext().getDatabaseDocument(SecurityContext.PermissionMode.READER).query(select, map);
        if (resultSet == null || !resultSet.hasNext()) {
            throw new ContextNotFoundException("Error retrieving context with name " + fullName);
        }
        OResult oResult = resultSet.next();
        OVertex context = (OVertex)ElementManagement.getElementFromOptional((Optional)oResult.getVertex());
        logger.trace("Context Representing Vertex : {}", (Object)Utility.toJsonString((OElement)context, (boolean)true));
        if (resultSet.hasNext()) {
            throw new ContextNotFoundException("Found more than one context with name " + name + "but required the one with path" + fullName + ". Please Reimplement the query");
        }
        if (current != null) {
            current.activateOnCurrentThread();
        }
        return context;
    }

    static {
        hierarchicMode = new /* Unavailable Anonymous Inner Class!! */;
    }
}

