/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Optional;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.query.Query;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static Logger logger = LoggerFactory.getLogger(QueryImpl.class);

    public String query(String query, Integer limit, String fetchPlan, boolean raw) throws InvalidQueryException {
        if (limit == null) {
            limit = 20;
        }
        limit = limit <= 0 ? -1 : limit;
        ODatabaseDocument oDatabaseDocument = null;
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            SecurityContext securityContext = ContextUtility.getCurrentSecurityContext();
            oDatabaseDocument = securityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            oDatabaseDocument.begin();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(query);
            stringBuffer.append(" limit :limit");
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("limit", limit);
            if (fetchPlan != null) {
                stringBuffer.append(" fetchplan ");
                stringBuffer.append(fetchPlan);
                logger.debug("Going to execute query '{} limit {} fetchPlan {}'", new Object[]{query, limit, fetchPlan});
            } else {
                logger.debug("Going to execute query '{} limit {}'", (Object)query, (Object)limit);
            }
            OResultSet resultSet = oDatabaseDocument.query(stringBuffer.toString(), map);
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = objectMapper.createArrayNode();
            while (resultSet.hasNext()) {
                OResult oResult = resultSet.next();
                OElement element = ElementManagement.getElementFromOptional((Optional)oResult.getElement());
                try {
                    JsonNode jsonNode = null;
                    if (raw) {
                        jsonNode = Utility.toJsonNode((OElement)element, (boolean)false);
                    } else {
                        ElementManagement erManagement = ElementManagementUtility.getERManagement((SecurityContext)securityContext, (ODatabaseDocument)oDatabaseDocument, (OElement)element);
                        jsonNode = erManagement.serializeAsJson();
                    }
                    arrayNode.add(jsonNode);
                }
                catch (ResourceRegistryException e) {
                    logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)element.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
                }
            }
            String string = objectMapper.writeValueAsString((Object)arrayNode);
            return string;
        }
        catch (Exception e) {
            throw new InvalidQueryException(e.getMessage());
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String gremlinQuery(String query) throws InvalidQueryException {
        throw new UnsupportedOperationException();
    }
}

