/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import com.orientechnologies.orient.core.record.ODirection;
import com.tinkerpop.blueprints.Direction;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.query.QueryImpl;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.types.SchemaManagementImpl;

@Path(value="access")
public class Access
extends BaseRest {
    @GET
    @Path(value="contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAllContexts() throws ResourceRegistryException {
        this.logger.info("Requested to read all {}s", (Object)"Context");
        CalledMethodProvider.instance.set("listContexts");
        ContextManagement contextManagement = new ContextManagement();
        return contextManagement.all(false);
    }

    @GET
    @Path(value="contexts/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getContext(@PathParam(value="UUID") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        if (uuid.compareTo("CURRENT_CONTEXT") == 0) {
            uuid = ContextUtility.getCurrentSecurityContext().getUUID().toString();
        }
        this.logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        CalledMethodProvider.instance.set("readContext");
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.read();
    }

    @GET
    @Path(value="types/{TYPE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getType(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        this.logger.info("Requested Schema for type {}", (Object)type);
        CalledMethodProvider.instance.set("readType");
        SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
        return schemaManagement.read(type, polymorphic.booleanValue());
    }

    @GET
    @Path(value="instances/{TYPE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAllInstances(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="true") Boolean polymorphic) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested all {}instances of {}", (Object)(polymorphic != false ? "polymorphic " : ""), (Object)type);
        this.checkHierarchicalMode();
        this.checkIncludeInstancesContexts();
        CalledMethodProvider.instance.set("listInstances");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        return erManagement.all(polymorphic.booleanValue());
    }

    @HEAD
    @Path(value="instances/{TYPE_NAME}/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response instanceExists(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to check if {} with id {} exists", (Object)type, (Object)uuid);
        this.checkHierarchicalMode();
        this.checkIncludeInstancesContexts();
        CalledMethodProvider.instance.set("existInstance");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        try {
            erManagement.setUUID(UUID.fromString(uuid));
            boolean found = erManagement.exists();
            if (found) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AvailableInAnotherContextException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    @GET
    @Path(value="instances/{TYPE_NAME}/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getInstance(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read {} with id {}", (Object)type, (Object)uuid);
        this.checkHierarchicalMode();
        this.checkIncludeInstancesContexts();
        CalledMethodProvider.instance.set("readInstance");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setElementType(type);
        erManagement.setUUID(UUID.fromString(uuid));
        return erManagement.read();
    }

    @GET
    @Path(value="instances/{TYPE_NAME}/{UUID}/contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getInstanceContexts(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String instanceId) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to get contexts of {} with UUID {}", (Object)type, (Object)instanceId);
        CalledMethodProvider.instance.set("getInstanceContexts");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(instanceId));
        return erManagement.getContexts();
    }

    @GET
    @Path(value="query")
    @Produces(value={"application/json;charset=UTF-8"})
    public String query(@QueryParam(value="q") String query, @QueryParam(value="limit") Integer limit, @QueryParam(value="fetchPlan") @DefaultValue(value="*:-1") String fetchPlan, @QueryParam(value="raw") @DefaultValue(value="false") Boolean raw) throws InvalidQueryException {
        this.logger.info("Requested query (fetch plan {}, limit : {}, Raw : raw):\n{}", new Object[]{fetchPlan, limit, query, raw});
        this.checkHierarchicalMode();
        this.checkIncludeInstancesContexts();
        CalledMethodProvider.instance.set("rawQuery");
        QueryImpl queryManager = new QueryImpl();
        return queryManager.query(query, limit, fetchPlan, raw.booleanValue());
    }

    @GET
    @Path(value="query/{RESOURCE_TYPE_NAME}/{RELATION_TYPE_NAME}/{REFERENCE_TYPE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAllResourcesHavingFacet(@PathParam(value="RESOURCE_TYPE_NAME") String resourcetype, @PathParam(value="RELATION_TYPE_NAME") String relationType, @PathParam(value="REFERENCE_TYPE_NAME") String referenceType, @QueryParam(value="reference") String reference, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic, @QueryParam(value="direction") @DefaultValue(value="out") String direction, @Context UriInfo uriInfo) throws ResourceRegistryException {
        this.logger.info("Requested {} instances having a(n) {} ({}={}} with {} ({}={})", new Object[]{resourcetype, relationType, "direction", direction, referenceType, "polymorphic", polymorphic});
        this.checkHierarchicalMode();
        this.checkIncludeInstancesContexts();
        CalledMethodProvider.instance.set("query");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)resourcetype);
        if (erManagement instanceof ResourceManagement) {
            String error;
            UUID refereceUUID = null;
            ODirection directionEnum = ODirection.OUT;
            HashMap<String, Object> constraint = new HashMap<String, Object>();
            MultivaluedMap multivaluedMap = uriInfo.getQueryParameters();
            for (String key : multivaluedMap.keySet()) {
                if (key.compareTo("polymorphic") == 0 || key.compareTo("gcube-token") == 0 || key.compareTo("gcube-scope") == 0) continue;
                constraint.put(key, multivaluedMap.getFirst((Object)key));
            }
            if (reference != null) {
                try {
                    refereceUUID = UUID.fromString(reference);
                }
                catch (Exception e) {
                    error = String.format("%s is not a valid %s", reference, UUID.class.getSimpleName());
                    throw new InvalidQueryException(error);
                }
            }
            try {
                directionEnum = ODirection.valueOf((String)direction.toUpperCase());
            }
            catch (Exception e) {
                error = String.format("%s is not a valid. Allowed values are %s", direction, Direction.values());
                throw new InvalidQueryException(error);
            }
            return ((ResourceManagement)erManagement).query(relationType, referenceType, refereceUUID, directionEnum, polymorphic.booleanValue(), constraint);
        }
        String error = String.format("%s is not a %s type", resourcetype, "Resource");
        throw new InvalidQueryException(error);
    }
}

