/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="sharing")
public class SharingManagement {
    private static Logger logger = LoggerFactory.getLogger(SharingManagement.class);

    @GET
    @Path(value="{TYPE_NAME}/{UUID}contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getInstanceContexts(@PathParam(value="CONTEXT_UUID") String contextId, @PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String instanceId) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to get contexts of {} with UUID {}", (Object)type, (Object)instanceId);
        CalledMethodProvider.instance.set("getInstanceContexts");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(instanceId));
        return erManagement.getContexts();
    }

    @PUT
    @Path(value="{TYPE_NAME}/{UUID}contexts/{CONTEXT_UUID}")
    public boolean add(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String instanceId, @PathParam(value="CONTEXT_UUID") String contextId) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to add {} with UUID {} to {} with UUID {}", new Object[]{type, instanceId, "Context", contextId});
        CalledMethodProvider.instance.set("addToContext");
        ElementManagement elementManagement = ElementManagementUtility.getERManagement((String)type);
        elementManagement.setUUID(UUID.fromString(instanceId));
        return elementManagement.addToContext(UUID.fromString(contextId));
    }

    @DELETE
    @Path(value="{TYPE_NAME}/{UUID}contexts/{CONTEXT_UUID}")
    public Response remove(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String instanceId, @PathParam(value="CONTEXT_UUID") String contextId) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to remove {} with UUID {} to {} with UUID {}", new Object[]{type, instanceId, "Context", contextId});
        CalledMethodProvider.instance.set("removeFromContext");
        ElementManagement elementManagement = ElementManagementUtility.getERManagement((String)type);
        elementManagement.setUUID(UUID.fromString(instanceId));
        elementManagement.removeFromContext(UUID.fromString(contextId));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

