/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.base;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ElementManagementUtility {
    private static Logger logger = LoggerFactory.getLogger(ElementManagementUtility.class);

    public static AccessType getBaseAccessType(String type) throws ResourceRegistryException {
        OClass oClass = ElementManagementUtility.getTypeSchema((String)type, null);
        if (oClass.isSubClassOf("Resource")) {
            return AccessType.RESOURCE;
        }
        if (oClass.isSubClassOf("Facet")) {
            return AccessType.FACET;
        }
        if (oClass.isSubClassOf("ConsistsOf")) {
            return AccessType.CONSISTS_OF;
        }
        if (oClass.isSubClassOf("IsRelatedTo")) {
            return AccessType.IS_RELATED_TO;
        }
        if (oClass.isSubClassOf("Property")) {
            return AccessType.PROPERTY;
        }
        throw new ResourceRegistryException(type + "is not a base type");
    }

    public static ElementManagement getERManagement(String type) throws ResourceRegistryException {
        OClass oClass = ElementManagementUtility.getTypeSchema((String)type, null);
        ResourceManagement erManagement = null;
        if (oClass.isSubClassOf("Resource")) {
            erManagement = new ResourceManagement();
        } else if (oClass.isSubClassOf("Facet")) {
            erManagement = new FacetManagement();
        } else if (oClass.isSubClassOf("ConsistsOf")) {
            erManagement = new ConsistsOfManagement();
        } else if (oClass.isSubClassOf("IsRelatedTo")) {
            erManagement = new IsRelatedToManagement();
        }
        if (erManagement == null) {
            throw new ResourceRegistryException(String.format("%s is not querable", type.toString()));
        }
        erManagement.setElementType(type);
        return erManagement;
    }

    public static ElementManagement<?> getERManagement(SecurityContext workingContext, ODatabaseDocument orientGraph, OElement element) throws ResourceRegistryException {
        if (element instanceof OVertex) {
            return ElementManagementUtility.getEntityManagement((SecurityContext)workingContext, (ODatabaseDocument)orientGraph, (OVertex)((OVertex)element));
        }
        if (element instanceof OEdge) {
            return ElementManagementUtility.getRelationManagement((SecurityContext)workingContext, (ODatabaseDocument)orientGraph, (OEdge)((OEdge)element));
        }
        throw new ResourceRegistryException(String.format("%s is not a %s nor a %s", element.getClass().getSimpleName(), "Entity", "Relation"));
    }

    public static OElement getAnyElementByUUID(UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            return Utility.getElementByUUIDAsAdmin(null, (UUID)uuid, OVertex.class);
        }
        catch (NotFoundException e) {
            return Utility.getElementByUUIDAsAdmin(null, (UUID)uuid, OEdge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    private static OElement getAnyElementByUUID(ODatabaseDocument orientGraph, UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            return Utility.getElementByUUID((ODatabaseDocument)orientGraph, null, (UUID)uuid, OVertex.class);
        }
        catch (NotFoundException e) {
            return Utility.getElementByUUID((ODatabaseDocument)orientGraph, null, (UUID)uuid, OEdge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static ElementManagement getERManagementFromUUID(SecurityContext workingContext, ODatabaseDocument orientGraph, UUID uuid) throws ResourceRegistryException {
        try {
            OElement element = ElementManagementUtility.getAnyElementByUUID((ODatabaseDocument)orientGraph, (UUID)uuid);
            return ElementManagementUtility.getERManagement((SecurityContext)workingContext, (ODatabaseDocument)orientGraph, (OElement)element);
        }
        catch (Exception e) {
            throw new ResourceRegistryException(String.format("%s does not belong to an %s nor to a %s", uuid.toString(), "Entity", "Relation"));
        }
    }

    public static EntityManagement getEntityManagement(SecurityContext workingContext, ODatabaseDocument oDatabaseDocument, OVertex vertex) throws ResourceRegistryException {
        if (oDatabaseDocument == null) {
            throw new ResourceRegistryException(ODatabaseDocument.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        if (vertex == null) {
            throw new ResourceRegistryException(OVertex.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        OClass oClass = null;
        try {
            oClass = ElementManagement.getOClass((OElement)vertex);
        }
        catch (Exception e) {
            String error = String.format("Unable to detect type of %s. %s", vertex.toString(), "This is really strange and should not occur. Please contact the system administrator.");
            logger.error(error, (Throwable)e);
            throw new ResourceRegistryException(error);
        }
        ResourceManagement entityManagement = null;
        if (oClass.isSubClassOf("Resource")) {
            entityManagement = new ResourceManagement(workingContext, oDatabaseDocument);
        } else if (oClass.isSubClassOf("Facet")) {
            entityManagement = new FacetManagement(workingContext, oDatabaseDocument);
        } else {
            String error = String.format("{%s is not a %s nor a %s. %s", vertex, "Resource", "Facet", "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        entityManagement.setElement((OElement)vertex);
        return entityManagement;
    }

    public static RelationManagement getRelationManagement(SecurityContext workingContext, ODatabaseDocument oDatabaseDocument, OEdge edge) throws ResourceRegistryException {
        if (oDatabaseDocument == null) {
            throw new ResourceRegistryException(ODatabaseDocument.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        if (edge == null) {
            throw new ResourceRegistryException(OEdge.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        OClass oClass = ElementManagement.getOClass((OElement)edge);
        ConsistsOfManagement relationManagement = null;
        if (oClass.isSubClassOf("ConsistsOf")) {
            relationManagement = new ConsistsOfManagement(workingContext, oDatabaseDocument);
        } else if (oClass.isSubClassOf("IsRelatedTo")) {
            relationManagement = new IsRelatedToManagement(workingContext, oDatabaseDocument);
        } else {
            String error = String.format("{%s is not a %s nor a %s. %s", edge, "ConsistsOf", "IsRelatedTo", "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        relationManagement.setElement((OElement)edge);
        return relationManagement;
    }

    public static OClass getTypeSchema(ODatabaseDocument oDatabaseDocument, String type, AccessType accessType) throws SchemaException, SchemaNotFoundException {
        OMetadata oMetadata = oDatabaseDocument.getMetadata();
        OSchema oSchema = oMetadata.getSchema();
        return ElementManagementUtility.getTypeSchema((OSchema)oSchema, (String)type, (AccessType)accessType);
    }

    public static OClass getTypeSchema(OSchema oSchema, String type, AccessType accessType) throws SchemaException, SchemaNotFoundException {
        try {
            OClass oClass = oSchema.getClass(type);
            if (oClass == null) {
                throw new SchemaNotFoundException(type + " was not registered");
            }
            if (accessType != null && type.compareTo(accessType.getName()) != 0 && !oClass.isSubClassOf(accessType.getName())) {
                throw new SchemaException(type + " is not a " + accessType.getName());
            }
            return oClass;
        }
        catch (SchemaNotFoundException snfe) {
            throw snfe;
        }
        catch (Exception e) {
            throw new SchemaException(e.getMessage());
        }
    }

    public static OClass getTypeSchema(String type, AccessType accessType) throws SchemaException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            logger.debug("Getting {} Type {} schema", (Object)(accessType != null ? accessType.getName() : ""), (Object)type);
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            OClass oClass = ElementManagementUtility.getTypeSchema((ODatabaseDocument)oDatabaseDocument, (String)type, (AccessType)accessType);
            return oClass;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }
}

