/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.base.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.base.relations.RelationElementManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;

public abstract class EntityElementManagement<E extends EntityElement>
extends ElementManagement<OVertex> {
    protected Map<String, RelationElementManagement> relationManagements;

    protected EntityElementManagement(AccessType accessType) {
        super(accessType);
        this.ignoreKeys.add("header");
        this.ignoreStartWithKeys.add("in_".toLowerCase());
        this.ignoreStartWithKeys.add("out_".toLowerCase());
        this.ignoreStartWithKeys.add("in_".toUpperCase());
        this.ignoreStartWithKeys.add("out_".toUpperCase());
        this.relationManagements = new HashMap();
    }

    protected EntityElementManagement(AccessType accessType, SecurityContext workingContext, ODatabaseDocument oDatabaseDocument) {
        this(accessType);
        this.oDatabaseDocument = oDatabaseDocument;
        this.setWorkingContext(workingContext);
    }

    protected RelationElementManagement getBaseRelationManagement(OEdge edge) throws ResourceRegistryException {
        String id = edge.getIdentity().toString();
        RelationElementManagement relationManagement = (RelationElementManagement)this.relationManagements.get(id);
        if (relationManagement == null) {
            relationManagement = ElementManagementUtility.getRelationManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OEdge)edge);
            this.relationManagements.put(id, relationManagement);
        }
        return relationManagement;
    }

    protected void addToRelationManagement(RelationElementManagement baseRelationManagement) throws ResourceRegistryException {
        OElement elem = baseRelationManagement.getElement();
        String id = elem.getIdentity().toString();
        if (this.relationManagements.get(id) != null && this.relationManagements.get(id) != baseRelationManagement) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Two different instance of ");
            errorMessage.append(baseRelationManagement.getClass().getSimpleName());
            errorMessage.append(" point to the same ");
            errorMessage.append(elem.getClass().getSimpleName());
            errorMessage.append(". ");
            errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(errorMessage.toString());
        }
        this.relationManagements.put(id, baseRelationManagement);
    }

    protected static JsonNode addRelation(JsonNode sourceResource, JsonNode relation, String arrayKey) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode relationArray = objectMapper.createArrayNode();
        try {
            if (sourceResource.has(arrayKey)) {
                relationArray = (ArrayNode)sourceResource.get(arrayKey);
            }
            relationArray.add(relation);
            ((ObjectNode)sourceResource).replace(arrayKey, (JsonNode)relationArray);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return sourceResource;
    }

    protected OVertex createVertex() throws EntityAlreadyPresentException, ResourceRegistryException {
        this.logger.trace("Going to create {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.elementType, this.jsonNode});
        try {
            if (this.oClass.isAbstract()) {
                String error = String.format("Trying to create an instance of %s of type %s which is abstract. The operation will be aborted.", this.accessType.getName(), this.elementType);
                throw new ResourceRegistryException(error);
            }
            OVertex vertexEntity = this.oDatabaseDocument.newVertex(this.elementType);
            try {
                OVertex v;
                if (this.uuid != null && (v = (OVertex)this.getElement()) != null) {
                    String error = String.format("A %s with UUID %s already exist", this.elementType, this.uuid.toString());
                    throw this.getSpecificERAlreadyPresentException(error);
                }
            }
            catch (NotFoundException e) {
                try {
                    OElement el = ElementManagementUtility.getAnyElementByUUID((UUID)this.uuid);
                    String error = String.format("UUID %s is already used by another %s. This is not allowed.", this.uuid.toString(), el instanceof OVertex ? "Entity" : "Relation");
                    throw this.getSpecificERAvailableInAnotherContextException(error);
                }
                catch (NotFoundException notFoundException) {
                }
            }
            catch (AvailableInAnotherContextException e) {
                throw e;
            }
            this.element = vertexEntity;
            if (this.accessType != AccessType.RESOURCE) {
                ElementManagement.updateProperties((OClass)this.oClass, (OElement)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
            }
            this.logger.info("Created {} is {}", (Object)OVertex.class.getSimpleName(), (Object)Utility.toJsonString((OElement)this.element, (boolean)true));
            return (OVertex)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.elementType, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.elementType + " with " + this.jsonNode, e.getCause());
        }
    }
}

