/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.security;

import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.QueryTemplatesSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTemplatesSecurityContext
extends SecurityContext {
    private static Logger logger = LoggerFactory.getLogger(SecurityContext.class);
    private static final String QUERY_TEMPLATES_SECURITY_CONTEXT = "dddddddd-dddd-dddd-dddd-dddddddddddd";
    private static final UUID QUERY_TEMPLATES_SECURITY_CONTEXT_UUID = UUID.fromString(QUERY_TEMPLATES_SECURITY_CONTEXT);
    private static QueryTemplatesSecurityContext instance;

    public static QueryTemplatesSecurityContext getInstance() throws ResourceRegistryException {
        if (instance == null) {
            instance = new QueryTemplatesSecurityContext();
            ContextUtility contextUtility = ContextUtility.getInstance();
            contextUtility.addSecurityContext(QUERY_TEMPLATES_SECURITY_CONTEXT, (SecurityContext)instance);
        }
        return instance;
    }

    private QueryTemplatesSecurityContext() throws ResourceRegistryException {
        super(QUERY_TEMPLATES_SECURITY_CONTEXT_UUID, false);
    }

    protected ORole addExtraRules(ORole role, SecurityContext.PermissionMode permissionMode) {
        logger.trace("Adding extra rules for {}", (Object)role.getName());
        switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$contexts$security$SecurityContext$PermissionMode[permissionMode.ordinal()]) {
            case 1: {
                role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
                role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_ALL);
                role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
                break;
            }
            case 2: {
                role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_READ);
                role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_READ);
                role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_READ);
                break;
            }
        }
        return role;
    }
}

