/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base.entities;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryEntity;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryConsistsOf;

public class JsonQueryFacet
extends JsonQueryEntity {
    public static final String _IN = "_in";

    public JsonQueryFacet(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
        super(jsonQuery, AccessType.FACET);
        this.fieldNamesToRemove.add(_IN);
    }

    public StringBuffer analize(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
        StringBuffer newBuffer = new StringBuffer();
        boolean entry = this.entryPoint;
        if (this.jsonNode.has(_IN)) {
            if (!this.entryPoint) {
                throw new InvalidQueryException("_in property cannot be used in a facet if it is not the entry object");
            }
            JsonNode consistsOfNode = this.jsonNode.get(_IN);
            JsonQueryConsistsOf jsonQueryConsistsOf = new JsonQueryConsistsOf(consistsOfNode);
            jsonQueryConsistsOf.setEntryPoint(this.entryPoint);
            jsonQueryConsistsOf.setDirection(Direction.OUT);
            stringBuffer = jsonQueryConsistsOf.analize(stringBuffer);
            entry = false;
        }
        int size = this.jsonNode.size();
        newBuffer.append("SELECT FROM ");
        if (!entry) {
            newBuffer.append("( ");
            newBuffer.append("TRAVERSE inV(\"");
        }
        newBuffer.append(this.type);
        if (!entry) {
            newBuffer.append("\") FROM ( ");
            newBuffer.append(stringBuffer);
            newBuffer.append(")");
            newBuffer.append(")");
        }
        if (size > 1) {
            newBuffer.append(" WHERE ");
            newBuffer.append(this.addConstraints(this.jsonNode, null, null));
        }
        return newBuffer;
    }
}

