/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.utils;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.utils.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utility {
    private static final Logger logger = LoggerFactory.getLogger(Utility.class);
    public static final String SHOULD_NOT_OCCUR_ERROR_MESSAGE = "This is really strange and should not occur. Please contact the system administrator.";

    public static JsonNode toJsonNode(OElement element, boolean raw) throws ResourceRegistryException {
        ORecord oRecord = element.getRecord();
        return Utility.toJsonNode((ORecord)oRecord, (boolean)raw);
    }

    public static JsonNode toJsonNode(ORecord oRecord, boolean raw) throws ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.readTree(Utility.toJsonString((ORecord)oRecord, (boolean)raw));
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static String toJsonString(OElement element, boolean raw) {
        ORecord oRecord = element.getRecord();
        return Utility.toJsonString((ORecord)oRecord, (boolean)raw);
    }

    public static String toJsonString(ORecord oRecord, boolean raw) {
        if (raw) {
            return oRecord.toJSON();
        }
        return oRecord.toJSON("class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <El extends OElement> El getElementByUUIDAsAdmin(String elementType, UUID uuid, Class<? extends El> clz) throws NotFoundException, ResourceRegistryException {
        ODatabaseDocument adminDatabaseDocument = null;
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            adminDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            OElement oElement = Utility.getElementByUUID((ODatabaseDocument)adminDatabaseDocument, (String)elementType, (UUID)uuid, clz);
            return (El)oElement;
        }
        finally {
            if (adminDatabaseDocument != null) {
                adminDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public static <El extends OElement> El getElementByUUID(ODatabaseDocument oDatabaseDocument, String elementType, UUID uuid, Class<? extends El> clz) throws NotFoundException, ResourceRegistryException {
        String select;
        OResultSet resultSet;
        if (elementType == null || elementType.compareTo("") == 0) {
            if (OVertex.class.isAssignableFrom(clz)) {
                elementType = "Entity";
            }
            if (OEdge.class.isAssignableFrom(clz)) {
                elementType = "Relation";
            }
        }
        if ((resultSet = oDatabaseDocument.query(select = "SELECT FROM " + elementType + " WHERE " + "header" + "." + "uuid" + " = \"" + uuid.toString() + "\"", new HashMap())) == null || !resultSet.hasNext()) {
            String error = String.format("No %s with UUID %s was found", elementType, uuid.toString());
            logger.debug(error);
            throw new NotFoundException(error);
        }
        OResult oResult = resultSet.next();
        OElement element = ElementManagementUtility.getElementFromOptional((Optional)oResult.getElement());
        logger.trace("{} with id {} is : {}", new Object[]{elementType, uuid.toString(), Utility.toJsonString((OElement)element, (boolean)true)});
        if (resultSet.hasNext()) {
            throw new ResourceRegistryException("Found more than one " + elementType + " with uuid " + uuid.toString() + ". This is a fatal error please contact Admnistrator");
        }
        return (El)element;
    }

    public static <P extends PropertyElement> P getPropertyDocument(Class<P> clz, OElement element, String property) throws ResourceRegistryException {
        try {
            ODocument oDocument = (ODocument)element.getProperty(property);
            PropertyElement e = (PropertyElement)ElementMapper.unmarshal(clz, (String)oDocument.toJSON());
            return (P)e;
        }
        catch (Exception ex) {
            String error = String.format("Error while getting %s from %s", property, Utility.toJsonString((OElement)element, (boolean)true));
            throw new ResourceRegistryException(error, (Throwable)ex);
        }
    }

    public static UUID getUUID(OElement element) throws ResourceRegistryException {
        Header header = HeaderUtility.getHeader((OElement)element);
        return header.getUUID();
    }
}

