package org.gcube.informationsystem.resourceregistry.queries.json.base.entities;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryConsistsOf;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryIsRelatedTo;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class JsonQueryResource extends JsonQueryEntity {
	
	public JsonQueryResource(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
		super(jsonQuery, AccessType.RESOURCE);
		fieldNamesToRemove.add(Resource.CONSISTS_OF_PROPERTY);
		fieldNamesToRemove.add(Resource.IS_RELATED_TO_PROPERTY);
	}
	
	@Override
	public StringBuffer analize(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
		if(!entryPoint) {
			StringBuffer newBuffer = new StringBuffer();
			newBuffer.append("TRAVERSE ");
			newBuffer.append(direction.name().toLowerCase());
			newBuffer.append("V(\"");
			newBuffer.append(type);
			newBuffer.append("\") FROM ( ");
			newBuffer.append(stringBuffer);
			newBuffer.append(")");
			stringBuffer = newBuffer;
		}
		
		boolean initFound = false;
		
		ArrayNode isRelatedToArray = (ArrayNode) jsonNode.get(Resource.IS_RELATED_TO_PROPERTY);
		if(isRelatedToArray!=null && isRelatedToArray.size()>0) {
			initFound = true;
			for(int i=0; i<isRelatedToArray.size(); i++) {
				JsonNode isRelatedToJsonNode = isRelatedToArray.get(i);
				JsonQueryIsRelatedTo jsonQueryIsRelatedTo = new JsonQueryIsRelatedTo(isRelatedToJsonNode);
				jsonQueryIsRelatedTo.setRequestedResourceType(type);
				jsonQueryIsRelatedTo.setEntryPoint(entryPoint && i==0);
				stringBuffer = jsonQueryIsRelatedTo.analize(stringBuffer);
			}
			
		}
		
		ArrayNode consistsOfArray = (ArrayNode) jsonNode.get(Resource.CONSISTS_OF_PROPERTY);
		if(consistsOfArray!=null && consistsOfArray.size()>0) {
			
			for(int i=0; i<consistsOfArray.size(); i++) {
				JsonNode consistsOfJsonNode = consistsOfArray.get(i);
				JsonQueryConsistsOf jsonQueryConsistsOf = new JsonQueryConsistsOf(consistsOfJsonNode);
				jsonQueryConsistsOf.setRequestedResourceType(type);
				jsonQueryConsistsOf.setDirection(Direction.IN);
				jsonQueryConsistsOf.setEntryPoint(entryPoint && !initFound && i==0);
				stringBuffer = jsonQueryConsistsOf.analize(stringBuffer);
			}
			initFound = true; // Must be set after the cycle and not before
		}
		
		if(!initFound) {
			if(entryPoint) {
				stringBuffer = new StringBuffer();
				stringBuffer.append("SELECT FROM ");
				stringBuffer.append(type);
			}
		}
		
		if(jsonNode.has(IdentifiableElement.HEADER_PROPERTY)) {
			StringBuffer newBuffer = new StringBuffer();
			newBuffer.append("SELECT FROM ( ");
			newBuffer.append(stringBuffer);
			newBuffer.append(") WHERE ");
			newBuffer.append(addConstraints(jsonNode, null, null));
			stringBuffer = newBuffer;
		}
		
		return stringBuffer;
	}
	
}
