/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.utils;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.security.Key;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;

public class EncryptedOrient
extends ODocument {
    public static final String NAME = "Encrypted";
    public static final String VALUE = "value";
    protected String decryptedValue;
    protected String dbEncryptedValue;
    protected String contextEncryptedValue;

    public EncryptedOrient() {
        super(NAME);
    }

    protected EncryptedOrient(String iClassName) {
        super(iClassName);
    }

    public String getEncryptedValue() {
        return (String)this.field(VALUE);
    }

    public void setEncryptedValue(String encryptedValue) {
        this.field(VALUE, (Object)encryptedValue);
    }

    public String toJSON(String iFormat) {
        return super.toJSON(iFormat);
    }

    public String getDecryptedValue() {
        return this.decryptedValue;
    }

    public String getDbEncryptedValue() {
        return this.dbEncryptedValue;
    }

    public String getContextEncryptedValue() {
        return this.contextEncryptedValue;
    }

    public void setDecryptedValue(String decryptedValue, boolean setEncryptedForContext) throws Exception {
        this.decryptedValue = decryptedValue;
        Key databaseKey = DatabaseEnvironment.getDatabaseKey();
        this.dbEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue, databaseKey);
        this.contextEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue);
        if (setEncryptedForContext) {
            this.setEncryptedValue(this.contextEncryptedValue);
        } else {
            this.setEncryptedValue(this.dbEncryptedValue);
        }
    }
}

