package org.gcube.informationsystem.resourceregistry.instances.model;

import java.util.Map;
import java.util.UUID;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;

public interface ERManagement {

	public boolean isHonourPropagationConstraintsInContextSharing();

	public void setHonourPropagationConstraintsInContextSharing(boolean honourPropagationConstraintsInContextSharing);

	public Map<UUID,JsonNode> getAffectedInstances();
	
	/**
	 * Set source security context to evaluate addToContext
	 * @param sourceSecurityContext the source security context
	 */
	public void setSourceSecurityContext(SecurityContext sourceSecurityContext);
	
	public SecurityContext getSourceSecurityContext();
	
	public void internalAddToContext()
			throws ContextException, ResourceRegistryException;

	public void addToContext(UUID contextUUID)
			throws SchemaViolationException, NotFoundException, ContextException, ResourceRegistryException;
	
	/**
	 * Set target security context of addToContext/removeFromContext
	 * @param targetSecurityContext
	 */
	public void setTargetSecurityContext(SecurityContext targetSecurityContext);
	
	public SecurityContext getTargetSecurityContext();
	
	public void internalRemoveFromContext()
			throws ContextException, ResourceRegistryException;

	public void removeFromContext(UUID contextUUID)
			throws SchemaViolationException, NotFoundException, ContextException, ResourceRegistryException;

	// public void sanityCheck() throws SchemaViolationException, ResourceRegistryException;

	public AvailableInAnotherContextException getSpecificAvailableInAnotherContextException(String message);

	public void setForceAddToContext(Boolean forceAddToContext);

}