package org.gcube.informationsystem.resourceregistry.instances.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext.PermissionMode;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;

public class ERManagementUtility {
	
	private static Logger staticLogger = LoggerFactory.getLogger(ERManagementUtility.class);
	
	public static Map<UUID,JsonNode> addToContextNoPropagationConstraint(Map<UUID, JsonNode> expectedInstances, UUID contextUUID, boolean dryRun)
			throws NotFoundException, ContextException, ResourceRegistryException {
		Set<UUID> instances = expectedInstances.keySet();
		staticLogger.info("Going to add {} to Context with UUID {} not following Propagation Constraints", instances, contextUUID);
		ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
		ODatabaseDocument oDatabaseDocument = null;
		try {
			AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
			oDatabaseDocument = adminSecurityContext.getDatabaseDocument(PermissionMode.WRITER);
			oDatabaseDocument.begin();
			
			SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
			
			// Map<UUID, JsonNode> enforcedInstances = new HashMap<>();
			
			Map<UUID, ElementManagement<?,?>> instancesManagement = new HashMap<>();
			Set<UUID> uuids = expectedInstances.keySet();
			for(UUID uuid : uuids) {
				String type = expectedInstances.get(uuid).get(Element.CLASS_PROPERTY).asText();
				ElementManagement<?,?> elementManagement = ElementManagementUtility.getERManagement(type);
				elementManagement.setWorkingContext(adminSecurityContext);
				elementManagement.setODatabaseDocument(oDatabaseDocument);
				elementManagement.setUUID(uuid);
				elementManagement.setElementType(type);
				elementManagement.setDryRun(dryRun);
				
				((ERManagement) elementManagement).setHonourPropagationConstraintsInContextSharing(false);
				// enforcedInstances.putAll(((ERManagement) elementManagement).internalAddToContext(targetSecurityContext));
				((ERManagement) elementManagement).setTargetSecurityContext(targetSecurityContext);
				((ERManagement) elementManagement).internalAddToContext();
				instancesManagement.put(uuid, elementManagement);
			}
			
			/*
			for(UUID uuid : uuids) {
				ElementManagement<?,?> elementManagement = instancesManagement.get(uuid);
				((ERManagement) elementManagement).contextSanityCheck(targetSecurityContext, expectedInstances);
			}
			*/
			
			/*
			SharingOperationValidator operationValidator = new SharingOperationValidator(expectedInstances, SharingOperation.ADD);
			if(operationValidator.isValidOperation(enforcedInstances)) {
				 oDatabaseDocument.commit();
			}
			*/
			
			oDatabaseDocument.activateOnCurrentThread();
			oDatabaseDocument.commit();
			staticLogger.info("{} successfully added to Context with UUID {} not following Propagation Constraints", instances, contextUUID);
			
			/*
			 * Without following the propagation constraint no instances are enforced to be added
			 * to the context. The sanity check ensure that the graph is consistent otherwise a
			 * an exception is raised.
			 * So no need to collect affected instances and expected instance can be returned.
			 */
			return expectedInstances;
		} catch(ResourceRegistryException e) {
			staticLogger.error("Unable to add {} to Context with UUID {} not following Propagation Constraints - Reason is {}", instances, contextUUID, e.getMessage());
			if(oDatabaseDocument != null) {
				oDatabaseDocument.rollback();
			}
			throw e;
		} catch(Exception e) {
			staticLogger.error("Unable to add {} to Context with UUID {} not following Propagation Constraints.", instances, contextUUID, e.getMessage());
			if(oDatabaseDocument != null) {
				oDatabaseDocument.rollback();
			}
			throw new ContextException(e);
		} finally {
			if(oDatabaseDocument != null) {
				oDatabaseDocument.close();
			}
			
			if(current!=null) {
				current.activateOnCurrentThread();
			}
		}
	}
	
	public static Map<UUID,JsonNode> removeFromContextNoPropagationConstraint(Map<UUID, JsonNode> expectedInstances, UUID contextUUID, boolean dryRun)
			throws NotFoundException, ContextException, ResourceRegistryException {
		Set<UUID> instances = expectedInstances.keySet();
		staticLogger.info("Going to remove {} from Context with UUID {} not following Propagation Constraints", instances, contextUUID);
		ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
		ODatabaseDocument oDatabaseDocument = null;
		try {
			AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
			oDatabaseDocument = adminSecurityContext.getDatabaseDocument(PermissionMode.WRITER);
			oDatabaseDocument.begin();
			
			SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
			
			//Map<UUID, JsonNode> enforcedInstances = new HashMap<>();
			
			Map<UUID, ElementManagement<?,?>> instancesManagement = new HashMap<>();
			for(UUID uuid : expectedInstances.keySet()) {
				String type = expectedInstances.get(uuid).get(Element.CLASS_PROPERTY).asText();
				ElementManagement<?,?> elementManagement = ElementManagementUtility.getERManagement(type);
				elementManagement.setWorkingContext(adminSecurityContext);
				elementManagement.setODatabaseDocument(oDatabaseDocument);
				elementManagement.setUUID(uuid);
				((ERManagement) elementManagement).setHonourPropagationConstraintsInContextSharing(false);
				elementManagement.setDryRun(dryRun);
				//enforcedInstances.putAll(((ERManagement) elementManagement).internalRemoveFromContext(targetSecurityContext));
				((ERManagement) elementManagement).setTargetSecurityContext(targetSecurityContext);
				((ERManagement) elementManagement).internalRemoveFromContext();
				instancesManagement.put(uuid, elementManagement);
			}
			
			for(UUID uuid : expectedInstances.keySet()) {
				ElementManagement<?,?> elementManagement = instancesManagement.get(uuid);
				// TODO
				elementManagement.sanityCheck();
			}
			
			/*
			SharingOperationValidator operationValidator = new SharingOperationValidator(expectedInstances, SharingOperation.REMOVE);
			
			if(operationValidator.isValidOperation(enforcedInstances)) {
				 oDatabaseDocument.commit();
			}
			*/
			
			oDatabaseDocument.commit();
			staticLogger.info("{} successfully removed from Context with UUID {} not following Propagation Constraints", instances, contextUUID);
			
			/*
			 * Without following the propagation constraint no instances are enforced to be added
			 * to the context. The sanity check ensure that the graph is consistent otherwise a
			 * an exception is raised.
			 * So no need to collect affected instances and expected instance can be returned.
			 */
			return expectedInstances;
		} catch(ResourceRegistryException e) {
			staticLogger.error("Unable to remove {} from Context with UUID {} not following Propagation Constraints - Reason is {}", instances, contextUUID, e.getMessage());
			if(oDatabaseDocument != null) {
				oDatabaseDocument.rollback();
			}
			throw e;
		} catch(Exception e) {
			staticLogger.error("Unable to remove {} from Context with UUID {} not following Propagation Constraints.", instances, contextUUID, e.getMessage());
			if(oDatabaseDocument != null) {
				oDatabaseDocument.rollback();
			}
			throw new ContextException(e);
		} finally {
			if(oDatabaseDocument != null) {
				oDatabaseDocument.close();
			}
			
			if(current!=null) {
				current.activateOnCurrentThread();
			}
		}
	}
	
}
