package org.gcube.informationsystem.resourceregistry.queries.operators;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public enum QueryConditionalOperator {

	EQ("$eq", " = ", "Matches values that are equal to a specified value."),
	GT("$gt", " > ", "Matches values that are greater than a specified value."),
	GTE("$gte", " >= ", "Matches values that are greater than or equal to a specified value."),
	LT("$lt", " < ", "Matches values that are less than a specified value."),
	LTE("$lte", " <= ", "Matches values that are less than or equal to a specified value."),
	NE("$ne", " <> ", "Matches all values that are not equal to a specified value."),
	
	IN("$in", " IN ", "Matches any of the values specified in an array.");
	
	protected final String operator;
	protected final String conditionalOperator;
	protected final String description;
	
	private QueryConditionalOperator(String operator, String conditionalOperator, String description) {
		this.operator = operator;
		this.conditionalOperator = conditionalOperator;
		this.description = description;
	}
	
	public String getOperator() {
		return operator;
	}
	
	public String getConditionalOperator() {
		return conditionalOperator;
	}

	public String getDescription() {
		return description;
	}
	
	private static Set<String> operators;
	private static Map<String,QueryConditionalOperator> operatorByKey;
	
	static {
		QueryConditionalOperator.operators = new HashSet<>();
		QueryConditionalOperator.operatorByKey = new HashMap<>();
		
		for(QueryConditionalOperator queryComparisonOperator : QueryConditionalOperator.values()) {
			QueryConditionalOperator.operators.add(queryComparisonOperator.getOperator());
			QueryConditionalOperator.operatorByKey.put(queryComparisonOperator.getOperator(), queryComparisonOperator);
		}
	}
	
	public static Set<String> getOperators() {
		return QueryConditionalOperator.operators;
	}
	
	public static QueryConditionalOperator getQueryComparisonOperator(String key) {
		return operatorByKey.get(key);
	}
}
