/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ERManagementUtility {
    private static Logger staticLogger = LoggerFactory.getLogger(ERManagementUtility.class);

    public static Map<UUID, JsonNode> addToContextNoPropagationConstraint(Map<UUID, JsonNode> expectedInstances, UUID contextUUID, boolean dryRun) throws NotFoundException, ContextException, ResourceRegistryException {
        Set<UUID> instances = expectedInstances.keySet();
        staticLogger.info("Going to add {} to Context with UUID {} not following Propagation Constraints", instances, (Object)contextUUID);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            oDatabaseDocument.begin();
            SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            HashMap<UUID, ElementManagement> instancesManagement = new HashMap<UUID, ElementManagement>();
            Set<UUID> uuids = expectedInstances.keySet();
            for (UUID uuid : uuids) {
                String type = expectedInstances.get(uuid).get("@class").asText();
                ElementManagement elementManagement = ElementManagementUtility.getERManagement((String)type);
                elementManagement.setWorkingContext((SecurityContext)adminSecurityContext);
                elementManagement.setODatabaseDocument(oDatabaseDocument);
                elementManagement.setUUID(uuid);
                elementManagement.setElementType(type);
                elementManagement.setDryRun(dryRun);
                ((ERManagement)elementManagement).setHonourPropagationConstraintsInContextSharing(false);
                ((ERManagement)elementManagement).setTargetSecurityContext(targetSecurityContext);
                ((ERManagement)elementManagement).internalAddToContext();
                instancesManagement.put(uuid, elementManagement);
            }
            oDatabaseDocument.activateOnCurrentThread();
            oDatabaseDocument.commit();
            staticLogger.info("{} successfully added to Context with UUID {} not following Propagation Constraints", instances, (Object)contextUUID);
            Map<UUID, JsonNode> map = expectedInstances;
            return map;
        }
        catch (ResourceRegistryException e) {
            staticLogger.error("Unable to add {} to Context with UUID {} not following Propagation Constraints - Reason is {}", new Object[]{instances, contextUUID, e.getMessage()});
            if (oDatabaseDocument != null) {
                oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            staticLogger.error("Unable to add {} to Context with UUID {} not following Propagation Constraints.", new Object[]{instances, contextUUID, e.getMessage()});
            if (oDatabaseDocument != null) {
                oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public static Map<UUID, JsonNode> removeFromContextNoPropagationConstraint(Map<UUID, JsonNode> expectedInstances, UUID contextUUID, boolean dryRun) throws NotFoundException, ContextException, ResourceRegistryException {
        Set<UUID> instances = expectedInstances.keySet();
        staticLogger.info("Going to remove {} from Context with UUID {} not following Propagation Constraints", instances, (Object)contextUUID);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            oDatabaseDocument.begin();
            SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            HashMap<UUID, ElementManagement> instancesManagement = new HashMap<UUID, ElementManagement>();
            for (UUID uuid : expectedInstances.keySet()) {
                String type = expectedInstances.get(uuid).get("@class").asText();
                ElementManagement elementManagement = ElementManagementUtility.getERManagement((String)type);
                elementManagement.setWorkingContext((SecurityContext)adminSecurityContext);
                elementManagement.setODatabaseDocument(oDatabaseDocument);
                elementManagement.setUUID(uuid);
                ((ERManagement)elementManagement).setHonourPropagationConstraintsInContextSharing(false);
                elementManagement.setDryRun(dryRun);
                ((ERManagement)elementManagement).setTargetSecurityContext(targetSecurityContext);
                ((ERManagement)elementManagement).internalRemoveFromContext();
                instancesManagement.put(uuid, elementManagement);
            }
            for (UUID uuid : expectedInstances.keySet()) {
                ElementManagement elementManagement = (ElementManagement)instancesManagement.get(uuid);
                elementManagement.sanityCheck();
            }
            oDatabaseDocument.commit();
            staticLogger.info("{} successfully removed from Context with UUID {} not following Propagation Constraints", instances, (Object)contextUUID);
            Map<UUID, JsonNode> map = expectedInstances;
            return map;
        }
        catch (ResourceRegistryException e) {
            staticLogger.error("Unable to remove {} from Context with UUID {} not following Propagation Constraints - Reason is {}", new Object[]{instances, contextUUID, e.getMessage()});
            if (oDatabaseDocument != null) {
                oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            staticLogger.error("Unable to remove {} from Context with UUID {} not following Propagation Constraints.", new Object[]{instances, contextUUID, e.getMessage()});
            if (oDatabaseDocument != null) {
                oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }
}

