/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.queries.operators.QueryConditionalOperator;
import org.gcube.informationsystem.resourceregistry.queries.operators.QueryLogicalOperator;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class JsonQueryERElement {
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected final String type;
    protected final JsonNode jsonNode;
    protected final AccessType accessType;
    protected final Set<String> fieldNamesToRemove;
    protected Direction direction;
    protected boolean entryPoint;

    public static void validateType(String type, AccessType requiredAccessType) throws SchemaException, ResourceRegistryException {
        AccessType accessType = TypesCache.getInstance().getCachedType(type).getAccessType();
        if (!accessType.equals((Object)requiredAccessType)) {
            throw new InvalidQueryException(type + "is not an expected " + requiredAccessType.getName() + " type");
        }
    }

    public JsonQueryERElement(JsonNode jsonQuery, AccessType accessType) throws SchemaException, ResourceRegistryException {
        this.type = jsonQuery.get("@class").asText();
        this.jsonNode = jsonQuery;
        this.accessType = accessType;
        this.entryPoint = false;
        this.fieldNamesToRemove = new HashSet();
        this.fieldNamesToRemove.add("@class");
        this.fieldNamesToRemove.add("@superClasses");
        JsonQueryERElement.validateType((String)this.type, (AccessType)this.accessType);
    }

    public String getType() {
        return this.type;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public boolean isEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(boolean entryPoint) {
        this.entryPoint = entryPoint;
    }

    public abstract StringBuffer analize(StringBuffer var1) throws SchemaNotFoundException, InvalidQueryException, SchemaException, ResourceRegistryException;

    protected StringBuffer addConstraints(JsonNode jsonNode, QueryLogicalOperator queryLogicalOperator, String fieldNamePrefix) throws InvalidQueryException {
        boolean first;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        if (queryLogicalOperator == null) {
            queryLogicalOperator = QueryLogicalOperator.AND;
        }
        JsonNode copiedJsonNode = jsonNode.deepCopy();
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)copiedJsonNode;
            objectNode.remove((Collection)this.fieldNamesToRemove);
            iterator = objectNode.fieldNames();
            first = true;
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                if (first) {
                    first = false;
                } else {
                    stringBuffer.append(queryLogicalOperator.getLogicalOperator());
                }
                JsonNode node = objectNode.get(fieldName);
                stringBuffer.append(this.evaluateNode(node, fieldName, fieldNamePrefix));
            }
        }
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)copiedJsonNode;
            iterator = arrayNode.iterator();
            first = true;
            while (iterator.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    stringBuffer.append(queryLogicalOperator.getLogicalOperator());
                }
                JsonNode node = (JsonNode)iterator.next();
                stringBuffer.append(this.evaluateNode(node, null, fieldNamePrefix));
            }
        }
        return stringBuffer;
    }

    protected StringBuffer evaluateNode(JsonNode jsonNode, String fieldName, String fieldNamePrefix) throws InvalidQueryException {
        StringBuffer stringBuffer = new StringBuffer();
        if (QueryLogicalOperator.getOperators().contains(fieldName)) {
            QueryLogicalOperator queryLogicalOperator = QueryLogicalOperator.getQueryLogicalOperator((String)fieldName);
            stringBuffer.append("(");
            stringBuffer.append(this.addConstraints(jsonNode, queryLogicalOperator, fieldNamePrefix));
            stringBuffer.append(")");
            return stringBuffer;
        }
        if (QueryConditionalOperator.getOperators().contains(fieldName)) {
            QueryConditionalOperator queryConditionalOperator = QueryConditionalOperator.getQueryComparisonOperator((String)fieldName);
            if (queryConditionalOperator == QueryConditionalOperator.IN) {
                throw new UnsupportedOperationException();
            }
            StringBuffer key = this.getKey(null, fieldNamePrefix);
            StringBuffer value = this.getValue(jsonNode);
            stringBuffer.append(this.addCondition(queryConditionalOperator, key, value));
            return stringBuffer;
        }
        if (jsonNode.isObject()) {
            StringBuffer newPrefix = new StringBuffer();
            if (fieldNamePrefix != null && fieldNamePrefix.compareTo("") != 0) {
                newPrefix.append(fieldNamePrefix);
                if (fieldName != null && fieldName.compareTo("") != 0) {
                    newPrefix.append(".");
                }
            }
            if (fieldName != null && fieldName.compareTo("") != 0) {
                newPrefix.append(fieldName);
            }
            stringBuffer.append(this.addConstraints(jsonNode, null, newPrefix.toString()));
            return stringBuffer;
        }
        if (jsonNode.isTextual() || jsonNode.isNumber()) {
            StringBuffer key = this.getKey(fieldName, fieldNamePrefix);
            StringBuffer value = this.getValue(jsonNode);
            stringBuffer.append(this.addCondition(QueryConditionalOperator.EQ, key, value));
        }
        return stringBuffer;
    }

    protected StringBuffer addCondition(QueryConditionalOperator queryConditionalOperator, StringBuffer key, StringBuffer value) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(key);
        stringBuffer.append(queryConditionalOperator.getConditionalOperator());
        stringBuffer.append(value);
        return stringBuffer;
    }

    protected StringBuffer getKey(String fieldName, String fieldNamePrefix) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fieldNamePrefix != null) {
            stringBuffer.append(fieldNamePrefix);
            if (fieldName != null && fieldName.compareTo("") != 0) {
                stringBuffer.append(".");
            }
        }
        if (fieldName != null) {
            stringBuffer.append(fieldName);
        }
        return stringBuffer;
    }

    protected StringBuffer getValue(JsonNode jsonNode) {
        StringBuffer stringBuffer = new StringBuffer();
        String value = jsonNode.asText();
        if (jsonNode.isNumber()) {
            stringBuffer.append(value);
        } else {
            stringBuffer.append("\"");
            stringBuffer.append(value);
            stringBuffer.append("\"");
        }
        return stringBuffer;
    }
}

