package org.gcube.informationsystem.resourceregistry;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class ResourceRegistryContextListener implements ServletContextListener {

	private static Logger logger = LoggerFactory.getLogger(ResourceRegistryContextListener.class);
	
	@Override
	public void contextDestroyed(ServletContextEvent servletContextEvent) {
		logger.info("Resource Registry is going to be stopped");
	}

	@Override
	public void contextInitialized(ServletContextEvent servletContextEvent) {
		logger.info("Resource Registry is going to be started");
	}
	
}
