/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.base.properties;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.security.Key;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.properties.Metadata;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.types.CachedType;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.resourceregistry.utils.EncryptedOrient;
import org.gcube.informationsystem.resourceregistry.utils.MetadataUtility;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.resourceregistry.utils.UUIDUtility;
import org.gcube.informationsystem.utils.TypeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyElementManagement {
    private static Logger logger = LoggerFactory.getLogger(PropertyElementManagement.class);
    public static final Set<String> PROPERTY_IGNORE_KEYS = new HashSet();
    public static final Set<String> PROPERTY_IGNORE_START_WITH_KEYS = new HashSet();

    public static ODocument getPropertyDocument(JsonNode jsonNodeOrig) throws ResourceRegistryException {
        String type;
        ODocument oDocument = null;
        if (jsonNodeOrig.isNull()) {
            return null;
        }
        JsonNode jsonNode = jsonNodeOrig.deepCopy();
        if (jsonNode.has("supertypes")) {
            ((ObjectNode)jsonNode).remove("supertypes");
        }
        if (jsonNode.has("expectedtype")) {
            ((ObjectNode)jsonNode).remove("expectedtype");
        }
        if ((type = TypeUtility.getTypeName((JsonNode)jsonNode)) != null) {
            OClass oClass = null;
            TypesCache typesCache = TypesCache.getInstance();
            CachedType cachedType = typesCache.getCachedType(type);
            oClass = cachedType.getOClass();
            AccessType gotAccessType = cachedType.getAccessType();
            if (!AccessType.PROPERTY_ELEMENT.getClass().isAssignableFrom(gotAccessType.getClass())) {
                throw new SchemaException(type + " is not a " + AccessType.PROPERTY_ELEMENT.getName());
            }
            try {
                UUID uuid = UUIDUtility.getUUID((JsonNode)jsonNode);
                if (uuid != null) {
                    throw new ResourceRegistryException("A property object cannot have an UUID");
                }
            }
            catch (Exception e) {
                logger.warn("An invalid UUID has been provided. Anyway property object cannot have an UUID.");
                throw new ResourceRegistryException("An property object cannot have an UUID");
            }
            try {
                Metadata metadata = MetadataUtility.getMetadata((JsonNode)jsonNode);
                if (metadata != null) {
                    throw new ResourceRegistryException("A property object cannot have a Metadata");
                }
            }
            catch (Exception e) {
                logger.warn("An invalid Metadata has been provided. Anyway property object cannot have a Metadata.");
                throw new ResourceRegistryException("An property object cannot have a Metadata");
            }
            if (oClass.isSubClassOf("Encrypted")) {
                EncryptedOrient encrypted = new EncryptedOrient();
                oDocument = encrypted;
                oDocument.fromJSON(jsonNode.toString());
                try {
                    String contextEncryptedValue = encrypted.getEncryptedValue();
                    String decryptedValue = StringEncrypter.getEncrypter().decrypt(contextEncryptedValue);
                    encrypted.setDecryptedValue(decryptedValue, false);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Unable to manage Encrypted Property");
                }
                return oDocument;
            }
            oDocument = new ODocument(type);
        } else {
            oDocument = new ODocument();
        }
        return oDocument.fromJSON(jsonNode.toString());
    }

    public static JsonNode getJsonNode(ODocument oDocument) throws ResourceRegistryException {
        try {
            String type = oDocument.getClassName();
            String json = OrientDBUtility.toJsonString((ORecord)oDocument);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(json);
            if (type == null) {
                return jsonNode;
            }
            TypesCache typesCache = TypesCache.getInstance();
            CachedType cachedType = typesCache.getCachedType(type);
            OClass oClass = cachedType.getOClass();
            AccessType gotAccessType = cachedType.getAccessType();
            if (!AccessType.PROPERTY_ELEMENT.getClass().isAssignableFrom(gotAccessType.getClass())) {
                throw new SchemaException(type + " is not a " + AccessType.PROPERTY_ELEMENT.getName());
            }
            List superClasses = cachedType.getSuperTypes();
            ArrayNode arrayNode = (ArrayNode)objectMapper.valueToTree((Object)superClasses);
            ((ObjectNode)jsonNode).replace("supertypes", (JsonNode)arrayNode);
            if (oClass.isSubClassOf("Encrypted")) {
                try {
                    EncryptedOrient encrypted = null;
                    String encryptedValue = (String)oDocument.getProperty("value");
                    if (oDocument instanceof EncryptedOrient) {
                        encrypted = (EncryptedOrient)oDocument;
                        if (encrypted.getDbEncryptedValue().compareTo(encryptedValue) == 0) {
                            ((ObjectNode)jsonNode).put("value", encrypted.getContextEncryptedValue());
                        }
                    } else {
                        encrypted = new EncryptedOrient();
                        oDocument = encrypted;
                        Key databaseKey = DatabaseEnvironment.getDatabaseKey();
                        String decryptedValue = StringEncrypter.getEncrypter().decrypt(encryptedValue, databaseKey);
                        String contextEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue);
                        ((ObjectNode)jsonNode).put("value", contextEncryptedValue);
                    }
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Errror while managing Encrypted Property", (Throwable)e);
                }
            }
            return jsonNode;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    static {
        PROPERTY_IGNORE_START_WITH_KEYS.add("@");
        PROPERTY_IGNORE_START_WITH_KEYS.add("_");
    }
}

