/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.relations.RelationElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.Operation;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.types.CachedType;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceManagement
extends EntityManagement<Resource, ResourceType> {
    private boolean sanityCheckNotRequired = false;

    public ResourceManagement() {
        super(AccessType.RESOURCE);
    }

    public void setSanityCheckNotRequired() {
        this.sanityCheckNotRequired = true;
    }

    protected ResourceNotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new ResourceNotFoundException(e.getMessage(), e.getCause());
    }

    public ResourceAvailableInAnotherContextException getSpecificAvailableInAnotherContextException(String message) {
        return new ResourceAvailableInAnotherContextException(message);
    }

    protected ResourceAlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new ResourceAlreadyPresentException(message);
    }

    public JsonNode createCompleteJsonNode() throws ResourceRegistryException {
        JsonNode sourceResource = this.serializeSelfAsJsonNode();
        Iterable edges = this.getElement().getEdges(ODirection.OUT);
        for (OEdge edge : edges) {
            RelationManagement relationManagement = this.getRelationManagement(edge);
            relationManagement.setReload(this.reload);
            if (relationManagement.giveMeSourceEntityManagementAsIs() == null) {
                relationManagement.setSourceEntityManagement((EntityElementManagement)this);
            }
            if (relationManagement.giveMeSourceEntityManagementAsIs() != this) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("SourceEntityManagement for ");
                errorMessage.append(relationManagement.getClass().getSimpleName());
                errorMessage.append(" is not the one expected. ");
                errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(errorMessage.toString());
            }
            if (!(relationManagement instanceof ConsistsOfManagement)) continue;
            try {
                relationManagement.includeSource(false);
                JsonNode consistsOf = relationManagement.serializeAsJsonNode();
                sourceResource = ResourceManagement.addConsistsOf((JsonNode)sourceResource, (JsonNode)consistsOf);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw e;
            }
            catch (Exception e) {
                this.logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return sourceResource;
    }

    public static JsonNode addConsistsOf(JsonNode sourceResource, JsonNode consistsOf) throws ResourceRegistryException {
        return ResourceManagement.addRelation((JsonNode)sourceResource, (JsonNode)consistsOf, (String)AccessType.CONSISTS_OF.lowerCaseFirstCharacter());
    }

    public static JsonNode addIsRelatedTo(JsonNode sourceResource, JsonNode isRelatedTo) throws ResourceRegistryException {
        return ResourceManagement.addRelation((JsonNode)sourceResource, (JsonNode)isRelatedTo, (String)AccessType.IS_RELATED_TO.lowerCaseFirstCharacter());
    }

    protected OVertex reallyCreate() throws ResourceAlreadyPresentException, ResourceRegistryException {
        JsonNode jsonNodeArray;
        this.createVertex();
        String property = AccessType.CONSISTS_OF.lowerCaseFirstCharacter();
        if (this.jsonNode.has(property)) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode consistOfJsonNode : jsonNodeArray) {
                ConsistsOfManagement com = new ConsistsOfManagement();
                com.setWorkingContext(this.getWorkingContext());
                com.setODatabaseDocument(this.oDatabaseDocument);
                com.setJsonNode(consistOfJsonNode);
                com.setSourceEntityManagement((EntityElementManagement)this);
                com.internalCreate();
                this.addToRelationManagement((RelationElementManagement)com);
            }
        }
        if (this.jsonNode.has(property = AccessType.IS_RELATED_TO.lowerCaseFirstCharacter())) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                IsRelatedToManagement irtm = new IsRelatedToManagement();
                irtm.setWorkingContext(this.getWorkingContext());
                irtm.setODatabaseDocument(this.oDatabaseDocument);
                irtm.setJsonNode(relationJsonNode);
                irtm.setSourceEntityManagement((EntityElementManagement)this);
                irtm.internalCreate();
                this.addToRelationManagement((RelationElementManagement)irtm);
            }
        }
        return (OVertex)this.element;
    }

    protected OVertex reallyUpdate() throws ResourceNotFoundException, ResourceRegistryException {
        JsonNode jsonNodeArray;
        this.getElement();
        String property = AccessType.CONSISTS_OF.lowerCaseFirstCharacter();
        if (this.jsonNode.has(property)) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                ConsistsOfManagement com = new ConsistsOfManagement();
                com.setWorkingContext(this.getWorkingContext());
                com.setODatabaseDocument(this.oDatabaseDocument);
                com.setJsonNode(relationJsonNode);
                com.internalCreateOrUdate();
                this.addToRelationManagement((RelationElementManagement)com);
            }
        }
        if (this.jsonNode.has(property = AccessType.IS_RELATED_TO.lowerCaseFirstCharacter())) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                IsRelatedToManagement irtm = new IsRelatedToManagement();
                irtm.setWorkingContext(this.getWorkingContext());
                irtm.setODatabaseDocument(this.oDatabaseDocument);
                irtm.setJsonNode(relationJsonNode);
                irtm.internalUpdate();
                this.addToRelationManagement((RelationElementManagement)irtm);
            }
        }
        return (OVertex)this.element;
    }

    protected void reallyDelete() throws ResourceNotFoundException, ResourceRegistryException {
        this.getElement();
        Iterable iterable = ((OVertex)this.element).getEdges(ODirection.OUT);
        for (OEdge edge : iterable) {
            OClass oClass = ElementManagementUtility.getOClass((OElement)edge);
            IsRelatedToManagement relationManagement = null;
            if (oClass.isSubClassOf("IsRelatedTo")) {
                relationManagement = new IsRelatedToManagement();
            } else if (oClass.isSubClassOf("ConsistsOf")) {
                relationManagement = new ConsistsOfManagement();
            } else {
                this.logger.warn("{} is not a {} nor a {}. {}", new Object[]{OrientDBUtility.getAsStringForLogging((ORecord)edge), "IsRelatedTo", "ConsistsOf", "This is really strange and should not occur. Please contact the system administrator."});
            }
            if (relationManagement == null) continue;
            relationManagement.setWorkingContext(this.getWorkingContext());
            relationManagement.setODatabaseDocument(this.oDatabaseDocument);
            relationManagement.setElement((OElement)edge);
            relationManagement.internalDelete();
            this.affectedInstances.putAll(relationManagement.getAffectedInstances());
        }
        iterable = ((OVertex)this.element).getEdges(ODirection.OUT);
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
        }
        this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
        ((OVertex)this.element).delete();
    }

    protected void reallyAddToContext() throws ContextException, ResourceRegistryException {
        if (!this.forceAddToContext && !this.sourceSecurityContext.isElementInContext((OElement)this.getElement())) {
            this.skipped = true;
            return;
        }
        this.targetSecurityContext.addElement((OElement)this.getElement(), this.oDatabaseDocument);
        if (this.honourPropagationConstraintsInContextSharing) {
            Iterable edges = this.getElement().getEdges(ODirection.OUT);
            int facetCounter = 0;
            for (OEdge edge : edges) {
                RelationManagement relationManagement = this.getRelationManagement(edge);
                relationManagement.setDryRun(this.dryRun);
                relationManagement.setHonourPropagationConstraintsInContextSharing(this.honourPropagationConstraintsInContextSharing);
                relationManagement.setSourceSecurityContext(this.sourceSecurityContext);
                relationManagement.setTargetSecurityContext(this.targetSecurityContext);
                relationManagement.internalAddToContext();
                this.affectedInstances.putAll(relationManagement.getAffectedInstances());
                if (relationManagement instanceof ConsistsOfManagement) {
                    facetCounter += relationManagement.getAffectedInstances().size();
                }
                relationManagement.sanityCheck();
            }
            if (facetCounter == 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Any ");
                stringBuffer.append("Resource");
                stringBuffer.append(" must ");
                stringBuffer.append("ConsistsOf");
                stringBuffer.append(" at least of one ");
                stringBuffer.append("Facet");
                stringBuffer.append(" in any ");
                stringBuffer.append("Context");
                throw new ResourceRegistryException(stringBuffer.toString());
            }
        }
    }

    public String all(boolean polymorphic) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            String string = this.reallyGetAll(polymorphic);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected Set<LinkedEntity> getResourceTypeConstraint() throws SchemaException, ResourceRegistryException {
        HashSet<LinkedEntity> constraints = new HashSet<LinkedEntity>();
        TypesCache typesCache = TypesCache.getInstance();
        ResourceType resourceType = (ResourceType)this.getCachedType().getType();
        List linkedEntities = resourceType.getFacets();
        if (linkedEntities != null) {
            for (LinkedEntity linkedEntity : linkedEntities) {
                if (linkedEntity.getMin() <= 0 && (linkedEntity.getMax() == null || linkedEntity.getMax() <= 0)) continue;
                constraints.add(linkedEntity);
            }
        }
        HashSet<CachedType> cachedSuperTypes = new HashSet<CachedType>();
        List superTypes = this.cachedType.getSuperTypes();
        for (String superType : superTypes) {
            CachedType cachedSuperType = typesCache.getCachedType(superType);
            cachedSuperTypes.add(cachedSuperType);
            ResourceType resourceSuperType = (ResourceType)cachedSuperType.getType();
            List linkedEnt = resourceSuperType.getFacets();
            if (linkedEnt == null) continue;
            for (LinkedEntity linkedEntity : linkedEnt) {
                if (linkedEntity.getMin() <= 0 && (linkedEntity.getMax() == null || linkedEntity.getMax() <= 0)) continue;
                constraints.add(linkedEntity);
            }
        }
        return constraints;
    }

    private String constraintNotSatisfiedErrorMessage(LinkedEntity linkedEntity, Integer occurrence) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("A ");
        stringBuffer.append(this.typeName);
        stringBuffer.append(" must be described by ");
        stringBuffer.append(linkedEntity.getRelation());
        stringBuffer.append(" -> ");
        stringBuffer.append(linkedEntity.getTarget());
        stringBuffer.append(" with the following constraint: max:");
        stringBuffer.append(linkedEntity.getMax());
        stringBuffer.append(", min:");
        stringBuffer.append(linkedEntity.getMin());
        stringBuffer.append(". Found ");
        stringBuffer.append(occurrence);
        stringBuffer.append(" instances");
        stringBuffer.append(". The constraint has been defined by ");
        stringBuffer.append(linkedEntity.getSource());
        stringBuffer.append(" type.");
        return stringBuffer.toString();
    }

    protected boolean constraintSatisfied(TypesCache typesCache, LinkedEntity constraint, String consistsOfType, String facetType) throws SchemaException, ResourceRegistryException {
        String requiredSourceResourceType = constraint.getSource();
        if (!this.typeSatified(typesCache, requiredSourceResourceType, this.typeName)) {
            return false;
        }
        String requiredConsistsOfType = constraint.getRelation();
        if (!this.typeSatified(typesCache, requiredConsistsOfType, consistsOfType)) {
            return false;
        }
        String requiredTargetFacetType = constraint.getTarget();
        return this.typeSatified(typesCache, requiredTargetFacetType, facetType);
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
        if (this.operation.isSafe()) {
            return;
        }
        if (this.sanityCheckNotRequired || this.entryPoint && (this.operation == Operation.DELETE || this.operation == Operation.REMOVE_FROM_CONTEXT)) {
            return;
        }
        TypesCache typesCache = TypesCache.getInstance();
        Set consistsOfFacetConstraints = this.getResourceTypeConstraint();
        HashMap<LinkedEntity, Integer> satisfiedConsistsOfFacet = new HashMap<LinkedEntity, Integer>();
        Iterable edges = this.getElement().getEdges(ODirection.OUT);
        block7: for (OEdge edge : edges) {
            RelationManagement relationManagement;
            block19: {
                String id;
                block18: {
                    id = edge.getIdentity().toString();
                    relationManagement = (RelationManagement)this.relationManagements.get(id);
                    if (!this.entryPoint) break block18;
                    switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$instances$model$Operation[this.operation.ordinal()]) {
                        case 1: {
                            if (relationManagement == null) {
                                try {
                                    relationManagement = ElementManagementUtility.getRelationManagement((SecurityContext)this.targetSecurityContext, (ODatabaseDocument)this.oDatabaseDocument, (OEdge)edge);
                                    relationManagement.setSourceSecurityContext(this.sourceSecurityContext);
                                    this.relationManagements.put(id, relationManagement);
                                    break;
                                }
                                catch (AvailableInAnotherContextException e) {
                                    continue block7;
                                }
                            }
                            break block19;
                        }
                        case 2: {
                            if (relationManagement != null) continue block7;
                            relationManagement = ElementManagementUtility.getRelationManagement((SecurityContext)this.targetSecurityContext, (ODatabaseDocument)this.oDatabaseDocument, (OEdge)edge);
                            this.relationManagements.put(id, relationManagement);
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (relationManagement == null) {
                                relationManagement = ElementManagementUtility.getRelationManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OEdge)edge);
                                this.relationManagements.put(id, relationManagement);
                                break;
                            }
                            break block19;
                        }
                    }
                    break block19;
                }
                if (this.operation == Operation.REMOVE_FROM_CONTEXT && relationManagement != null) continue;
                if (relationManagement == null) {
                    relationManagement = this.getRelationManagement(edge);
                    this.relationManagements.put(id, relationManagement);
                }
            }
            if (!(relationManagement instanceof ConsistsOfManagement)) continue;
            String consistsOfType = relationManagement.getTypeName();
            String facetType = ((EntityManagement)relationManagement.getTargetEntityManagement()).getTypeName();
            for (LinkedEntity constraint : consistsOfFacetConstraints) {
                if (!this.constraintSatisfied(typesCache, constraint, consistsOfType, facetType)) continue;
                Integer integer = (Integer)satisfiedConsistsOfFacet.get(constraint);
                if (integer == null) {
                    satisfiedConsistsOfFacet.put(constraint, 1);
                    continue;
                }
                integer = integer + 1;
                satisfiedConsistsOfFacet.put(constraint, integer);
            }
        }
        consistsOfFacetConstraints.removeAll(satisfiedConsistsOfFacet.keySet());
        if (!consistsOfFacetConstraints.isEmpty()) {
            String message = this.constraintNotSatisfiedErrorMessage((LinkedEntity)consistsOfFacetConstraints.iterator().next(), Integer.valueOf(0));
            throw new SchemaViolationException(message);
        }
        for (LinkedEntity linkedEntity : satisfiedConsistsOfFacet.keySet()) {
            Integer satisfiedTimes = (Integer)satisfiedConsistsOfFacet.get(linkedEntity);
            if (satisfiedTimes < linkedEntity.getMin()) {
                String message = this.constraintNotSatisfiedErrorMessage(linkedEntity, satisfiedTimes);
                throw new SchemaViolationException(message);
            }
            Integer max = linkedEntity.getMax();
            if (max == null || max <= 0 || satisfiedTimes <= max) continue;
            String message = this.constraintNotSatisfiedErrorMessage(linkedEntity, satisfiedTimes);
            throw new SchemaViolationException(message);
        }
    }
}

