/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.security;

import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.requests.RequestUtility;
import org.gcube.informationsystem.resourceregistry.requests.ServerRequestInfo;
import org.gcube.informationsystem.utils.UUIDManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecurityContext {
    private static Logger logger = LoggerFactory.getLogger(SecurityContext.class);
    protected static final String DEFAULT_WRITER_ROLE = "writer";
    protected static final String DEFAULT_READER_ROLE = "reader";
    public static final String H = "H";
    protected final boolean hierarchical;
    protected final UUID context;
    protected final Map<Boolean, Map<PermissionMode, ODatabasePool>> poolMap;
    protected SecurityContext parentSecurityContext;
    protected Set<SecurityContext> children;

    protected boolean isHierarchicalMode() {
        return this.hierarchical || ((ServerRequestInfo)RequestUtility.getRequestInfo().get()).isHierarchicalMode();
    }

    public void setParentSecurityContext(SecurityContext parentSecurityContext) {
        if (this.parentSecurityContext != null) {
            this.parentSecurityContext.getChildren().remove(this);
        }
        this.parentSecurityContext = parentSecurityContext;
        if (parentSecurityContext != null) {
            this.parentSecurityContext.addChild(this);
        }
    }

    public SecurityContext getParentSecurityContext() {
        return this.parentSecurityContext;
    }

    private void addChild(SecurityContext child) {
        this.children.add(child);
    }

    public Set<SecurityContext> getChildren() {
        return this.children;
    }

    protected ODatabaseDocument getAdminDatabaseDocument() throws ResourceRegistryException {
        return ContextUtility.getAdminSecurityContext().getDatabaseDocument(PermissionMode.WRITER);
    }

    private Set<SecurityContext> getAllChildren() {
        HashSet<SecurityContext> allChildren = new HashSet<SecurityContext>();
        allChildren.add(this);
        for (SecurityContext securityContext : this.getChildren()) {
            allChildren.addAll(securityContext.getAllChildren());
        }
        return allChildren;
    }

    private Set<SecurityContext> getAllParents() {
        HashSet<SecurityContext> allParents = new HashSet<SecurityContext>();
        for (SecurityContext parent = this.getParentSecurityContext(); parent != null; parent = parent.getParentSecurityContext()) {
            allParents.add(parent);
        }
        return allParents;
    }

    public void changeParentSecurityContext(SecurityContext newParentSecurityContext, ODatabaseDocument orientGraph) throws ResourceRegistryException {
        if (!this.hierarchical) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Cannot change parent ");
            errorMessage.append(SecurityContext.class.getSimpleName());
            errorMessage.append(" to non hierarchic ");
            errorMessage.append(SecurityContext.class.getSimpleName());
            errorMessage.append(". ");
            errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
            String error = errorMessage.toString();
            logger.error(error);
            throw new RuntimeException(error);
        }
        OSecurity oSecurity = this.getOSecurity(orientGraph);
        Set allChildren = this.getAllChildren();
        Set oldParents = this.getAllParents();
        Set newParents = new HashSet();
        if (newParentSecurityContext != null) {
            newParents = newParentSecurityContext.getAllParents();
        }
        oldParents.removeAll(newParents);
        this.removeChildrenHRolesFromParents(oSecurity, oldParents, allChildren);
        this.setParentSecurityContext(newParentSecurityContext);
        if (newParentSecurityContext != null) {
            for (PermissionMode permissionMode : PermissionMode.values()) {
                ArrayList<ORole> roles = new ArrayList<ORole>();
                for (SecurityContext child : allChildren) {
                    String roleName = child.getSecurityRoleOrUserName(permissionMode, SecurityType.ROLE, true);
                    ORole role = oSecurity.getRole(roleName);
                    roles.add(role);
                }
                newParentSecurityContext.addHierarchicalRoleToParent(oSecurity, permissionMode, roles.toArray(new ORole[allChildren.size()]));
            }
        }
    }

    protected SecurityContext(UUID context, boolean hierarchical) throws ResourceRegistryException {
        this.context = context;
        this.poolMap = new HashMap();
        this.hierarchical = hierarchical;
        this.children = new HashSet();
    }

    public SecurityContext(UUID context) throws ResourceRegistryException {
        this(context, true);
    }

    private synchronized ODatabasePool getPool(PermissionMode permissionMode, boolean recreate) {
        ODatabasePool pool = null;
        Boolean h = this.isHierarchicalMode();
        HashMap<PermissionMode, ODatabasePool> pools = (HashMap<PermissionMode, ODatabasePool>)this.poolMap.get(h);
        if (pools == null) {
            pools = new HashMap<PermissionMode, ODatabasePool>();
            this.poolMap.put(h, pools);
        } else if (recreate && (pool = (ODatabasePool)pools.get(permissionMode)) != null) {
            pool.close();
            pools.remove(permissionMode);
        }
        pool = (ODatabasePool)pools.get(permissionMode);
        if (pool == null) {
            String username = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, h.booleanValue());
            String password = (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode);
            pool = new ODatabasePool(DatabaseEnvironment.DB_URI, username, password);
            pools.put(permissionMode, pool);
        }
        return pool;
    }

    public UUID getUUID() {
        return this.context;
    }

    public static String getRoleOrUserName(PermissionMode permissionMode, SecurityType securityType) {
        return SecurityContext.getRoleOrUserName((PermissionMode)permissionMode, (SecurityType)securityType, (boolean)false);
    }

    public static String getRoleOrUserName(PermissionMode permissionMode, SecurityType securityType, boolean hierarchic) {
        StringBuilder stringBuilder = new StringBuilder();
        if (hierarchic) {
            stringBuilder.append("H");
        }
        stringBuilder.append(permissionMode);
        stringBuilder.append(securityType);
        return stringBuilder.toString();
    }

    public String getSecurityRoleOrUserName(PermissionMode permissionMode, SecurityType securityType, boolean hierarchic) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SecurityContext.getRoleOrUserName((PermissionMode)permissionMode, (SecurityType)securityType, (boolean)hierarchic));
        stringBuilder.append("_");
        stringBuilder.append(this.context.toString());
        return stringBuilder.toString();
    }

    private OSecurity getOSecurity(ODatabaseDocument oDatabaseDocument) {
        return oDatabaseDocument.getMetadata().getSecurity();
    }

    public static Set<String> getContexts(OElement element) {
        HashSet<String> contexts = new HashSet<String>();
        ORecordLazySet oRecordLazySet = (ORecordLazySet)element.getProperty("_allow");
        for (OIdentifiable oIdentifiable : oRecordLazySet) {
            String[] list;
            ODocument oDocument = (ODocument)oIdentifiable;
            String name = (String)oDocument.getProperty("name");
            if (!name.startsWith(SecurityContext.getRoleOrUserName((PermissionMode)PermissionMode.WRITER, (SecurityType)SecurityType.ROLE)) && !name.startsWith(SecurityContext.getRoleOrUserName((PermissionMode)PermissionMode.READER, (SecurityType)SecurityType.ROLE)) || (list = name.split("_")).length != 2) continue;
            String contextUUID = list[1];
            if (UUIDManager.getInstance().isReservedUUID(contextUUID)) continue;
            contexts.add(contextUUID);
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(OElement element) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument adminDatabaseDocument = null;
        try {
            adminDatabaseDocument = this.getAdminDatabaseDocument();
            this.addElement(element, adminDatabaseDocument);
        }
        finally {
            if (adminDatabaseDocument != null) {
                adminDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected void allow(OSecurity oSecurity, ODocument oDocument, boolean hierarchic) {
        String writerRoleName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.ROLE, hierarchic);
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_ALL, writerRoleName);
        String readerRoleName = this.getSecurityRoleOrUserName(PermissionMode.READER, SecurityType.ROLE, hierarchic);
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_READ, readerRoleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isElementInContext(OElement element) throws ResourceRegistryException {
        ORID orid = element.getIdentity();
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument contextODatabaseDocument = null;
        try {
            contextODatabaseDocument = this.getDatabaseDocument(PermissionMode.READER);
            ORecord oRecord = contextODatabaseDocument.getRecord((OIdentifiable)orid);
            if (oRecord == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (contextODatabaseDocument != null) {
                contextODatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public void addElement(OElement element, ODatabaseDocument oDatabaseDocument) {
        ODocument oDocument = (ODocument)element.getRecord();
        OSecurity oSecurity = this.getOSecurity(oDatabaseDocument);
        this.allow(oSecurity, oDocument, false);
        if (this.hierarchical) {
            this.allow(oSecurity, oDocument, true);
        }
        oDocument.save();
        element.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(OElement element) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument adminDatabaseDocument = null;
        try {
            adminDatabaseDocument = this.getAdminDatabaseDocument();
            this.removeElement(element, adminDatabaseDocument);
        }
        finally {
            if (adminDatabaseDocument != null) {
                adminDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected void deny(OSecurity oSecurity, ODocument oDocument, boolean hierarchical) {
        String writerUserName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.USER, hierarchical);
        oSecurity.denyUser(oDocument, ORestrictedOperation.ALLOW_ALL, writerUserName);
        String readerUserName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.USER, hierarchical);
        oSecurity.denyUser(oDocument, ORestrictedOperation.ALLOW_READ, readerUserName);
        String writerRoleName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.ROLE, hierarchical);
        oSecurity.denyRole(oDocument, ORestrictedOperation.ALLOW_ALL, writerRoleName);
        String readerRoleName = this.getSecurityRoleOrUserName(PermissionMode.READER, SecurityType.ROLE, hierarchical);
        oSecurity.denyRole(oDocument, ORestrictedOperation.ALLOW_READ, readerRoleName);
    }

    public void removeElement(OElement element, ODatabaseDocument oDatabaseDocument) {
        ODocument oDocument = (ODocument)element.getRecord();
        OSecurity oSecurity = this.getOSecurity(oDatabaseDocument);
        this.deny(oSecurity, oDocument, false);
        if (this.hierarchical) {
            this.deny(oSecurity, oDocument, true);
        }
        oDocument.save();
        element.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowed(ORole role, ODocument oDocument) {
        ServerRequestInfo sri = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        Boolean hm = sri.isHierarchicalMode();
        sri.setHierarchicalMode(false);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            oDatabaseDocument = this.getDatabaseDocument(PermissionMode.READER);
            oDatabaseDocument.activateOnCurrentThread();
            ORecord element = oDatabaseDocument.getRecord((OIdentifiable)oDocument.getIdentity());
            if (element == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            sri.setHierarchicalMode(hm.booleanValue());
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public void create() throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument adminDatabaseDocument = null;
        try {
            adminDatabaseDocument = this.getAdminDatabaseDocument();
            this.create(adminDatabaseDocument);
            adminDatabaseDocument.commit();
        }
        finally {
            if (adminDatabaseDocument != null) {
                adminDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected ORole addExtraRules(ORole role, PermissionMode permissionMode) {
        return role;
    }

    protected ORole getSuperRole(OSecurity oSecurity, PermissionMode permissionMode) {
        String superRoleName = permissionMode.name().toLowerCase();
        return oSecurity.getRole(superRoleName);
    }

    protected void addHierarchicalRoleToParent(OSecurity oSecurity, PermissionMode permissionMode, ORole ... roles) {
        String userName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, true);
        OUser user = oSecurity.getUser(userName);
        for (ORole role : roles) {
            user.addRole((OSecurityRole)role);
        }
        user.save();
        if (this.getParentSecurityContext() != null) {
            this.getParentSecurityContext().addHierarchicalRoleToParent(oSecurity, permissionMode, roles);
        }
    }

    protected void createRolesAndUsers(OSecurity oSecurity) {
        boolean[] booleanArray = this.hierarchical ? new boolean[]{false, true} : new boolean[]{false};
        for (boolean hierarchical : booleanArray) {
            for (PermissionMode permissionMode : PermissionMode.values()) {
                ORole superRole = this.getSuperRole(oSecurity, permissionMode);
                String roleName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.ROLE, hierarchical);
                ORole role = oSecurity.createRole(roleName, superRole, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
                this.addExtraRules(role, permissionMode);
                role.save();
                logger.trace("{} created", (Object)role);
                if (hierarchical && this.getParentSecurityContext() != null) {
                    this.getParentSecurityContext().addHierarchicalRoleToParent(oSecurity, permissionMode, new ORole[]{role});
                }
                String userName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, hierarchical);
                OUser user = oSecurity.createUser(userName, (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode), new ORole[]{role});
                user.save();
                logger.trace("{} created", (Object)user);
            }
        }
    }

    public void create(ODatabaseDocument oDatabaseDocument) {
        OSecurity oSecurity = this.getOSecurity(oDatabaseDocument);
        this.createRolesAndUsers(oSecurity);
        logger.trace("Security Context (roles and users) with UUID {} successfully created", (Object)this.context.toString());
    }

    private void drop(OSecurity oSecurity, String name, SecurityType securityType) {
        boolean dropped = false;
        switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$contexts$security$SecurityContext$SecurityType[securityType.ordinal()]) {
            case 1: {
                dropped = oSecurity.dropRole(name);
                break;
            }
            case 2: {
                dropped = oSecurity.dropUser(name);
                break;
            }
        }
        if (dropped) {
            logger.trace("{} successfully dropped", (Object)name);
        } else {
            logger.error("{} was not dropped successfully", (Object)name);
        }
    }

    public void delete() throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument adminDatabaseDocument = null;
        try {
            adminDatabaseDocument = this.getAdminDatabaseDocument();
            this.delete(adminDatabaseDocument);
            adminDatabaseDocument.commit();
        }
        finally {
            if (adminDatabaseDocument != null) {
                adminDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected void removeChildrenHRolesFromParents(OSecurity oSecurity) {
        Set parents = this.getAllParents();
        Set allChildren = this.getAllChildren();
        this.removeChildrenHRolesFromParents(oSecurity, parents, allChildren);
    }

    protected void removeChildrenHRolesFromParents(OSecurity oSecurity, Set<SecurityContext> parents, Set<SecurityContext> children) {
        for (SecurityContext parent : parents) {
            parent.removeChildrenHRolesFromMyHUsers(oSecurity, children);
        }
    }

    protected void removeChildrenHRolesFromMyHUsers(OSecurity oSecurity, Set<SecurityContext> children) {
        for (PermissionMode permissionMode : PermissionMode.values()) {
            String userName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, true);
            OUser user = oSecurity.getUser(userName);
            for (SecurityContext child : children) {
                String roleName = child.getSecurityRoleOrUserName(permissionMode, SecurityType.ROLE, true);
                logger.debug("Going to remove {} from {}", (Object)roleName, (Object)userName);
                boolean removed = user.removeRole(roleName);
                logger.trace("{} {} removed from {}", new Object[]{roleName, removed ? "successfully" : "NOT", userName});
            }
            user.save();
        }
    }

    protected void removeHierarchicRoleFromMyHUser(OSecurity oSecurity, PermissionMode permissionMode, String roleName) {
        String userName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, true);
        OUser user = oSecurity.getUser(userName);
        logger.debug("Going to remove {} from {}", (Object)roleName, (Object)userName);
        boolean removed = user.removeRole(roleName);
        logger.trace("{} {} removed from {}", new Object[]{roleName, removed ? "successfully" : "NOT", userName});
        user.save();
    }

    protected void deleteRolesAndUsers(OSecurity oSecurity) {
        boolean[] booleanArray = this.hierarchical ? new boolean[]{false, true} : new boolean[]{false};
        for (boolean hierarchic : booleanArray) {
            if (hierarchic) {
                this.removeChildrenHRolesFromParents(oSecurity);
            }
            for (PermissionMode permissionMode : PermissionMode.values()) {
                for (SecurityType securityType : SecurityType.values()) {
                    String name = this.getSecurityRoleOrUserName(permissionMode, securityType, hierarchic);
                    this.drop(oSecurity, name, securityType);
                }
            }
        }
    }

    public void delete(ODatabaseDocument orientGraph) {
        OSecurity oSecurity = this.getOSecurity(orientGraph);
        this.delete(oSecurity);
    }

    private void delete(OSecurity oSecurity) {
        logger.trace("Going to remove Security Context (roles and users) with UUID {}", (Object)this.context.toString());
        this.deleteRolesAndUsers(oSecurity);
        logger.trace("Security Context (roles and users) with UUID {} successfully removed", (Object)this.context.toString());
    }

    public ODatabaseDocument getDatabaseDocument(PermissionMode permissionMode) throws ResourceRegistryException {
        try {
            ODatabasePool oDatabasePool = this.getPool(permissionMode, false);
            ODatabaseSession oDatabaseSession = null;
            try {
                oDatabaseSession = oDatabasePool.acquire();
                if (oDatabaseSession.isClosed()) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                oDatabasePool = this.getPool(permissionMode, true);
                oDatabaseSession = oDatabasePool.acquire();
            }
            oDatabaseSession.activateOnCurrentThread();
            return oDatabaseSession;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s %s", "Context", this.getUUID().toString());
    }
}

