/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base.entities;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryEntity;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryConsistsOf;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryIsRelatedTo;

public class JsonQueryResource
extends JsonQueryEntity {
    public JsonQueryResource(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
        super(jsonQuery, AccessType.RESOURCE);
        this.fieldNamesToRemove.add("consistsOf");
        this.fieldNamesToRemove.add("isRelatedTo");
    }

    public StringBuffer analize(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
        ArrayNode consistsOfArray;
        ArrayNode isRelatedToArray;
        boolean initFound = false;
        int size = this.jsonNode.size();
        if (!this.entryPoint) {
            StringBuffer newBuffer = new StringBuffer();
            newBuffer.append("TRAVERSE ");
            newBuffer.append(this.direction.name().toLowerCase());
            newBuffer.append("V(\"");
            newBuffer.append(this.type);
            newBuffer.append("\") FROM ( ");
            newBuffer.append(stringBuffer);
            newBuffer.append(")");
            stringBuffer = newBuffer;
            initFound = true;
        }
        if ((isRelatedToArray = (ArrayNode)this.jsonNode.get("isRelatedTo")) != null && isRelatedToArray.size() > 0) {
            --size;
            initFound = true;
            for (int i = 0; i < isRelatedToArray.size(); ++i) {
                JsonNode isRelatedToJsonNode = isRelatedToArray.get(i);
                JsonQueryIsRelatedTo jsonQueryIsRelatedTo = new JsonQueryIsRelatedTo(isRelatedToJsonNode);
                jsonQueryIsRelatedTo.setRequestedResourceType(this.type);
                jsonQueryIsRelatedTo.setEntryPoint(this.entryPoint && i == 0);
                stringBuffer = jsonQueryIsRelatedTo.analize(stringBuffer);
            }
        }
        if ((consistsOfArray = (ArrayNode)this.jsonNode.get("consistsOf")) != null && consistsOfArray.size() > 0) {
            --size;
            for (int i = 0; i < consistsOfArray.size(); ++i) {
                JsonNode consistsOfJsonNode = consistsOfArray.get(i);
                JsonQueryConsistsOf jsonQueryConsistsOf = new JsonQueryConsistsOf(consistsOfJsonNode);
                jsonQueryConsistsOf.setRequestedResourceType(this.type);
                jsonQueryConsistsOf.setDirection(Direction.IN);
                jsonQueryConsistsOf.setEntryPoint(this.entryPoint && !initFound && i == 0);
                stringBuffer = jsonQueryConsistsOf.analize(stringBuffer);
            }
            initFound = true;
        }
        if (this.entryPoint) {
            if (!initFound) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT FROM ");
                stringBuffer.append(this.type);
                if (size > 1) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(this.addConstraints(this.jsonNode, null, null));
                }
            } else if (size > 1) {
                StringBuffer newBuffer = new StringBuffer();
                newBuffer.append("SELECT FROM ( ");
                newBuffer.append(stringBuffer);
                newBuffer.append(")");
                newBuffer.append(" WHERE ");
                newBuffer.append(this.addConstraints(this.jsonNode, null, null));
                stringBuffer = newBuffer;
            }
        } else if (initFound && size > 1) {
            StringBuffer newBuffer = new StringBuffer();
            newBuffer.append("SELECT FROM ( ");
            newBuffer.append(stringBuffer);
            newBuffer.append(")");
            newBuffer.append(" WHERE ");
            newBuffer.append(this.addConstraints(this.jsonNode, null, null));
            stringBuffer = newBuffer;
        }
        return stringBuffer;
    }
}

