/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.HashMap;
import java.util.Map;
import org.gcube.informationsystem.types.PropertyTypeName;

public class OrientDBTypeMapping {
    protected static final Map<PropertyTypeName.BaseType, OType> BASE_TYPE_TO_OTYPE = new HashMap();
    protected static final Map<OType, PropertyTypeName.BaseType> OTYPE_TO_BASE_TYPE;

    public static OType getOTypeByBaseType(PropertyTypeName.BaseType baseType) {
        return (OType)BASE_TYPE_TO_OTYPE.get(baseType);
    }

    public static PropertyTypeName.BaseType getBaseTypeByOType(OType oType) {
        return (PropertyTypeName.BaseType)OTYPE_TO_BASE_TYPE.get(oType);
    }

    static {
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.BOOLEAN, OType.BOOLEAN);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.INTEGER, OType.INTEGER);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.SHORT, OType.SHORT);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.LONG, OType.LONG);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.FLOAT, OType.FLOAT);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.DOUBLE, OType.DOUBLE);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.DATE, OType.DATETIME);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.STRING, OType.STRING);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.BINARY, OType.BINARY);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.BYTE, OType.BYTE);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.PROPERTY, OType.EMBEDDED);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.LIST, OType.EMBEDDEDLIST);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.SET, OType.EMBEDDEDSET);
        BASE_TYPE_TO_OTYPE.put(PropertyTypeName.BaseType.MAP, OType.EMBEDDEDMAP);
        OTYPE_TO_BASE_TYPE = new HashMap();
        for (PropertyTypeName.BaseType baseType : BASE_TYPE_TO_OTYPE.keySet()) {
            OTYPE_TO_BASE_TYPE.put((OType)BASE_TYPE_TO_OTYPE.get(baseType), baseType);
        }
    }
}

