/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet.FacetAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.instances.model.Operation;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.types.reference.entities.FacetType;

public class FacetManagement
extends EntityManagement<Facet, FacetType> {
    protected ConsistsOfManagement consistsOfManagement;
    protected ResourceManagement resourceManagement;

    public FacetManagement() {
        super(AccessType.FACET);
    }

    protected FacetNotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new FacetNotFoundException(e.getMessage(), e.getCause());
    }

    public FacetAvailableInAnotherContextException getSpecificAvailableInAnotherContextException(String message) {
        return new FacetAvailableInAnotherContextException(message);
    }

    protected FacetAlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new FacetAlreadyPresentException(message);
    }

    public JsonNode createCompleteJsonNode() throws ResourceRegistryException {
        return this.serializeSelfAsJsonNode();
    }

    protected OVertex reallyCreate() throws FacetAlreadyPresentException, ResourceRegistryException {
        return this.createVertex();
    }

    protected OVertex reallyUpdate() throws FacetNotFoundException, ResourceRegistryException {
        OVertex facet = this.getElement();
        facet = (OVertex)this.updateProperties(this.oClass, (OElement)facet, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
        return facet;
    }

    protected void reallyRemoveFromContext() throws ContextException, ResourceRegistryException {
        if (this.entryPoint) {
            OEdge oEdge = (OEdge)this.getElement().getEdges(ODirection.IN).iterator().next();
            this.consistsOfManagement = new ConsistsOfManagement();
            this.consistsOfManagement.setElement((OElement)oEdge);
            this.consistsOfManagement.setTargetEntityManagement((EntityElementManagement)this);
            this.consistsOfManagement.setTargetInstanceEnvironment(this.targetInstanceEnvironment);
            this.affectedInstances.put(this.uuid, this.consistsOfManagement.serializeAsAffectedInstance());
            OVertex oVertex = (OVertex)this.getElement().getVertices(ODirection.IN).iterator().next();
            this.resourceManagement = new ResourceManagement();
            this.resourceManagement.setElement((OElement)oVertex);
            this.resourceManagement.setTargetInstanceEnvironment(this.targetInstanceEnvironment);
            this.resourceManagement.addToRelationManagements((RelationManagement)this.consistsOfManagement);
        }
        super.reallyRemoveFromContext();
    }

    protected void reallyDelete() throws FacetNotFoundException, ResourceRegistryException {
        if (this.entryPoint) {
            OEdge oEdge = (OEdge)this.getElement().getEdges(ODirection.IN).iterator().next();
            this.consistsOfManagement = new ConsistsOfManagement();
            this.consistsOfManagement.setElement((OElement)oEdge);
            this.consistsOfManagement.setTargetEntityManagement((EntityElementManagement)this);
            this.affectedInstances.put(this.uuid, this.consistsOfManagement.serializeAsAffectedInstance());
            OVertex oVertex = (OVertex)this.getElement().getVertices(ODirection.IN).iterator().next();
            this.resourceManagement = new ResourceManagement();
            this.resourceManagement.setElement((OElement)oVertex);
            this.resourceManagement.addToRelationManagements((RelationManagement)this.consistsOfManagement);
        }
        this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
        this.getElement().delete();
    }

    protected void checkResource() throws SchemaViolationException, ResourceRegistryException {
        if (!this.entryPoint) {
            return;
        }
        if (this.operation.isSafe()) {
            return;
        }
        if (this.operation == Operation.UPDATE) {
            return;
        }
        ODatabaseDocument targetInstanceEnvironmentODatabaseDocument = null;
        try {
            if (this.resourceManagement == null) {
                OVertex oVertex = (OVertex)this.getElement().getVertices(ODirection.IN).iterator().next();
                ResourceManagement resourceManagement = new ResourceManagement();
                resourceManagement.setElement((OElement)oVertex);
            }
            switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$instances$model$Operation[this.operation.ordinal()]) {
                case 1: 
                case 2: {
                    this.resourceManagement.setWorkingEnvironment(this.getWorkingEnvironment());
                    this.resourceManagement.setODatabaseDocument(this.oDatabaseDocument);
                    break;
                }
                case 3: {
                    this.resourceManagement.setSourceInstanceEnvironment(this.sourceInstanceEnvironment);
                    this.resourceManagement.setTargetInstanceEnvironment(this.targetInstanceEnvironment);
                    this.resourceManagement.setWorkingEnvironment((Environment)this.targetInstanceEnvironment);
                    targetInstanceEnvironmentODatabaseDocument = this.targetInstanceEnvironment.getDatabaseDocument(Environment.PermissionMode.READER);
                    this.resourceManagement.setODatabaseDocument(targetInstanceEnvironmentODatabaseDocument);
                    break;
                }
                case 4: {
                    this.resourceManagement.setTargetInstanceEnvironment(this.targetInstanceEnvironment);
                    this.resourceManagement.setWorkingEnvironment((Environment)this.targetInstanceEnvironment);
                    targetInstanceEnvironmentODatabaseDocument = this.targetInstanceEnvironment.getDatabaseDocument(Environment.PermissionMode.READER);
                    this.resourceManagement.setODatabaseDocument(targetInstanceEnvironmentODatabaseDocument);
                    break;
                }
                default: {
                    return;
                }
            }
            this.resourceManagement.setOperation(this.operation);
            this.resourceManagement.sanityCheck();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (targetInstanceEnvironmentODatabaseDocument != null) {
                targetInstanceEnvironmentODatabaseDocument.close();
                this.oDatabaseDocument.activateOnCurrentThread();
            }
        }
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
        super.sanityCheck();
        this.checkResource();
    }

    public String create() throws AlreadyPresentException, ResourceRegistryException {
        throw new SchemaViolationException("You cannot create a stand alone Facet");
    }

    public OVertex internalCreate() throws AlreadyPresentException, ResourceRegistryException {
        if (this.entryPoint) {
            throw new SchemaViolationException("You cannot create a stand alone Facet");
        }
        return (OVertex)super.internalCreate();
    }
}

