/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.UUID;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.request.BaseRequestInfo;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.Method;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.smartgears.utils.InnerMethodName;

@Path(value="contexts")
@Tag(name="Contexts", description="Operations for managing contexts in the Resource Registry.")
public class ContextManager
extends BaseRest {
    public static final String CONTEXT_UUID_PATH_PARAMETER = "context-uuid";

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="List Contexts", description="Retrieves the list of contexts in the system.\n\nThe response can include metadata and provides pagination based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /access/contexts (returns first 10 contexts - default pagination);\n- GET /access/contexts?limit=20 (returns first 20 contexts);\n- GET /access/contexts?offset=10 (returns 10 contexts starting from the 11th - default limit with offset);\n- GET /access/contexts?limit=5&offset=15 (returns 5 contexts starting from the 16th);\n- GET /access/contexts?includeMeta=true (returns first 10 contexts with metadata - for non-admin users);\n- GET /access/contexts?limit=20&includeMeta=true (returns first 20 contexts with metadata).\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Automatically receive full context information including:\n\t\t- Complete metadata (createdBy, lastUpdateBy, creation/modification dates);\n\t\t- Context state information;\n\t\t- All context properties without obfuscation;\n\t- Metadata is included by default regardless of request parameters.\n\n- **Infrastructure-Manager:**\n\t- Automatically receive full context information including:\n\t\t- Complete metadata (createdBy, lastUpdateBy, creation/modification dates);\n\t\t- Context state information;\n\t\t- All context properties without obfuscation;\n\t- Metadata is included by default regardless of request parameters.\n\n- **Other Users:**\n\t- Receive basic context information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive metadata with sensitive information filtered:\n\t\t- Date fields (creation, modification) are visible;\n\t\t- User identifiers (createdBy, lastUpdateBy) are obfuscated or hidden;\n\t\t- Other administrative details may be filtered.\n")
    @Parameters(value={@Parameter(name="limit", in=ParameterIn.QUERY, description="Maximum number of contexts to return in a single response.\n- Default: 10 (returns at most 10 contexts);\n- Example: ?limit=50 (returns at most 50 contexts).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="10", example="10")), @Parameter(name="offset", in=ParameterIn.QUERY, description="Number of contexts to skip from the beginning of the result set.\n- Default: 0 (starts from the first context);\n- Example: ?offset=100 (skips the first 100 contexts);\n- Commonly used with limit for pagination: ?limit=50&offset=100.\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="0", example="0")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response (for non-admin users).\n- Default: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with obfuscated sensitive fields);\n- Note: IS-Manager and Infrastructure-Manager always receive not filtered metadata regardless of this parameter.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Contexts successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="User lacks authorization to access context information"), @APIResponse(responseCode="500", description="Server error during context retrieval")})
    public String listContexts() throws ContextNotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read all {}s", (Object)"Context");
        this.setAccountingMethod(Method.LIST, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo(BaseRequestInfo.DEFAULT_OFFSET.intValue(), BaseRequestInfo.UNBOUNDED_LIMIT.intValue());
        serverRequestInfo.setIncludeMeta(true);
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkLimitOffset();
        ContextManagement contextManagement = new ContextManagement();
        return contextManagement.all(false);
    }

    @GET
    @Path(value="{context-uuid}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Get Context by UUID", description="Retrieves a specific context by its UUID.\n\nThe response includes metadata and detail level based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /contexts/c0f314e7-2807-4241-a792-2a6c79ed4fd0 (returns basic context information);\n- GET /contexts/c0f314e7-2807-4241-a792-2a6c79ed4fd0?includeMeta=true (returns context with metadata - for non-admin users);\n- GET /contexts/CURRENT_CONTEXT (returns the current context - retrieved from client's authorization token).\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can retrieve context information for any context without restrictions;\n\t- Automatically receive full context information including complete metadata;\n\t- All context properties and state information without obfuscation;\n\t- Metadata is included by default regardless of request parameters.\n\n- **Infrastructure-Manager:**\n\t- Can retrieve context information for any context without restrictions;\n\t- Automatically receive full context information including complete metadata;\n\t- All context properties and state information without obfuscation;\n\t- Metadata is included by default regardless of request parameters.\n\n- **Context-Manager:**\n\t- When operating in their own context (using a token from that context):\n\t\t- Receive full context information like IS-Manager and Infrastructure-Manager;\n\t\t- Complete metadata without obfuscation;\n\t\t- All context properties and state information.\n\t- When operating outside their context or requesting other contexts:\n\t\t- Receive basic context information by default;\n\t\t- Can request metadata via includeMeta=true with obfuscated sensitive fields.\n\n- **Other Users:**\n\t- Receive basic context information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive metadata with sensitive information filtered:\n\t\t- Date fields (creation, modification) are visible;\n\t\t- User identifiers (createdBy, lastUpdateBy) are obfuscated or hidden;\n\t\t- Other administrative details may be filtered.\n")
    @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response (for non-admin users).\n- Default: false (basic information only);\n- Values: true|false;\n- Example: ?includeMeta=true (includes metadata with obfuscated sensitive fields);\n- Note: IS-Manager and Infrastructure-Manager always receive metadata regardless of this parameter.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))
    @APIResponses(value={@APIResponse(responseCode="200", description="Context successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Context with the specified UUID does not exist"), @APIResponse(responseCode="403", description="User lacks authorization to access the specific context"), @APIResponse(responseCode="400", description="Invalid UUID format")})
    public String read(@PathParam(value="context-uuid") @Parameter(name="context-uuid", in=ParameterIn.PATH, description="The unique identifier of the context to retrieve.\n- Must be a valid UUID string format (e.g., \"c0f314e7-2807-4241-a792-2a6c79ed4fd0\");\n- Special keyword: \"CURRENT_CONTEXT\" to retrieve the context from client's authorization token;\n- When using \"CURRENT_CONTEXT\", the actual context is extracted from the JWT token sent by the client;\n- Example: GET /contexts/CURRENT_CONTEXT returns the context the client is authorized for.\n", required=true, schema=@Schema(type=SchemaType.STRING, example="c0f314e7-2807-4241-a792-2a6c79ed4fd0")) String uuid) throws ContextNotFoundException, ResourceRegistryException {
        if (uuid.compareTo("CURRENT_CONTEXT") == 0) {
            uuid = ContextUtility.getCurrentRequestEnvironment().getUUID().toString();
        }
        this.logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        this.setAccountingMethod(Method.READ, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setIncludeMeta(true);
        serverRequestInfo.setAllMeta(true);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.readAsString();
    }

    @PUT
    @Path(value="{context-uuid}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Create or Update Context", description="Creates a new context or updates an existing context with the provided JSON representation.\n\nOnly authorized administrative users can perform this operation.\n\n\n**Request Examples:**\n- PUT /contexts/c0f314e7-2807-4241-a792-2a6c79ed4fd0 (create/update context).\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can create/update any context without restrictions;\n\t- Has full administrative privileges across all contexts.\n\n- **Infrastructure-Manager:**\n\t- Can create/update any context without restrictions;\n\t- Has full administrative privileges across all contexts.\n\n- **Context-Manager:**\n\t- Can create/update contexts only if they are Context-Manager of the parent context;\n\t- The parent context must be the current context (retrieved from client's authorization token);\n\t- Cannot create/update contexts outside their management scope.\n\n- **Other Users:**\n\t- Cannot create or update contexts;\n\t- Will receive authorization errors if attempting these operations.\n\n\n**Operation Behavior:**\n\n**Context Property Changes and Operations:**\n\n**Name Change:**\n- Updates the context name while preserving all other properties;\n- Changes the full path of the context and all its child contexts;\n- No effect on instances belonging to this context (instances remain in the context);\n- No effect on instances in child contexts.\n\n**Parent Change (Move Operation):**\n- Moves the context to a different parent in the context hierarchy;\n- Changes the full path of the context and all its child contexts;\n- No effect on instances belonging to this context (instances remain in the context);\n- No effect on instances in child contexts;\n- However, instances in hierarchical queries of the old and new parent contexts will change.\n\n**Combined Name and Parent Change:**\n- Both name and parent can be changed in the same update request;\n- Results in both a rename and move operation applied simultaneously;\n- The full path changes due to both the new name and new parent location;\n- All effects described above for both operations apply.\n\n**Additional Properties:**\n- While certain roles may receive additional parameters in context definitions, these cannot be modified through update operations;\n- Only name and parent can be effectively changed via update.\n\n**Important Design Considerations:**\n- The service is designed to work with UUIDs rather than full paths precisely because full paths can change;\n- Context UUIDs remain stable regardless of name or parent changes;\n- All internal references and relationships use UUIDs for consistency;\n- Client applications should store and reference contexts by UUID, not by full path.\n\n**Hierarchical Query Impact:**\n- When a context is moved to a new parent, the hierarchical queries (queries that include child contexts) in both the old and new parent contexts will reflect the change;\n- **Instances** belonging to the moved context will no longer appear in hierarchical queries of the old parent context;\n- **Instances** belonging to the moved context will start appearing in hierarchical queries of the new parent context;\n- The context hierarchy structure itself changes, but the effect is visible in terms of which instances are returned when querying with hierarchical=true parameter;\n- **Context Tree Structure**: When listing contexts to construct the context tree hierarchy, the tree structure will obviously change to reflect the new parent-child relationships.\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Context successfully updated", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="201", description="Context successfully created", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid JSON representation or malformed request"), @APIResponse(responseCode="403", description="User lacks authorization to create/update contexts"), @APIResponse(responseCode="404", description="Parent context not found (when creating new context)")})
    public String updateCreate(@PathParam(value="context-uuid") @Parameter(name="context-uuid", in=ParameterIn.PATH, description="The unique identifier of the context to create or update.\n- Must be a valid UUID string format (e.g., \"c0f314e7-2807-4241-a792-2a6c79ed4fd0\").\n", required=true, schema=@Schema(type=SchemaType.STRING, example="c0f314e7-2807-4241-a792-2a6c79ed4fd0")) String uuid, String json) throws ResourceRegistryException {
        this.logger.info("Requested to update/create {} with json {} ", (Object)"Context", (Object)json);
        this.setAccountingMethod(Method.UPDATE, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setIncludeMeta(true);
        serverRequestInfo.setAllMeta(true);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        contextManagement.setJson(json);
        return contextManagement.createOrUpdate();
    }

    @PATCH
    @Path(value="{context-uuid}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Change Context State", description="Changes the state of an existing context.\n\nOnly the state property from the JSON body is evaluated and returns the complete updated context.\nOnly authorized administrative users can perform this operation.\n\n\n**Request Examples:**\n- PATCH /contexts/c0f314e7-2807-4241-a792-2a6c79ed4fd0\n  Body: {\"state\": \"active\"} (changes context state to active).\n\n\n**Body Requirements:**\n\n**JSON Body Structure:**\n- Must contain a Context JSON representation;\n- Only the \"state\" property will be processed and applied;\n- All other properties in the body are ignored;\n- State values must be valid according to ContextState class.\n\n**Valid State Values:**\n- Refer to ContextState class for complete list of valid state values;\n- Invalid state values will result in an error.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can change state of any context without restrictions;\n\t- Has full administrative privileges across all contexts.\n\n- **Infrastructure-Manager:**\n\t- Can change state of any context without restrictions;\n\t- Has full administrative privileges across all contexts.\n\n- **Context-Manager:**\n\t- Can change state of contexts only if they are Context-Manager of the parent context;\n\t- The parent context must be the current context (retrieved from client's authorization token);\n\t- Cannot change state of contexts outside their management scope.\n\n- **Other Users:**\n\t- Cannot change context states;\n\t- Will receive authorization errors if attempting these operations.\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Context state successfully changed", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid state value or malformed request"), @APIResponse(responseCode="403", description="User lacks authorization to change context state"), @APIResponse(responseCode="404", description="Context with specified UUID does not exist")})
    public String changeState(@PathParam(value="context-uuid") @Parameter(name="context-uuid", in=ParameterIn.PATH, description="The unique identifier of the context whose state should be changed.\n- Must be a valid UUID string format (e.g., \"c0f314e7-2807-4241-a792-2a6c79ed4fd0\").\n", required=true, schema=@Schema(type=SchemaType.STRING, example="c0f314e7-2807-4241-a792-2a6c79ed4fd0")) String uuid, String json) throws ResourceRegistryException {
        this.logger.info("Requested to activate {} with UUID {}", (Object)"Context", (Object)uuid);
        this.setAccountingMethod(Method.UPDATE, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setIncludeMeta(true);
        serverRequestInfo.setAllMeta(true);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setJson(json);
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.changeState();
    }

    @DELETE
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Path(value="{context-uuid}")
    @Operation(summary="Delete Context", description="Deletes an existing context permanently from the system.\n\nOnly authorized administrative users can perform this irreversible operation.\n\n**IMPORTANT: This is an irreversible operation that permanently removes the context from the system.**\n\n\n**Request Examples:**\n- DELETE /contexts/c0f314e7-2807-4241-a792-2a6c79ed4fd0 (delete the specified context).\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can delete any context without restrictions;\n\t- Has full administrative privileges across all contexts.\n\n- **Infrastructure-Manager:**\n\t- Can delete any context without restrictions;\n\t- Has full administrative privileges across all contexts.\n\n- **Context-Manager:**\n\t- Can delete contexts only if they are Context-Manager of the parent context;\n\t- The parent context must be the current context (retrieved from client's authorization token);\n\t- Cannot delete contexts outside their management scope.\n\n- **Other Users:**\n\t- Cannot delete contexts;\n\t- Will receive authorization errors if attempting these operations.\n\n\n**Operation Behavior:**\n\n**Deletion Restrictions and Behavior:**\n\n**Context Hierarchy Restrictions:**\n- Cannot delete a context that has child contexts;\n- All child contexts must be deleted first (or moved to a different parent) before deleting a parent context;\n- This ensures the integrity of the context hierarchy structure.\n\n**Instance Management:**\n- Instances belonging to the deleted context will no longer belong to any context;\n- **Critical**: If instances exist only in the deleted context (not shared with other contexts), they will be permanently deleted from the system;\n- Instances that also belong to other contexts will remain in those other contexts;\n- **This instance deletion is irreversible** - ensure instances are backed up or moved to other contexts if needed.\n\n**Hierarchical Query Impact:**\n- Hierarchical queries performed on the parent context will change;\n- Instances that were previously returned in hierarchical queries (due to belonging to the deleted context) will no longer appear;\n- The context tree structure will be updated to reflect the removal.\n\n**Context History and Audit Trail:**\n- While the context is permanently removed from the active system, a record is maintained in an internal \"cemetery\" system;\n- This allows for audit trails and historical tracking of deleted contexts;\n- **Future Enhancement**: Administrative users will have the ability to list deleted contexts from this cemetery;\n- The UUID of the deleted context becomes permanently unavailable for reuse.\n\n**Irreversible Operation:**\n- **This operation cannot be undone**;\n- Once deleted, the context cannot be restored through normal operations;\n- All relationships, instances, and configuration associated with the context are permanently lost;\n- Ensure proper backup and confirmation procedures before performing this operation.\n")
    @APIResponses(value={@APIResponse(responseCode="204", description="Context successfully deleted"), @APIResponse(responseCode="400", description="Context has child contexts and cannot be deleted"), @APIResponse(responseCode="403", description="User lacks authorization to delete contexts"), @APIResponse(responseCode="404", description="Context with specified UUID does not exist")})
    public Response delete(@PathParam(value="context-uuid") @Parameter(name="context-uuid", in=ParameterIn.PATH, description="The unique identifier of the context to delete.\n- Must be a valid UUID string format (e.g., \"c0f314e7-2807-4241-a792-2a6c79ed4fd0\").\n", required=true, schema=@Schema(type=SchemaType.STRING, example="c0f314e7-2807-4241-a792-2a6c79ed4fd0")) String uuid) throws ContextNotFoundException, ResourceRegistryException {
        this.logger.info("Requested to delete {} with id {} ", (Object)"Context", (Object)uuid);
        InnerMethodName.set((String)"deleteContext");
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        contextManagement.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

