/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;
import org.gcube.common.informationsystem.publisher.impl.instancestates.InstanceStatePublisher;
import org.gcube.common.informationsystem.publisher.impl.resources.RegistryResourcePublisher;

public class GCUBEPublisher
implements ISPublisher {
    protected static final GCUBELog logger = new GCUBELog(GCUBEPublisher.class);

    public InstanceStatePublisher getWSRPDocumentManager(GCUBEWSResource gCUBEWSResource, GCUBEScope ... gCUBEScopeArray) throws GCUBEPublisherException {
        GCUBEScope gCUBEScope = gCUBEScopeArray == null || gCUBEScopeArray.length == 0 ? gCUBEWSResource.getServiceContext().getScope() : gCUBEScopeArray[0];
        return new InstanceStatePublisher(gCUBEScope);
    }

    public void registerWSResource(GCUBEWSResource gCUBEWSResource, GCUBEScope ... gCUBEScopeArray) throws ISPublisherException {
        logger.debug((Object)("GCUBEPublisher is going to publish a new WSResource (" + gCUBEWSResource.getID() + ") in scope " + Arrays.toString(gCUBEScopeArray)));
        this.getWSRPDocumentManager(gCUBEWSResource, gCUBEScopeArray).register(gCUBEWSResource, new String[0]);
    }

    public void removeWSResource(GCUBEWSResource gCUBEWSResource, GCUBEScope ... gCUBEScopeArray) throws ISPublisherException {
        logger.debug((Object)("GCUBEPublisher is going to remvo a WSResource (" + gCUBEWSResource.getID() + ") from scope " + Arrays.toString(gCUBEScopeArray)));
        try {
            this.getWSRPDocumentManager(gCUBEWSResource, gCUBEScopeArray).remove(gCUBEWSResource, new String[0]);
        }
        catch (Exception exception) {
            throw new GCUBEPublisherException("Unable to remove the resource", exception);
        }
    }

    public String registerGCUBEResource(GCUBEResource gCUBEResource, GCUBEScope gCUBEScope, GCUBESecurityManager gCUBESecurityManager) throws ISPublisherException {
        logger.debug((Object)("GCUBEPublisher is going to publish a new GCUBEResource (" + gCUBEResource.getID() + ") in scope " + gCUBEScope));
        try {
            new RegistryResourcePublisher(gCUBEScope).create(gCUBEResource);
            logger.debug((Object)("GCUBEResource (" + gCUBEResource.getID() + ") successfully published in scope " + gCUBEScope));
            StringWriter stringWriter = new StringWriter();
            gCUBEResource.store((Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            logger.error((Object)("Error occurred while registering GCUBEResource " + gCUBEResource.getID()));
            throw new GCUBEPublisherException("Error occurred while registering GCUBEResource", exception);
        }
    }

    public void removeGCUBEResource(String string, String string2, GCUBEScope gCUBEScope, GCUBESecurityManager gCUBESecurityManager) throws ISPublisherException {
        logger.debug((Object)("GCUBEPublisher is going to remove a GCUBEResource (" + string + ") from scope " + gCUBEScope));
        try {
            new RegistryResourcePublisher(gCUBEScope).remove(string, string2);
            logger.debug((Object)("GCUBEResource " + string + " successfully removed from scope " + gCUBEScope));
        }
        catch (Exception exception) {
            logger.error((Object)("An error occured while removing GCUBEResource " + string));
            throw new GCUBEPublisherException("An error occured while removing GCUBEResource ", exception);
        }
    }

    public void updateGCUBEResource(GCUBEResource gCUBEResource, GCUBEScope gCUBEScope, GCUBESecurityManager gCUBESecurityManager) throws ISPublisherException {
        try {
            new RegistryResourcePublisher(gCUBEScope).update(gCUBEResource);
        }
        catch (Exception exception) {
            logger.error((Object)("An error occurred while updating GCUBEResource " + gCUBEResource.getID()));
            throw new GCUBEPublisherException("An error occurred while updating GCUBEResource", exception);
        }
    }

    public void updateWSResource(GCUBEWSResource gCUBEWSResource, GCUBEScope ... gCUBEScopeArray) throws ISPublisherException {
        this.removeWSResource(gCUBEWSResource, gCUBEScopeArray);
        this.registerWSResource(gCUBEWSResource, gCUBEScopeArray);
    }
}

