/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.generic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.core.scope.ServiceMap;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;

public class SinkLoader {
    protected static final GCUBELog logger = new GCUBELog(SinkLoader.class);
    private static Map<String, Set<EndpointReferenceType>> cachedInstanceAddressMap = new HashMap<String, Set<EndpointReferenceType>>();
    private static Map<String, Set<EndpointReferenceType>> cachedResourceAddressMap = new HashMap<String, Set<EndpointReferenceType>>();
    private static Map<String, Set<EndpointReferenceType>> cachedWSDAIXAddressMap = new HashMap<String, Set<EndpointReferenceType>>();

    public static Set<EndpointReferenceType> loadStateSinks(GCUBEScope gCUBEScope) throws ISPublisherException {
        ServiceMap serviceMap = SinkLoader.getMap(gCUBEScope);
        HashSet<EndpointReferenceType> hashSet = new HashSet<EndpointReferenceType>();
        if (cachedInstanceAddressMap.containsKey(gCUBEScope.toString())) {
            return cachedInstanceAddressMap.get(gCUBEScope.toString());
        }
        if (serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICStateCollectionPT) != null) {
            hashSet.addAll(serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICStateCollectionPT));
        }
        if (serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICAllCollectionPT) != null) {
            hashSet.addAll(serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICAllCollectionPT));
        }
        if (hashSet.size() == 0) {
            throw new GCUBEPublisherException("Unable to find any IC instance to publish RPDocuments");
        }
        cachedInstanceAddressMap.put(gCUBEScope.toString(), hashSet);
        return hashSet;
    }

    public static Set<EndpointReferenceType> loadResourceSinks(GCUBEScope gCUBEScope) throws ISPublisherException {
        ServiceMap serviceMap = SinkLoader.getMap(gCUBEScope);
        HashSet<EndpointReferenceType> hashSet = new HashSet<EndpointReferenceType>();
        if (cachedResourceAddressMap.containsKey(gCUBEScope.toString())) {
            return cachedResourceAddressMap.get(gCUBEScope.toString());
        }
        if (serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICProfileCollectionPT) != null) {
            hashSet.addAll(serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICProfileCollectionPT));
        }
        if (serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICAllCollectionPT) != null) {
            hashSet.addAll(serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICAllCollectionPT));
        }
        if (hashSet.size() == 0) {
            throw new GCUBEPublisherException("Unable to find any IC instance to publish GCUBE Resources");
        }
        cachedResourceAddressMap.put(gCUBEScope.toString(), hashSet);
        return hashSet;
    }

    public static Set<EndpointReferenceType> loadWSDAIXSinks(GCUBEScope gCUBEScope) throws ISPublisherException {
        ServiceMap serviceMap = SinkLoader.getMap(gCUBEScope);
        HashSet<EndpointReferenceType> hashSet = new HashSet<EndpointReferenceType>();
        if (cachedWSDAIXAddressMap.containsKey(gCUBEScope.toString())) {
            return cachedWSDAIXAddressMap.get(gCUBEScope.toString());
        }
        if (serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICWSDAIXCollectionPT) != null) {
            hashSet.addAll(serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICWSDAIXCollectionPT));
        }
        if (serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICAllCollectionPT) != null) {
            hashSet.addAll(serviceMap.getEndpoints((Object)ServiceMap.ServiceType.ISICAllCollectionPT));
        }
        if (hashSet.size() == 0) {
            throw new GCUBEPublisherException("Unable to find any IC instance to publish DAIX Resources");
        }
        cachedWSDAIXAddressMap.put(gCUBEScope.toString(), hashSet);
        return hashSet;
    }

    private static ServiceMap getMap(GCUBEScope gCUBEScope) throws ISPublisherException {
        ServiceMap serviceMap = null;
        try {
            serviceMap = gCUBEScope.getServiceMap();
        }
        catch (GCUBEScopeNotSupportedException gCUBEScopeNotSupportedException) {
            logger.error((Object)("error retrieving service map for scope " + gCUBEScope.toString()), (Throwable)gCUBEScopeNotSupportedException);
            throw new GCUBEPublisherException(gCUBEScopeNotSupportedException.getMessage());
        }
        return serviceMap;
    }
}

