/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.resources;

import java.io.StringWriter;
import java.io.Writer;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.BaseISPublisherHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryClient;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryServiceUpdaterHandler;

public class UpdateResourceHandler
extends BaseISPublisherHandler {
    protected static final GCUBELog logger = new GCUBELog(UpdateResourceHandler.class);
    private GCUBEScope scope;
    private ISRegistryClient registryClient;
    private final GCUBEResource profile;

    public UpdateResourceHandler(GCUBEScope gCUBEScope, ISRegistryClient iSRegistryClient, GCUBEResource gCUBEResource) {
        this.scope = gCUBEScope;
        this.registryClient = iSRegistryClient;
        this.profile = gCUBEResource;
    }

    @Override
    public String getResourceID() {
        return this.profile.getID();
    }

    @Override
    protected void submitRequest() throws Exception {
        this.registryClient.setScope(this.scope);
        try {
            ISRegistryServiceUpdaterHandler iSRegistryServiceUpdaterHandler = new ISRegistryServiceUpdaterHandler();
            iSRegistryServiceUpdaterHandler.setResourceType(this.profile.getType());
            iSRegistryServiceUpdaterHandler.setResourceID(this.profile.getID());
            StringWriter stringWriter = new StringWriter();
            this.profile.store((Writer)stringWriter);
            iSRegistryServiceUpdaterHandler.setProfile(stringWriter.toString());
            iSRegistryServiceUpdaterHandler.setHandled((Object)this.registryClient);
            iSRegistryServiceUpdaterHandler.run();
            logger.trace((Object)("Resource with ID=" + this.profile.getID() + " successfully updated"));
        }
        catch (GCUBEUnrecoverableException gCUBEUnrecoverableException) {
            logger.warn((Object)"Registration failed", (Throwable)gCUBEUnrecoverableException);
        }
    }
}

