/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.registrations.resources;

import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstance;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstanceGroup;

public class ISRegistryLookup
extends GCUBEHandler<GCUBEScope> {
    public void run() throws Exception {
        this.logger.trace((Object)"Querying the IS for Registry instances");
        List<GCUBERunningInstance> list = this.queryForISRegistry();
        this.logger.trace((Object)("Number of instances discovered: " + list.size()));
        if (list.size() == 0) {
            throw new NoRegistryAvailableException();
        }
        ISRegistryInstanceGroup iSRegistryInstanceGroup = ISRegistryInstanceGroup.getInstanceGroup();
        for (GCUBERunningInstance gCUBERunningInstance : list) {
            iSRegistryInstanceGroup.addRegistry(ISRegistryInstance.fromGCUBERunningInstance(gCUBERunningInstance));
        }
    }

    private List<GCUBERunningInstance> queryForISRegistry() throws Exception {
        ISClient iSClient = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery gCUBERIQuery = (GCUBERIQuery)iSClient.getQuery(GCUBERIQuery.class);
        gCUBERIQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", ISRegistryInstance.ISREGISTRY_NAME)});
        gCUBERIQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", ISRegistryInstance.ISREGISTRY_CLASS)});
        return iSClient.execute((ISQuery)gCUBERIQuery, (GCUBEScope)this.getHandled());
    }

    public static class NoRegistryAvailableException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

