package org.gcube.keycloak.event;

import java.util.EventListener;

import org.gcube.event.publisher.AbstractEventPublisher;
import org.gcube.event.publisher.EventSender;
import org.gcube.event.publisher.HTTPWithUMAAuthEventSender;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;

/**
 * @author <a href="mailto:marco.lettere@nubisware.com">Marco Lettere</a>
 * @author <a href="mailto:mauro.mugnaini@nubisware.com">Mauro Mugnaini</a>
 */
public class OrchestratorEventPublisherProvider extends AbstractEventPublisher
        implements EventListenerProvider, EventListener {

    public static final Logger logger = Logger.getLogger(OrchestratorEventPublisherProvider.class);

    public OrchestratorEventPublisherProvider() {
        super();
    }

    @Override
    public void close() {
    }

    @Override
    public void onEvent(Event event) {
        if (event.getError() != null) {
            logger.debug("Skipping error event publish");
            return;
        }
        logger.debug("Publishing new event to orchestrator");
        publish(KeycloakEvent.newKeycloakEvent(event));
    }

    @Override
    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        if (event.getError() != null) {
            logger.debug("Skipping error admin event publish");
            return;
        }
        logger.debug("Publishing new admin event to orchestrator");
        publish(KeycloakEvent.newKeycloakAdminEvent(event));
    }

    @Override
    protected EventSender createEventSender() {
        logger.infof("Creating the HTTP event sender with endpoint: %s",
                OrchestratorEventPublisherProviderFactory.endpoint);

        return new HTTPWithUMAAuthEventSender(OrchestratorEventPublisherProviderFactory.endpoint, null, null, null,
                null);
    }

}
