package org.gcube.keycloak.event;

import java.net.MalformedURLException;
import java.net.URL;

import org.jboss.logging.Logger;
import org.keycloak.Config.Scope;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

/**
 * @author <a href="mailto:marco.lettere@nubisware.com">Marco Lettere</a>
 * @author <a href="mailto:mauro.mugnaini@nubisware.com">Mauro Mugnaini</a>
 */
public class OrchestratorEventPublisherProviderFactory implements EventListenerProviderFactory {

    public static final String REALM_NAME = "d4science";
    public static final String ORCHESTRATOR_CLIENT_ID = "orchestrator";

    private static final Logger logger = Logger.getLogger(OrchestratorEventPublisherProviderFactory.class);

    public static URL endpoint;
    protected OrchestratorEventPublisherProvider oepp;

    public OrchestratorEventPublisherProviderFactory() {
        logger.info("New OrchestratorEventPublisherProviderFactory has been created");
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized EventListenerProvider create(KeycloakSession keycloakSession) {
        logger.debugf("Getting configured endpoint address for client '%s' in realm '%s'", ORCHESTRATOR_CLIENT_ID,
                REALM_NAME);

        String address = keycloakSession.realms().getRealmByName(REALM_NAME).getClientByClientId(ORCHESTRATOR_CLIENT_ID)
                .getBaseUrl();
        try {
            URL newEndpoint = new URL(address);
            if (oepp == null || !newEndpoint.equals(endpoint)) {
                logger.infof("Creating new orchestrator event publisher provider for endpoint: %s", address);
                OrchestratorEventPublisherProviderFactory.endpoint = newEndpoint;
                // Endpoint address will be read from 'address' static field in this class
                oepp = new OrchestratorEventPublisherProvider();
            }
        } catch (MalformedURLException e) {
            logger.error("Can't create new orchestrator event publisher provider with endpoint address: " + address,
                    e);
            oepp = null;
        }
        return oepp;
    }

    @Override
    public String getId() {
        return "orchestrator-event-publisher";
    }

    @Override
    public void init(Scope scope) {
    }

    @Override
    public void postInit(KeycloakSessionFactory keycloakSessionFactory) {
    }

}
