/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.event;

import java.util.EventListener;
import org.gcube.event.publisher.AbstractEventPublisher;
import org.gcube.event.publisher.EventSender;
import org.gcube.event.publisher.HTTPWithUMAAuthEventSender;
import org.gcube.keycloak.event.KeycloakEvent;
import org.gcube.keycloak.event.OrchestratorEventPublisherProviderFactory;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;

public class OrchestratorEventPublisherProvider
extends AbstractEventPublisher
implements EventListenerProvider,
EventListener {
    public static final Logger logger = Logger.getLogger(OrchestratorEventPublisherProvider.class);

    public void close() {
    }

    public void onEvent(Event event) {
        if (event.getError() != null) {
            logger.debug((Object)"Skipping error event publish");
            return;
        }
        logger.debug((Object)"Publishing new event to orchestrator");
        this.publish(KeycloakEvent.newKeycloakEvent(event));
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        if (event.getError() != null) {
            logger.debug((Object)"Skipping error admin event publish");
            return;
        }
        logger.debug((Object)"Publishing new admin event to orchestrator");
        this.publish(KeycloakEvent.newKeycloakAdminEvent(event));
    }

    protected EventSender createEventSender() {
        logger.infof("Creating the HTTP event sender with endpoint: %s", (Object)OrchestratorEventPublisherProviderFactory.endpoint);
        return new HTTPWithUMAAuthEventSender(OrchestratorEventPublisherProviderFactory.endpoint, null, null, null, null);
    }
}

