/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.gcube.common.accounting.node.persistence.RIAccountingData;
import org.gcube.common.accounting.node.util.Util;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public class PersistenceAdapter {
    private GCUBELog logger = null;
    private HashMap<String, HashMap<String, RIAccountingData>> map = null;
    private static String persistenceFolder = GHNContext.getContext().getStorageRoot() + File.separator + "Accounting";
    private static File accountingDataFileName = new File(persistenceFolder + File.separator + "Accounting.store");
    private Calendar lastUpdate;
    private Long interval;
    private boolean recreateState = false;

    public PersistenceAdapter(GCUBELog gCUBELog, Long l) {
        this.interval = l;
        if (!new File(persistenceFolder).exists()) {
            gCUBELog.debug((Object)"Creating persistence folder");
            new File(persistenceFolder).mkdirs();
        }
        this.logger = gCUBELog;
    }

    public Calendar getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Calendar calendar) {
        this.lastUpdate = calendar;
    }

    public void store() throws Exception {
        File file = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            file = File.createTempFile("persistence", ".tmp", new File(persistenceFolder));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.map);
            objectOutputStream.writeObject(this.lastUpdate);
            objectOutputStream.writeObject(this.interval);
            objectOutputStream.flush();
            fileOutputStream.getFD().sync();
            if (!file.renameTo(accountingDataFileName)) {
                throw new Exception("Could not rename temporary serialisation file for " + accountingDataFileName);
            }
        }
        catch (Exception exception) {
            if (file != null) {
                file.delete();
            }
            throw exception;
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (Exception exception) {
                this.logger.warn((Object)"Could not close stream on file serialisation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void load() throws Exception {
        if (PersistenceAdapter.accountingDataFileName.exists()) {
            var1_1 = new FileInputStream(PersistenceAdapter.accountingDataFileName);
            var2_2 = null;
            try {
                var2_2 = new ObjectInputStream((InputStream)var1_1);
                this.map = (HashMap)var2_2.readObject();
                this.lastUpdate = (Calendar)var2_2.readObject();
                var3_3 = (Long)var2_2.readObject();
                if (var3_3 != null && var3_3.longValue() != this.interval.longValue()) {
                    this.recreateState = true;
                }
                if (!this.recreateState) ** GOTO lbl23
                this.logger.warn((Object)"Interval changed. recreating state");
            }
            finally {
                try {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                }
                catch (Exception var3_4) {
                    this.logger.warn((Object)"Could not close stream on file deserialisation");
                }
            }
        } else {
            this.recreateState = true;
        }
lbl23:
        // 3 sources

        if (this.recreateState) {
            this.map = new HashMap<K, V>();
            for (GCUBEServiceContext var2_2 : GHNContext.getContext().getServiceContexts()) {
                var3_3 = null;
                var4_6 = new MapKey<String, String>(var2_2.getServiceClass(), var2_2.getName()).getKey();
                var3_3 = this.map.get(var4_6);
                if (var3_3 == null) {
                    var3_3 = new HashMap<K, V>();
                }
                for (GCUBEScope var6_11 : var2_2.getInstance().getScopes().values()) {
                    var7_14 = new RIAccountingData(this.getInterval());
                    var7_14.setServiceClass(var2_2.getServiceClass());
                    var7_14.setServiceName(var2_2.getName());
                    var3_3.put((String)var6_11.toString(), (RIAccountingData)var7_14);
                }
                this.map.put(var4_6, (HashMap<String, RIAccountingData>)var3_3);
            }
        } else {
            for (GCUBEServiceContext var2_2 : GHNContext.getContext().getServiceContexts()) {
                var3_3 = new MapKey<String, String>(var2_2.getServiceClass(), var2_2.getName()).getKey();
                if (this.map.get(var3_3) != null) continue;
                var4_7 = new HashMap<K, V>();
                for (GCUBEScope var6_12 : var2_2.getInstance().getScopes().values()) {
                    var7_15 = new RIAccountingData(this.getInterval());
                    var7_15.setServiceClass(var2_2.getServiceClass());
                    var7_15.setServiceName(var2_2.getName());
                    var4_7.put(var6_12.toString(), var7_15);
                }
                this.map.put((String)var3_3, (HashMap<String, RIAccountingData>)var4_7);
            }
            var1_1 = new ArrayList<E>();
            for (Object var3_3 : this.map.keySet()) {
                var4_7 = Util.getClazz((String)var3_3);
                var5_10 = Util.getName((String)var3_3);
                try {
                    GHNContext.getContext().getServiceContext((String)var4_7, var5_10);
                }
                catch (Exception var6_13) {
                    var1_1.add(var3_3);
                }
            }
            var2_2 = var1_1.iterator();
            while (var2_2.hasNext()) {
                var3_3 = (String)var2_2.next();
                this.map.remove(var3_3);
            }
        }
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long l) {
        this.interval = l;
    }

    public HashMap<String, HashMap<String, RIAccountingData>> getMap() {
        return this.map;
    }

    public void setMap(HashMap<String, HashMap<String, RIAccountingData>> hashMap) {
        this.map = hashMap;
    }

    public boolean alreadyUpdated() {
        if (this.getLastUpdate() == null) {
            return false;
        }
        return Calendar.getInstance().getTimeInMillis() / 1000L - this.getInterval() <= this.getLastUpdate().getTimeInMillis() / 1000L;
    }

    public class MapKey<CLASS, NAME>
    implements Serializable {
        private CLASS clazz;
        private NAME name;

        public MapKey(CLASS CLASS, NAME NAME) {
            this.clazz = CLASS;
            this.name = NAME;
        }

        public String getKey() {
            return this.clazz + "_" + this.name;
        }
    }
}

