/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.persistence;

import java.io.Serializable;
import java.util.HashMap;
import org.gcube.common.accounting.node.persistence.Statistics;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class TopCallerData
implements Serializable {
    public static Long HOUR_INTERVAL_S = new Long(3600L);
    public static Long DAY_INTERVAL_S = HOUR_INTERVAL_S * 24L;
    public Long intervalXHour;
    public Long intervalXday;
    private static final long serialVersionUID = 1L;
    private long interval = 0L;
    private HashMap<String, HashMap<Long, Statistics>> callerMap = null;

    public TopCallerData(long l) {
        this.interval = l;
        this.intervalXHour = HOUR_INTERVAL_S / this.interval;
        this.intervalXday = DAY_INTERVAL_S / this.interval;
    }

    public HashMap<String, HashMap<Long, Statistics>> getCallerMap() {
        return this.callerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallerInfo(String string, Long l) throws Exception {
        if (this.callerMap == null) {
            this.callerMap = new HashMap();
        }
        HashMap<String, HashMap<Long, Statistics>> hashMap = this.callerMap;
        synchronized (hashMap) {
            HashMap<Object, Object> hashMap2 = null;
            if (this.callerMap.get(string) == null) {
                try {
                    hashMap2 = new HashMap();
                    Statistics statistics = new Statistics(this.intervalXHour);
                    statistics.addAvg(l);
                    Statistics statistics2 = new Statistics(this.intervalXday);
                    statistics2.addAvg(l);
                    hashMap2.put(this.intervalXHour, statistics);
                    hashMap2.put(this.intervalXday, statistics2);
                }
                catch (Exception exception) {
                    GCUBELocalProducer.logger.debug((Object)("Error creating top caller map Data for caller " + string), (Throwable)exception);
                    throw exception;
                }
            }
            try {
                hashMap2 = this.callerMap.get(string);
                ((Statistics)hashMap2.get(this.intervalXHour)).addAvg(l);
                ((Statistics)hashMap2.get(this.intervalXday)).addAvg(l);
            }
            catch (Exception exception) {
                GCUBELocalProducer.logger.debug((Object)("Error updating top caller map Data for caller " + string), (Throwable)exception);
                throw exception;
            }
            this.callerMap.put(string, hashMap2);
        }
    }

    public TopCallerInfo getTopCallerInfo() {
        String string = null;
        long l = 0L;
        for (String string2 : this.callerMap.keySet()) {
            if (this.callerMap.get(string2).get(this.intervalXHour).getTotalCalls() < l) continue;
            l = this.callerMap.get(string2).get(this.intervalXHour).getTotalCalls();
            string = string2;
        }
        return new TopCallerInfo(string, l);
    }

    public Long getIntervalXHour() {
        return this.intervalXHour;
    }

    public void setIntervalXHour(Long l) {
        this.intervalXHour = l;
    }

    public Long getIntervalXday() {
        return this.intervalXday;
    }

    public void setIntervalXday(Long l) {
        this.intervalXday = l;
    }

    public class TopCallerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String callerHost;
        private long totalCalls;

        public TopCallerInfo(String string, long l) {
            this.callerHost = string;
            this.totalCalls = l;
        }

        public String getCallerHost() {
            return this.callerHost;
        }

        public void setCallerHost(String string) {
            this.callerHost = string;
        }

        public long getTotalCalls() {
            return this.totalCalls;
        }

        public void setTotalCalls(long l) {
            this.totalCalls = l;
        }
    }
}

