/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.persistence;

import java.io.Serializable;
import org.gcube.common.accounting.node.persistence.StatisticsData;
import org.gcube.common.accounting.node.persistence.TopCallerData;

public class RIAccountingData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serviceClass;
    private StatisticsData avgInvocationTime = null;
    private StatisticsData avgCallsNumber = null;
    private long totalCalls = 0L;
    private TopCallerData topCallerData = null;
    private long interval = 0L;

    public RIAccountingData(Long interval) {
        this.interval = interval;
    }

    public StatisticsData getAvgInvocationTime() {
        if (this.avgInvocationTime == null) {
            this.avgInvocationTime = new StatisticsData(statisticsType.InvocationTime, this.interval);
        }
        return this.avgInvocationTime;
    }

    public StatisticsData getAvgCallsNumber() {
        if (this.avgCallsNumber == null) {
            this.avgCallsNumber = new StatisticsData(statisticsType.IncomingCalls, this.interval);
        }
        return this.avgCallsNumber;
    }

    public void addCalls(long calls) {
        this.totalCalls += calls;
    }

    public long getTotalCalls() {
        return this.totalCalls;
    }

    public TopCallerData getTopCallerData() {
        if (this.topCallerData == null) {
            this.topCallerData = new TopCallerData(this.interval);
        }
        return this.topCallerData;
    }

    public int hashcode() {
        return (this.serviceClass + this.serviceName).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RIAccountingData other = (RIAccountingData)obj;
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        return !(this.serviceClass == null ? other.serviceClass != null : !this.serviceClass.equals(other.serviceClass));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public static enum statisticsType {
        InvocationTime("INVOCATIONTIME"),
        IncomingCalls("INCOMINGCALLS");

        String type;

        private statisticsType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

