/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.persistence;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.gcube.common.accounting.node.persistence.RIAccountingData;

public class StatisticsData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long interval = 0L;
    private RIAccountingData.statisticsType type = null;
    private LinkedBlockingQueue<Double> queue = null;
    private HashMap<Long, Long> intervalMapping = new HashMap();

    public StatisticsData(RIAccountingData.statisticsType type, long interval) {
        this.type = type;
        this.interval = interval;
        this.queue = new LinkedBlockingQueue(5);
        this.intervalMapping.put(interval, new Long(0L));
        this.intervalMapping.put(interval * 3L, new Long(2L));
        this.intervalMapping.put(interval * 5L, new Long(4L));
    }

    public RIAccountingData.statisticsType getType() {
        return this.type;
    }

    public void setType(RIAccountingData.statisticsType type) {
        this.type = type;
    }

    public void addStatistics(Double value) throws Exception {
        if (!this.queue.offer(value)) {
            this.queue.take();
            if (!this.queue.offer(value)) {
                throw new Exception();
            }
        }
    }

    public Double getStatistics(Long index) throws Exception {
        if (this.queue.size() == 0) {
            return 0.0;
        }
        Iterator<Double> it = this.queue.iterator();
        int i = 0;
        Double value = new Double(0.0);
        while ((long)i <= index && it.hasNext()) {
            value = value + it.next();
            ++i;
        }
        return value == null || value.equals(0.0) ? Double.valueOf(0.0) : value / (double)i;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public HashMap<Long, Long> getIntervalMapping() {
        return this.intervalMapping;
    }

    public void setIntervalMapping(HashMap<Long, Long> intervalMapping) {
        this.intervalMapping = intervalMapping;
    }
}

