/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.util;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.gcube.common.accounting.node.logparser.LogEntry;
import org.gcube.common.accounting.node.logparser.RIInvocationParser;
import org.gcube.common.accounting.node.persistence.PersistenceAdapter;
import org.gcube.common.accounting.node.persistence.RIAccountingData;
import org.gcube.common.accounting.node.util.DateInterval;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.messages.NodeAccountingMessage;
import org.gcube.messaging.common.messages.records.IntervalRecord;

public class Util {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DAY = "yyyy-MM-dd";
    public static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat format_day = new SimpleDateFormat("yyyy-MM-dd");
    GCUBELog logger = null;

    public Util(GCUBELog logger) {
        this.logger = logger;
    }

    protected ArrayList<NodeAccountingMessage<IntervalRecord>> groupAccountingMessages(ArrayList<LogEntry> entries, DateInterval interval) {
        ArrayList<NodeAccountingMessage<IntervalRecord>> messages = new ArrayList<NodeAccountingMessage<IntervalRecord>>();
        HashMap mapInfo = new HashMap();
        for (LogEntry entry : entries) {
            HashMap mapService = null;
            HashMap<String, InvocationInfo> mapIP = null;
            InvocationInfo info = null;
            mapService = (HashMap)mapInfo.get(entry.getScope());
            if (mapService == null) {
                mapService = new HashMap();
            }
            if ((mapIP = (HashMap<String, InvocationInfo>)mapService.get(entry.getInfo().toString())) == null) {
                mapIP = new HashMap<String, InvocationInfo>();
            }
            if ((info = (InvocationInfo)mapIP.get(entry.getInfo().getCallerIP())) == null) {
                info = new InvocationInfo();
            }
            info.addInvocation(entry.getInvocationTime());
            info.setTime(entry.getTime());
            info.setIP(entry.getInfo().getCallerIP());
            mapIP.put(entry.getInfo().getCallerIP(), info);
            mapService.put(entry.getInfo().toString(), mapIP);
            mapInfo.put(entry.getScope(), mapService);
        }
        for (GCUBEScope scope : mapInfo.keySet()) {
            for (String info : ((HashMap)mapInfo.get(scope)).keySet()) {
                NodeAccountingMessage message = new NodeAccountingMessage();
                message.setCallScope(scope.toString());
                message.setServiceClass(Util.getClazz(info));
                message.setServiceName(Util.getName(info));
                for (String ip : ((HashMap)((HashMap)mapInfo.get(scope)).get(info)).keySet()) {
                    IntervalRecord record = new IntervalRecord(Long.valueOf(interval.getInterval() / 1000L));
                    record.setStartInterval(interval.getStartDate().getTime());
                    record.setEndInterval(interval.getEndDate().getTime());
                    record.setAverageInvocationTime(Double.valueOf(((InvocationInfo)((HashMap)((HashMap)mapInfo.get(scope)).get(info)).get(ip)).getAverageInvocationTime()));
                    record.setInvocationNumber(Long.valueOf(((InvocationInfo)((HashMap)((HashMap)mapInfo.get(scope)).get(info)).get(ip)).getInvocationCount()));
                    record.setIP(ip);
                    message.setTime(((InvocationInfo)((HashMap)((HashMap)mapInfo.get(scope)).get(info)).get(ip)).getTime());
                    message.setRecord(ip, record);
                }
                messages.add((NodeAccountingMessage<IntervalRecord>)message);
            }
        }
        return messages;
    }

    public ArrayList<DateInterval> generateDateIntervals(PersistenceAdapter adapter, Long interval) {
        ArrayList<DateInterval> intervals = new ArrayList<DateInterval>();
        long msinterval = interval * 1000L;
        Calendar start = null;
        start = adapter.getLastUpdate();
        if (start == null) {
            intervals.add(new DateInterval(msinterval));
        } else {
            long starts = start.getTimeInMillis();
            long ends = Calendar.getInstance().getTimeInMillis();
            long nInt = (ends - starts) / msinterval;
            if (nInt == 0L) {
                nInt = 1L;
            }
            long temps = starts;
            Calendar starttmp = Calendar.getInstance();
            Calendar endtmp = Calendar.getInstance();
            int i = 0;
            while ((long)i < nInt) {
                starttmp.setTime(new Date(temps));
                endtmp.setTime(new Date(temps + msinterval));
                intervals.add(new DateInterval(starttmp, endtmp, msinterval));
                temps += msinterval;
                ++i;
            }
        }
        for (DateInterval inter : intervals) {
            this.logger.debug((Object)("Generated Date Interval from " + inter.getStartDateAsString() + " to " + inter.getEndDateAsString()));
        }
        return intervals;
    }

    public HashMap<File, ArrayList<DateInterval>> matchIntervalsWithLogFiles(File[] files, ArrayList<DateInterval> inputIntervals) {
        HashMap<File, ArrayList<DateInterval>> map = new HashMap<File, ArrayList<DateInterval>>();
        if (files == null || files.length == 0) {
            this.logger.debug((Object)"No Log Files to Parse");
            return map;
        }
        for (DateInterval interval : inputIntervals) {
            ArrayList<DateInterval> targetIntervals = null;
            File fileInput = null;
            if (interval.getStartDateAsShortString().compareTo(format_day.format(Calendar.getInstance().getTime())) == 0) {
                for (File file : files) {
                    if (!file.getAbsolutePath().endsWith("access.log")) continue;
                    fileInput = file;
                    break;
                }
            } else {
                for (File file : files) {
                    if (!file.getAbsolutePath().endsWith("access.log." + interval.getStartDateAsShortString())) continue;
                    fileInput = file;
                    break;
                }
                if (fileInput == null) {
                    for (File file : files) {
                        if (!file.getAbsolutePath().endsWith("access.log")) continue;
                        fileInput = file;
                        break;
                    }
                }
            }
            if (fileInput == null) {
                this.logger.debug((Object)("NO log file found for the interval " + interval.getStartDateAsString() + "/" + interval.getEndDateAsString()));
                continue;
            }
            targetIntervals = map.get(fileInput);
            if (targetIntervals == null) {
                targetIntervals = new ArrayList();
            }
            this.logger.debug((Object)("Adding interval " + interval.getStartDateAsString() + "/" + interval.getEndDateAsString() + " to file " + fileInput.getAbsolutePath()));
            targetIntervals.add(interval);
            map.put(fileInput, targetIntervals);
        }
        return map;
    }

    private ArrayList<NodeAccountingMessage<IntervalRecord>> filterMessage(ArrayList<NodeAccountingMessage<IntervalRecord>> messages, String serviceName, String serviceClass, String scope) {
        if (messages == null) {
            return new ArrayList<NodeAccountingMessage<IntervalRecord>>();
        }
        ArrayList<NodeAccountingMessage<IntervalRecord>> msgs = new ArrayList<NodeAccountingMessage<IntervalRecord>>();
        for (NodeAccountingMessage<IntervalRecord> msg : messages) {
            if (msg.getCallScope().compareTo(scope) != 0 || msg.getServiceClass().compareTo(serviceClass) != 0 || msg.getServiceName().compareTo(serviceName) != 0) continue;
            msgs.add(msg);
        }
        return msgs;
    }

    private RIAccountingData updateDataFromMessage(NodeAccountingMessage<IntervalRecord> message, RIAccountingData data) {
        if (message == null) {
            return data;
        }
        Double tempInvocationNumber = new Double(0.0);
        ArrayList<Double> tempInvocationTimeArray = new ArrayList<Double>();
        try {
            for (IntervalRecord record : message.getRecords().values()) {
                data.addCalls(record.getInvocationNumber());
                data.getTopCallerData().addCallerInfo(record.getIP(), record.getInvocationNumber());
                tempInvocationNumber = tempInvocationNumber + (double)record.getInvocationNumber().longValue();
                tempInvocationTimeArray.add(record.getAverageInvocationTime());
            }
            Double sumInvocationTime = new Double(0.0);
            for (Double number : tempInvocationTimeArray) {
                sumInvocationTime = sumInvocationTime + number;
            }
            data.getAvgCallsNumber().addStatistics(tempInvocationNumber);
            if (tempInvocationTimeArray.size() != 0) {
                data.getAvgInvocationTime().addStatistics(sumInvocationTime / (double)tempInvocationTimeArray.size());
            } else {
                data.getAvgInvocationTime().addStatistics(new Double(0.0));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"ERROR updating Accounting info from Message", (Throwable)e);
        }
        return data;
    }

    public void updateAccoutingInfo(ArrayList<NodeAccountingMessage<IntervalRecord>> messages, PersistenceAdapter adapter, DateInterval interval) throws Exception {
        for (String string : adapter.getMap().keySet()) {
            HashMap<String, RIAccountingData> map = adapter.getMap().get(string);
            for (String scope : map.keySet()) {
                try {
                    RIAccountingData data = map.get(scope);
                    ArrayList<NodeAccountingMessage<IntervalRecord>> msgs = this.filterMessage(messages, data.getServiceName(), data.getServiceClass(), scope);
                    if (msgs.size() > 0) {
                        for (NodeAccountingMessage<IntervalRecord> message : msgs) {
                            data = this.updateDataFromMessage(message, data);
                        }
                    } else {
                        data.getAvgCallsNumber().addStatistics(new Double(0.0));
                        data.getAvgInvocationTime().addStatistics(data.getAvgInvocationTime().getStatistics(new Long(0L)));
                        data.getTopCallerData().addCallerInfo("N/A", new Long(0L));
                    }
                    if (messages != null) {
                        messages.removeAll(msgs);
                    }
                    map.put(scope, data);
                }
                catch (Exception e) {
                    this.logger.error((Object)("ERROR updating Accounting info for service " + string + " in scope " + scope), (Throwable)e);
                }
            }
            adapter.getMap().put(string, map);
        }
        if (messages != null) {
            for (NodeAccountingMessage nodeAccountingMessage : messages) {
                PersistenceAdapter persistenceAdapter = adapter;
                persistenceAdapter.getClass();
                String service = new PersistenceAdapter.MapKey<String, String>(persistenceAdapter, nodeAccountingMessage.getServiceClass(), nodeAccountingMessage.getServiceName()).getKey();
                try {
                    HashMap<String, RIAccountingData> map = null;
                    map = adapter.getMap().get(service);
                    if (map == null) {
                        map = new HashMap();
                    }
                    RIAccountingData data = new RIAccountingData(adapter.getInterval());
                    data.setServiceClass(nodeAccountingMessage.getServiceClass());
                    data.setServiceName(nodeAccountingMessage.getServiceName());
                    data = this.updateDataFromMessage((NodeAccountingMessage<IntervalRecord>)nodeAccountingMessage, data);
                    map.put(nodeAccountingMessage.getCallScope(), data);
                    adapter.getMap().put(service, map);
                }
                catch (Exception e) {
                    this.logger.error((Object)("ERROR updating Accounting info for service " + service + " in scope " + nodeAccountingMessage.getCallScope()), (Throwable)e);
                }
            }
        }
        adapter.setLastUpdate(interval.getEndDate());
        adapter.store();
    }

    public ArrayList<NodeAccountingMessage<IntervalRecord>> createAccountingInfo(File input, DateInterval interval) throws IOException, Exception {
        this.logger.debug((Object)("Parsing Node Log file" + input.getAbsolutePath()));
        RIInvocationParser parser = null;
        try {
            parser = new RIInvocationParser(input.getAbsolutePath(), interval);
            parser.parse();
        }
        catch (IOException e) {
            this.logger.error((Object)"Error Parsing Node Log file", (Throwable)e);
            throw e;
        }
        catch (ParseException e) {
            this.logger.error((Object)"Error Parsing Node Log file", (Throwable)e);
            throw e;
        }
        if (parser.getEntryList().size() == 0) {
            this.logger.debug((Object)"No data to parse in the given interval");
            return null;
        }
        return this.groupAccountingMessages(parser.getEntryList(), interval);
    }

    public static String getClazz(String line) {
        return line.substring(0, line.indexOf("_"));
    }

    public static String getName(String line) {
        return line.substring(line.indexOf("_") + 1);
    }

    private class InvocationInfo {
        private long invocationCount;
        private double averageInvocationTime;
        private String time;
        private String IP;

        public double getAverageInvocationTime() {
            return this.averageInvocationTime / (double)this.invocationCount;
        }

        public long getInvocationCount() {
            return this.invocationCount;
        }

        public void addInvocation(Double invocationTime) {
            ++this.invocationCount;
            this.averageInvocationTime += invocationTime.doubleValue();
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public String getIP() {
            return this.IP;
        }

        public void setIP(String iP) {
            this.IP = iP;
        }
    }
}

