/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.common.messages.records.BaseRecord;

public abstract class LogEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Date date;
    protected String vre;
    protected BaseRecord record;
    protected AccessLogParser.EntryType entryType;
    protected Message message;
    protected String user;
    protected String line;
    protected static final String parameterValueSeparator = "=";
    protected static final String parameterSeparator = "->";
    protected static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void parse() throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.line, AccessLogParser.tokensSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.contains(TokensType.ENTRY_TYPE.type)) continue;
            if (string.contains(TokensType.VRE.type)) {
                this.vre = string.substring(string.indexOf(parameterSeparator) + parameterSeparator.length() + 1);
                continue;
            }
            if (string.contains(TokensType.MESSAGE.type)) {
                if (string.indexOf(parameterSeparator) + parameterSeparator.length() == string.length()) continue;
                string = string.substring(string.indexOf(parameterSeparator) + parameterSeparator.length() + 1);
                this.message = new Message(string, this.entryType);
                this.message.parse();
                continue;
            }
            if (string.contains(TokensType.USER.type)) {
                this.user = string.substring(string.indexOf(parameterSeparator) + parameterSeparator.length() + 1);
                continue;
            }
            this.date = format.parse(string);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public BaseRecord getRecord() {
        return this.record;
    }

    public void setRecordName(BaseRecord baseRecord) {
        this.record = baseRecord;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getVre() {
        return this.vre;
    }

    public void setVre(String string) {
        this.vre = string;
    }

    public String toString() {
        return this.getVre() + parameterSeparator + this.getUser() + parameterSeparator + this.getDate() + parameterSeparator + this.getMessage();
    }

    public AccessLogParser.EntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(AccessLogParser.EntryType entryType) {
        this.entryType = entryType;
    }

    public abstract BaseRecord fillRecord();

    protected static enum TokensType {
        USER("USER"),
        ENTRY_TYPE("ENTRY_TYPE"),
        MESSAGE("MESSAGE"),
        VRE("VRE");

        String type;

        private TokensType(String string2) {
            this.type = string2;
        }

        public String toString() {
            return this.type;
        }
    }
}

