/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.common.messages.records.HLRecord;
import org.gcube.messaging.common.messages.records.WebAppRecord;

public class Message {
    protected static final String messageTokensSeparator = "|";
    protected static final String hlAddresssesSeparator = ";";
    protected static final String hlAddresssesSeparator2 = ":";
    private AccessLogParser.EntryType type;
    private String message;
    private String term;
    private String operator;
    private String browseBy;
    private boolean isDistinct;
    private HashMap<String, String> collections = null;
    private HashMap<String, String> terms = null;
    private String[] content = new String[2];
    private String[] hlentry = new String[3];
    private String[] annotationEntry = new String[4];
    private String[] workflowDocumentsEntry = new String[3];
    private String[] reportEntry = new String[3];
    private String[] webAppEntry = new String[5];
    private String[] warEntry = new String[5];
    private ArrayList<WebAppRecord.GHN> listGHN = new ArrayList();
    private ArrayList<WebAppRecord.WebApplication> listApplication = new ArrayList();
    private String[] aquamapsEntry = new String[5];
    private ArrayList<HLRecord.GCUBEUser> addresseeUsers = null;
    private String[] aisentry = new String[2];
    private String tstitle;
    protected StringTokenizer tokenizer = null;

    public Message(String string, AccessLogParser.EntryType entryType) {
        this.message = string;
        this.type = entryType;
    }

    public void parse() throws ParseException {
        switch (this.type) {
            case Simple_Search: {
                this.collections = new HashMap();
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(SearchAndBrowseTokens.collectionName.tokens)) {
                        String[] stringArray = this.getDetails(string);
                        this.collections.put(stringArray[0], stringArray[1]);
                        continue;
                    }
                    if (!string.contains(SearchAndBrowseTokens.term.tokens)) continue;
                    this.term = this.getValue(string);
                }
                break;
            }
            case Advanced_Search: 
            case Browse_Collection: {
                this.collections = new HashMap();
                this.terms = new HashMap();
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String[] stringArray;
                    String string = stringTokenizer.nextToken();
                    if (string.contains(SearchAndBrowseTokens.collectionName.tokens)) {
                        stringArray = this.getDetails(string);
                        this.collections.put(stringArray[0], stringArray[1]);
                        continue;
                    }
                    if (string.contains(SearchAndBrowseTokens.term.tokens)) {
                        stringArray = this.getDetails(string);
                        this.terms.put(stringArray[1], stringArray[0]);
                        continue;
                    }
                    if (string.contains(SearchAndBrowseTokens.Browse_by.tokens)) {
                        this.browseBy = this.getValue(string);
                        continue;
                    }
                    if (string.contains(SearchAndBrowseTokens.DISTINCT.tokens)) {
                        this.isDistinct = Boolean.getBoolean(this.getValue(string));
                        continue;
                    }
                    if (!string.contains(SearchAndBrowseTokens.operator.tokens)) continue;
                    this.operator = this.getValue(string);
                }
                break;
            }
            case Retrieve_Content: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(RetrieveContentTokens.contentID.tokens)) {
                        this.content[0] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(RetrieveContentTokens.contentName.tokens)) continue;
                    this.content[1] = this.getValue(string);
                }
                break;
            }
            case Quick_Search: 
            case Google_Search: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (!string.contains(SearchAndBrowseTokens.term.tokens)) continue;
                    this.term = this.getValue(string);
                }
                break;
            }
            case HL_FOLDER_ITEM_CREATED: 
            case HL_FOLDER_ITEM_REMOVED: 
            case HL_FOLDER_ITEM_IMPORTED: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(HLTokens.ID.tokens)) {
                        this.hlentry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(HLTokens.NAME.tokens)) {
                        this.hlentry[1] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(HLTokens.TYPE.tokens)) continue;
                    this.hlentry[2] = this.getValue(string);
                }
                break;
            }
            case HL_ITEM_SENT: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(HLTokens.ID.tokens)) {
                        this.hlentry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(HLTokens.NAME.tokens)) {
                        this.hlentry[1] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(HLTokens.TYPE.tokens)) {
                        this.hlentry[2] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(HLTokens.ADDRESSEES.tokens)) continue;
                    this.addresseeUsers = this.getAddresseesUser(string);
                }
                break;
            }
            case SCRIPT_CREATED: 
            case SCRIPT_LAUNCHED: 
            case SCRIPT_REMOVED: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(AISTokens.ID.tokens)) {
                        this.aisentry[0] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(AISTokens.NAME.tokens)) continue;
                    this.aisentry[1] = this.getValue(string);
                }
                break;
            }
            case TS_CSV_IMPORTED: 
            case TS_CURATION_CLOSED: 
            case TS_CURATION_STARTED: 
            case TS_TIMESERIES_PUBLISHED: 
            case TS_TIMESERIES_SAVED: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (!string.contains(TSTokens.TITLE.tokens)) continue;
                    this.tstitle = this.getValue(string);
                }
                break;
            }
            case Create_Annotation: 
            case Edit_Annotation: 
            case Delete_Annotation: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(AnnotationTokens.annotationType.tokens)) {
                        this.annotationEntry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(AnnotationTokens.annotationName.tokens)) {
                        this.annotationEntry[1] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(AnnotationTokens.objectID.tokens)) {
                        this.annotationEntry[2] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(AnnotationTokens.objectName.tokens)) continue;
                    this.annotationEntry[3] = this.getValue(string);
                }
                break;
            }
            case CREATED_WORKFLOWREPORT_OUTPUT: 
            case DELETED_WORKFLOWREPORT_OUTPUT: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(WorkflowDocumentTokens.WORKFLOWID.tokens)) {
                        this.workflowDocumentsEntry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(WorkflowDocumentTokens.WorkflowDocuementName.tokens)) {
                        this.workflowDocumentsEntry[1] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(WorkflowDocumentTokens.STATUS.tokens)) {
                        this.workflowDocumentsEntry[2] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(WorkflowDocumentTokens.STEPS_NO.tokens)) continue;
                    this.workflowDocumentsEntry[2] = this.getValue(string);
                }
                break;
            }
            case CREATE_REPORT: 
            case OPEN_REPORT: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(ReportTokens.ID.tokens)) {
                        this.reportEntry[0] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(ReportTokens.Name.tokens)) continue;
                    this.reportEntry[1] = this.getValue(string);
                }
                break;
            }
            case OPEN_WORKFLOW_REPORT: 
            case SAVE_WORKFLOW_REPORT: 
            case CREATE_TEMPLATE: 
            case OPEN_TEMPLATE: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(ReportTokens.ID.tokens)) {
                        this.reportEntry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(ReportTokens.Name.tokens)) {
                        this.reportEntry[1] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(ReportTokens.AUTHOR.tokens)) continue;
                    this.reportEntry[2] = this.getValue(string);
                }
                break;
            }
            case GENERATE_REPORT_OUTPUT: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(ReportTokens.Name.tokens)) {
                        this.reportEntry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(ReportTokens.MIMETYPE.tokens)) {
                        this.reportEntry[1] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(ReportTokens.TYPE.tokens)) continue;
                    this.reportEntry[2] = this.getValue(string);
                }
                break;
            }
            case WEB_APPLICATION_ACTIVATED: 
            case WEB_APPLICATION_DEACTIVATED: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(WebAppTokens.ID.tokens)) {
                        this.webAppEntry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(WebAppTokens.NAME.tokens)) {
                        this.webAppEntry[1] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(WebAppTokens.VERSION.tokens)) {
                        this.webAppEntry[2] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(WebAppTokens.GHN_ID.tokens)) {
                        this.webAppEntry[3] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(WebAppTokens.GHN_NAME.tokens)) continue;
                    this.webAppEntry[4] = this.getValue(string);
                }
                break;
            }
            case WEB_APPLICATION_DEPLOYED: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(WebAppTokens.GHN_ID.tokens)) {
                        this.webAppEntry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(WebAppTokens.GHN_NAME.tokens)) {
                        this.webAppEntry[1] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(WebAppTokens.APPLICATIONS.tokens)) continue;
                    this.listApplication = this.getApplications(string);
                }
                break;
            }
            case WEB_APPLICATION_UNDEPLOYED: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (!string.contains(WebAppTokens.APPLICATIONS.tokens)) continue;
                    this.listApplication = this.getApplications(string);
                    this.listGHN = this.getGHN(string);
                }
                break;
            }
            case WAR_REMOVED: 
            case WAR_UPDATED: 
            case WAR_UPLOADED: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(WarTokens.ID.tokens)) {
                        this.warEntry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(WarTokens.APPLICATION_NAME.tokens)) {
                        this.warEntry[1] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(WarTokens.APPLICATION_VERSION.tokens)) {
                        this.warEntry[2] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(WarTokens.CATEGORY_NAME.tokens)) {
                        this.warEntry[3] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(WarTokens.NAME.tokens)) continue;
                    this.warEntry[4] = this.getValue(string);
                }
                break;
            }
            case AQUAMAPSOBJECTGENERATION: 
            case AQUAMAPSSAVEDITEM: {
                StringTokenizer stringTokenizer = new StringTokenizer(this.message, messageTokensSeparator);
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    if (string.contains(AquamapsTokens.TITLE.tokens)) {
                        this.aquamapsEntry[0] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(AquamapsTokens.TYPE.tokens)) {
                        this.aquamapsEntry[1] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(AquamapsTokens.GIS.tokens)) {
                        this.aquamapsEntry[2] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(AquamapsTokens.SPECIES_COUNT.tokens)) {
                        this.aquamapsEntry[3] = this.getValue(string);
                        continue;
                    }
                    if (string.contains(AquamapsTokens.HSPEC.tokens)) {
                        this.aquamapsEntry[4] = this.getValue(string);
                        continue;
                    }
                    if (!string.contains(AquamapsTokens.ID.tokens)) continue;
                    this.aquamapsEntry[4] = this.getValue(string);
                }
                break;
            }
        }
    }

    public String[] getAquamapsEntry() {
        return this.aquamapsEntry;
    }

    public void setAquamapsEntry(String[] stringArray) {
        this.aquamapsEntry = stringArray;
    }

    public String[] getReportEntry() {
        return this.reportEntry;
    }

    public void setReportEntry(String[] stringArray) {
        this.reportEntry = stringArray;
    }

    private ArrayList<HLRecord.GCUBEUser> getAddresseesUser(String string) {
        ArrayList<HLRecord.GCUBEUser> arrayList = new ArrayList<HLRecord.GCUBEUser>();
        String string2 = string.substring(string.indexOf("=") + 1).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, hlAddresssesSeparator);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            HLRecord.GCUBEUser gCUBEUser = new HLRecord.GCUBEUser(new HLRecord());
            gCUBEUser.setUser(string3.substring(0, string3.indexOf(hlAddresssesSeparator2)));
            gCUBEUser.setVre(string3.substring(string3.indexOf(hlAddresssesSeparator2) + 1));
            arrayList.add(gCUBEUser);
        }
        return arrayList;
    }

    private ArrayList<WebAppRecord.GHN> getGHN(String string) {
        ArrayList<WebAppRecord.GHN> arrayList = new ArrayList<WebAppRecord.GHN>();
        String string2 = string.substring(string.indexOf("=") + 1).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, hlAddresssesSeparator);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            WebAppRecord.GHN gHN = new WebAppRecord.GHN(new WebAppRecord());
            gHN.setGHN_ID(string3.substring(0, string3.indexOf(hlAddresssesSeparator2)));
            gHN.setGHN_NAME(string3.substring(string3.indexOf(hlAddresssesSeparator2) + 1));
            arrayList.add(gHN);
        }
        return arrayList;
    }

    private ArrayList<WebAppRecord.WebApplication> getApplications(String string) {
        ArrayList<WebAppRecord.WebApplication> arrayList = new ArrayList<WebAppRecord.WebApplication>();
        String string2 = string.substring(string.indexOf("=") + 1).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, hlAddresssesSeparator);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            WebAppRecord.WebApplication webApplication = new WebAppRecord.WebApplication(new WebAppRecord());
            if (string3.contains(WebAppTokens.ID.tokens)) {
                webApplication.setWEB_APPLICATION_ID(this.getValue(string3));
            } else if (string3.contains(WebAppTokens.NAME.tokens)) {
                webApplication.setWEB_APPLICATION_NAME(this.getValue(string3));
            } else if (string3.contains(WebAppTokens.VERSION.tokens)) {
                webApplication.setWEB_APPLICATION_NAME(this.getValue(string3));
            }
            arrayList.add(webApplication);
        }
        return arrayList;
    }

    private String[] getDetails(String string) {
        String[] stringArray = new String[2];
        String string2 = string.substring(0, string.indexOf(OperatorType.AND.operator));
        String string3 = string.substring(string.indexOf(OperatorType.AND.operator) + OperatorType.AND.operator.length() + 1);
        stringArray[0] = string3.substring(string3.indexOf("=") + 1).trim();
        stringArray[1] = string2.substring(string2.indexOf("=") + 1).trim();
        return stringArray;
    }

    private String getValue(String string) {
        return string.substring(string.indexOf("=") + 1).trim();
    }

    public String[] getWorkflowDocumentsEntry() {
        return this.workflowDocumentsEntry;
    }

    public void setWorkflowDocumentsEntry(String[] stringArray) {
        this.workflowDocumentsEntry = stringArray;
    }

    public String toString() {
        return this.message;
    }

    public HashMap<String, String> getCollections() {
        return this.collections;
    }

    public void setCollections(HashMap<String, String> hashMap) {
        this.collections = hashMap;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String string) {
        this.term = string;
    }

    public HashMap<String, String> getTerms() {
        return this.terms;
    }

    public void setTerms(HashMap<String, String> hashMap) {
        this.terms = hashMap;
    }

    public AccessLogParser.EntryType getType() {
        return this.type;
    }

    public void setType(AccessLogParser.EntryType entryType) {
        this.type = entryType;
    }

    public String getBrowseBy() {
        return this.browseBy;
    }

    public void setBrowseBy(String string) {
        this.browseBy = string;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean bl) {
        this.isDistinct = bl;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String string) {
        this.operator = string;
    }

    public String[] getContent() {
        return this.content;
    }

    public void setContent(String[] stringArray) {
        this.content = stringArray;
    }

    public String[] getHlentry() {
        return this.hlentry;
    }

    public void setHlentry(String[] stringArray) {
        this.hlentry = stringArray;
    }

    public ArrayList<HLRecord.GCUBEUser> getAddresseeUsers() {
        return this.addresseeUsers;
    }

    public void setAddresseeUsers(ArrayList<HLRecord.GCUBEUser> arrayList) {
        this.addresseeUsers = arrayList;
    }

    public static String getMessagetokensseparator() {
        return messageTokensSeparator;
    }

    public String[] getAisentry() {
        return this.aisentry;
    }

    public void setAisentry(String[] stringArray) {
        this.aisentry = stringArray;
    }

    public String getTstitle() {
        return this.tstitle;
    }

    public void setTstitle(String string) {
        this.tstitle = string;
    }

    public String[] getAnnotationEntry() {
        return this.annotationEntry;
    }

    public void setAnnotationEntry(String[] stringArray) {
        this.annotationEntry = stringArray;
    }

    public String[] getWebAppEntry() {
        return this.webAppEntry;
    }

    public void setWebAppEntry(String[] stringArray) {
        this.webAppEntry = stringArray;
    }

    public ArrayList<WebAppRecord.GHN> getListGHN() {
        return this.listGHN;
    }

    public void setListGHN(ArrayList<WebAppRecord.GHN> arrayList) {
        this.listGHN = arrayList;
    }

    public ArrayList<WebAppRecord.WebApplication> getListApplication() {
        return this.listApplication;
    }

    public void setListApplication(ArrayList<WebAppRecord.WebApplication> arrayList) {
        this.listApplication = arrayList;
    }

    public String[] getWarEntry() {
        return this.warEntry;
    }

    public void setWarEntry(String[] stringArray) {
        this.warEntry = stringArray;
    }

    protected static enum AquamapsTokens {
        TITLE("TITLE"),
        TYPE("TYPE"),
        ID("ID"),
        HSPEC("HSPEC"),
        SPECIES_COUNT("SPECIES_COUNT"),
        GIS("GIS");

        String tokens;

        private AquamapsTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum SearchAndBrowseTokens {
        collectionName("collectionName"),
        collectionID("collectionID"),
        term("term"),
        value("value"),
        DISTINCT("DISTINCT"),
        Browse_by("Browse by"),
        operator("operator");

        String tokens;

        private SearchAndBrowseTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum WarTokens {
        CATEGORY_NAME("CATEGORY_NAME"),
        ID("ID"),
        NAME("NAME"),
        APPLICATION_NAME("APPLICATION_NAME"),
        APPLICATION_VERSION("APPLICATION_VERSION");

        String tokens;

        private WarTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum WebAppTokens {
        APPLICATIONS("APPLICATIONS"),
        ID("ID"),
        NAME("NAME"),
        VERSION("VERSION"),
        GHN_ID("GHN_ID"),
        GHN_NAME("GHN_NAME");

        String tokens;

        private WebAppTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum ReportTokens {
        Name("Name"),
        ID("ID"),
        AUTHOR("AUTHOR"),
        MIMETYPE("MIMETYPE"),
        TYPE("TYPE");

        String tokens;

        private ReportTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum WorkflowDocumentTokens {
        WorkflowDocuementName("WorkflowDocuementName"),
        WORKFLOWID("WORKFLOWID"),
        STEPS_NO("STEPS_NO"),
        STATUS("STATUS");

        String tokens;

        private WorkflowDocumentTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum AnnotationTokens {
        annotationName("annotationName"),
        annotationType("annotationType"),
        objectID("objectID"),
        objectName("objectName");

        String tokens;

        private AnnotationTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum TSTokens {
        TITLE("TITLE");

        String tokens;

        private TSTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum AISTokens {
        ID("ID"),
        NAME("NAME");

        String tokens;

        private AISTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum HLTokens {
        ID("ID"),
        TYPE("TYPE"),
        ADDRESSEES("ADDRESSEES"),
        NAME("NAME");

        String tokens;

        private HLTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum RetrieveContentTokens {
        contentID("contentID"),
        contentName("contentName");

        String tokens;

        private RetrieveContentTokens(String string2) {
            this.tokens = string2;
        }

        public String toString() {
            return this.tokens;
        }
    }

    protected static enum OperatorType {
        AND("AND"),
        OR("OR"),
        None("None");

        String operator;

        private OperatorType(String string2) {
            this.operator = string2;
        }

        public String toString() {
            return this.operator;
        }
    }
}

