/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.common.messages.records.AquamapsRecord;
import org.gcube.messaging.common.messages.records.BaseRecord;

public class AquamapsEntry
extends LogEntry {
    private static final long serialVersionUID = 1L;
    private String title;
    private String type;
    private long speciesCount;
    private boolean gis;
    private String hspecId;

    public AquamapsEntry(String string, AccessLogParser.EntryType entryType) throws ParseException {
        this.line = string;
        this.record = new AquamapsRecord();
        this.entryType = entryType;
        this.parse();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public long getSpeciesCount() {
        return this.speciesCount;
    }

    public void setSpeciesCount(long l) {
        this.speciesCount = l;
    }

    public boolean isGis() {
        return this.gis;
    }

    public void setGis(boolean bl) {
        this.gis = bl;
    }

    public String getHspecId() {
        return this.hspecId;
    }

    public void setHspecId(String string) {
        this.hspecId = string;
    }

    @Override
    public BaseRecord fillRecord() {
        this.record.setDate(this.getDate());
        ((AquamapsRecord)this.record).setTitle(this.getMessage().getAquamapsEntry()[0]);
        ((AquamapsRecord)this.record).setType(this.getMessage().getAquamapsEntry()[1]);
        ((AquamapsRecord)this.record).setGis(Boolean.parseBoolean(this.getMessage().getAquamapsEntry()[2]));
        ((AquamapsRecord)this.record).setSpeciesCount(Long.parseLong(this.getMessage().getAquamapsEntry()[3]));
        if (this.getEntryType().compareTo(AccessLogParser.EntryType.AQUAMAPSOBJECTGENERATION) == 0) {
            ((AquamapsRecord)this.record).setHspecId(this.getMessage().getAquamapsEntry()[4]);
            ((AquamapsRecord)this.record).setAquamapsSubtype(AquamapsRecord.AquamapsSubType.AquamapsGeneration);
        } else {
            ((AquamapsRecord)this.record).setObjectID(this.getMessage().getAquamapsEntry()[4]);
            ((AquamapsRecord)this.record).setAquamapsSubtype(AquamapsRecord.AquamapsSubType.AquamapsSavedItem);
        }
        return this.record;
    }
}

