/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.common.messages.records.AquamapsRecord;
import org.gcube.messaging.common.messages.records.BaseRecord;

public class AquamapsEntry
extends LogEntry {
    private static final long serialVersionUID = 1L;
    private String title;
    private String type;
    private long speciesCount;
    private boolean gis;
    private String hspecId;

    public AquamapsEntry(String line, AccessLogParser.EntryType type) throws ParseException {
        this.line = line;
        this.record = new AquamapsRecord();
        this.entryType = type;
        this.parse();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getSpeciesCount() {
        return this.speciesCount;
    }

    public void setSpeciesCount(long speciesCount) {
        this.speciesCount = speciesCount;
    }

    public boolean isGis() {
        return this.gis;
    }

    public void setGis(boolean gis) {
        this.gis = gis;
    }

    public String getHspecId() {
        return this.hspecId;
    }

    public void setHspecId(String hspecId) {
        this.hspecId = hspecId;
    }

    @Override
    public BaseRecord fillRecord() {
        this.record.setDate(this.getDate());
        ((AquamapsRecord)this.record).setTitle(this.getMessage().getAquamapsEntry()[0]);
        ((AquamapsRecord)this.record).setType(this.getMessage().getAquamapsEntry()[1]);
        ((AquamapsRecord)this.record).setGis(Boolean.parseBoolean(this.getMessage().getAquamapsEntry()[2]));
        ((AquamapsRecord)this.record).setSpeciesCount(Long.parseLong(this.getMessage().getAquamapsEntry()[3]));
        if (this.getEntryType().compareTo(AccessLogParser.EntryType.AQUAMAPSOBJECTGENERATION) == 0) {
            ((AquamapsRecord)this.record).setHspecId(this.getMessage().getAquamapsEntry()[4]);
            ((AquamapsRecord)this.record).setAquamapsSubtype(AquamapsRecord.AquamapsSubType.AquamapsGeneration);
        } else {
            ((AquamapsRecord)this.record).setObjectID(this.getMessage().getAquamapsEntry()[4]);
            ((AquamapsRecord)this.record).setAquamapsSubtype(AquamapsRecord.AquamapsSubType.AquamapsSavedItem);
        }
        return this.record;
    }
}

