/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.messaging.common.consumer.stubs.MessagingConsumerPortType;
import org.gcube.messaging.common.consumer.stubs.SendReport;
import org.gcube.messaging.common.consumerlibrary.query.Query;

public class ConsumerCL {
    private final ProxyDelegate<MessagingConsumerPortType> delegate;

    public ConsumerCL(ProxyDelegate<MessagingConsumerPortType> config) {
        this.delegate = config;
    }

    public void backupMonitoringDB() throws Exception {
        Call<MessagingConsumerPortType, VOID> call = new Call<MessagingConsumerPortType, VOID>(){

            public VOID call(MessagingConsumerPortType endpoint) throws Exception {
                return endpoint.backupMonitoringDB(new VOID());
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void backupAccountingDB() throws Exception {
        Call<MessagingConsumerPortType, VOID> call = new Call<MessagingConsumerPortType, VOID>(){

            public VOID call(MessagingConsumerPortType endpoint) throws Exception {
                return endpoint.backupAccountingDB(new VOID());
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public String queryMonitoringDB(final String query) throws Exception {
        Call<MessagingConsumerPortType, String> call = new Call<MessagingConsumerPortType, String>(){

            public String call(MessagingConsumerPortType endpoint) throws Exception {
                return endpoint.queryMonitoringDB(query);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public String queryAccountingDB(final String query) throws Exception {
        Call<MessagingConsumerPortType, String> call = new Call<MessagingConsumerPortType, String>(){

            public String call(MessagingConsumerPortType endpoint) throws Exception {
                return endpoint.queryAccountingDB(query);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public String querySystemAccountingDB(final String query) throws Exception {
        Call<MessagingConsumerPortType, String> call = new Call<MessagingConsumerPortType, String>(){

            public String call(MessagingConsumerPortType endpoint) throws Exception {
                return endpoint.querySystemAccountingDB(query);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void sendReport(String date, GCUBEScope scope) throws Exception {
        final SendReport request = new SendReport(date, scope.toString());
        Call<MessagingConsumerPortType, VOID> call = new Call<MessagingConsumerPortType, VOID>(){

            public VOID call(MessagingConsumerPortType endpoint) throws Exception {
                return endpoint.sendReport(request);
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public <QUERY extends Query<ConsumerCL>> QUERY getQuery(Class<QUERY> type, ConsumerCL call) throws InstantiationException, IllegalAccessException {
        Query query = (Query)type.newInstance();
        query.setCall(call);
        return (QUERY)query;
    }
}

