/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gcube.messaging.common.consumer.stubs.calls.MessagingConsumerServiceCall;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.json.JSONException;
import org.gcube.messaging.common.consumerlibrary.query.EmptyResultException;
import org.gcube.messaging.common.consumerlibrary.query.Query;
import org.gcube.messaging.common.consumerlibrary.query.QueryNotSetException;
import org.gcube.messaging.common.messages.Test;

public class MonitoringQuery
extends Query<MessagingConsumerServiceCall> {
    private static final long serialVersionUID = 1L;

    @Override
    public String performQuery() throws Exception {
        this.logger.debug((Object)this.getQuery());
        Long l = System.currentTimeMillis();
        String string = ((MessagingConsumerServiceCall)this.call).queryMonitoringDB(this.getQuery());
        Long l2 = System.currentTimeMillis();
        this.logger.debug((Object)("Query time = " + (l2 - l) + " ms"));
        return string;
    }

    public String getGHNAverage(Test.TestType testType, String string) throws EmptyResultException, Exception {
        String string2 = null;
        this.setQuery("SELECT AVG(CAST(GHNMessage.result AS " + this.getType(testType) + ")) AS AVG FROM GHNMessage " + "WHERE GHNMessage.testType='" + testType.name() + "' AND GHNMessage.GHNName='" + string + "'");
        try {
            this.query();
            string2 = this.toJSON().getJSONObject(0).getString("AVG");
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error executing query");
            throw exception;
        }
        return string2;
    }

    public String getTodayGHNAverage(Test.TestType testType, String string) throws EmptyResultException, Exception {
        String string2 = null;
        this.setQuery("SELECT AVG(CAST(GHNMessage.result AS " + this.getType(testType) + ")) AS AVG FROM GHNMessage " + "WHERE GHNMessage.testType='" + testType.name() + "' AND GHNMessage.GHNName='" + string + "' AND GHNMessage.date='" + this.getTodayString() + "'");
        try {
            this.query();
            string2 = this.toJSON().getJSONObject(0).getString("AVG");
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error executing query");
            throw exception;
        }
        return string2;
    }

    public HashMap<String, String> getProbes() throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.setQuery("SELECT DISTINCT testType, description  FROM GHNMessage ORDER BY testType");
        try {
            this.query();
            JSONArray jSONArray = this.toJSON();
            for (int i = 0; i < jSONArray.length(); ++i) {
                String string = jSONArray.getJSONObject(i).getString("testType");
                String string2 = jSONArray.getJSONObject(i).getString("description");
                hashMap.put(string, string2);
            }
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        catch (QueryNotSetException queryNotSetException) {
            this.logger.error((Object)"Error executing query");
            throw queryNotSetException;
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error executing query");
            throw exception;
        }
        return hashMap;
    }

    public Map<String, ArrayList<String>> getGHNs() throws Exception {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        this.setQuery("SELECT DISTINCT GHNName  FROM GHNMessage ORDER BY GHNName");
        try {
            this.query();
            JSONArray jSONArray = this.toJSON();
            for (int i = 0; i < jSONArray.length(); ++i) {
                String string = jSONArray.getJSONObject(i).getString("GHNName");
                this.logger.debug((Object)("GHN: " + string));
                String string2 = string.substring(string.indexOf(".") + 1);
                String string3 = string2.substring(0, string2.indexOf(":"));
                ArrayList<String> arrayList = null;
                arrayList = (ArrayList<String>)hashMap.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
                hashMap.put(string3, arrayList);
            }
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        catch (QueryNotSetException queryNotSetException) {
            this.logger.error((Object)"Error executing query");
            throw queryNotSetException;
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error executing query");
            throw exception;
        }
        return hashMap;
    }

    public String getAllTodayGHNAverage(Test.TestType testType) throws Exception {
        this.setQuery("SELECT AVG(CAST(GHNMessage.result AS " + this.getType(testType) + ")) AS AVG, " + "GHNMessage.GHNName FROM " + "GHNMessage WHERE GHNMessage.testType='" + testType.name() + "'" + " AND GHNMessage.date='" + this.getTodayString() + "' GROUP BY GHNMessage.GHNName");
        return this.query();
    }

    public String getNotifications() throws Exception {
        this.setQuery("SELECT * FROM NOTIFICATION");
        return this.query();
    }

    public String getTodayNotifications() throws Exception {
        this.setQuery("SELECT * FROM NOTIFICATION WHERE date='" + this.getTodayString() + "'");
        return this.query();
    }

    public String getTodayRIMessages(String string, String string2) throws Exception {
        this.setQuery("SELECT * FROM RIMessage WHERE  ServiceName='" + string2 + "' " + "AND ServiceClass='" + string + "' AND date='" + this.getTodayString() + "'");
        return this.query();
    }

    public String getRIMessages(String string, String string2) throws Exception {
        this.setQuery("SELECT * FROM RIMessage WHERE  ServiceName='" + string2 + "' " + "AND ServiceClass='" + string + "'");
        return this.query();
    }

    public String getStatistics(String string, String string2, String string3, String string4, String string5) throws Exception {
        this.setQuery("SELECT COUNT(*) AS CNT, AVG(result) AS AVERAGE, " + string5 + " FROM GHNMessage " + "WHERE date >= '" + string3 + "' AND date <= '" + string4 + "' " + (string.compareTo("") == 0 ? "" : " AND testType='" + string + "'") + (string2.compareTo("") == 0 ? "" : " AND GHNName='" + string2 + "'") + " GROUP BY " + string5);
        try {
            this.query();
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return this.getResults();
    }

    private String getTodayString() {
        Date date = new Date();
        return this.dateFormat.format(date.getTime());
    }

    private String getType(Test.TestType testType) {
        if (testType.compareTo((Enum)Test.TestType.CPU_LOAD) == 0) {
            return "DECIMAL (3,2)";
        }
        return "UNSIGNED";
    }
}

