/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumer.ServiceContext;

public abstract class BrokerSubscription<LISTENER extends MessageListener>
extends Thread
implements ExceptionListener {
    protected TopicCouple couple;
    protected ArrayList<String> messageSelectors = new ArrayList();
    protected LISTENER listener;
    protected static GCUBELog logger = new GCUBELog(BrokerSubscription.class);
    protected ArrayList<Connection> connections = new ArrayList();
    protected static boolean transacted = false;
    protected static int ackMode = 1;
    protected boolean queue = false;

    public abstract void setScope(GCUBEScope var1);

    public void subscribe() throws Exception {
        if (this.queue) {
            this.setupQueueSubscription();
        } else if (this.messageSelectors.size() == 0) {
            this.setupDurableSubscribers(new String[0]);
        } else {
            for (String selector : this.messageSelectors) {
                this.setupDurableSubscribers(selector);
            }
        }
    }

    public ArrayList<Connection> getConnections() {
        return this.connections;
    }

    public void setConnections(ArrayList<Connection> connections) {
        this.connections = connections;
    }

    public void setupDurableSubscribers(String ... selector) throws Exception {
        ActiveMQConnectionFactory connectionFactory = null;
        if (ServiceContext.getContext().getUseEmbeddedBroker().booleanValue()) {
            connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
            Thread.sleep(10000L);
        } else if (this.getCouple().getScope().getServiceMap().getEndpoints((Object)"MessageBroker") != null) {
            connectionFactory = new ActiveMQConnectionFactory(((EndpointReferenceType)this.getCouple().getScope().getServiceMap().getEndpoints((Object)"MessageBroker").iterator().next()).getAddress().toString());
            try {
                TopicConnection connection = connectionFactory.createTopicConnection();
                if (selector.length > 0) {
                    connection.setClientID(this.getCouple().getTopicName() + selector[0]);
                } else {
                    connection.setClientID(this.getCouple().getTopicName() + this.listener.getClass());
                }
                connection.start();
                connection.setExceptionListener((ExceptionListener)this);
                TopicSession session = connection.createTopicSession(transacted, ackMode);
                Topic topic = session.createTopic(this.getCouple().getTopicName());
                TopicSubscriber consumer = null;
                consumer = selector.length > 0 ? session.createDurableSubscriber(topic, topic.getTopicName() + selector[0], selector[0], false) : session.createDurableSubscriber(topic, topic.getTopicName());
                consumer.setMessageListener(this.listener);
                this.connections.add((Connection)connection);
            }
            catch (JMSException e) {
                logger.error((Object)"Error creating Durable Subscriber", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"Error creating Durable Subscriber", (Throwable)e);
                throw e;
            }
        } else {
            logger.warn((Object)("Impossible to setup Durable Subscriber, Broker epr not specified for the scope: " + this.getCouple().getScope().toString()));
        }
        logger.info((Object)("Started Durable Subscriber for topic: " + this.getCouple().getTopicName()));
    }

    public void setupQueueSubscription() throws Exception {
        if (this.getCouple().getScope().getServiceMap().getEndpoints((Object)"MessageBroker") != null) {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(((EndpointReferenceType)this.getCouple().getScope().getServiceMap().getEndpoints((Object)"MessageBroker").iterator().next()).getAddress().toString());
            try {
                QueueConnection connection = connectionFactory.createQueueConnection();
                connection.setClientID(this.getCouple().getTopicName());
                connection.start();
                connection.setExceptionListener((ExceptionListener)this);
                QueueSession session = connection.createQueueSession(transacted, ackMode);
                Queue queue = session.createQueue(this.getCouple().getTopicName());
                QueueReceiver consumer = null;
                consumer = session.createReceiver(queue);
                consumer.setMessageListener(this.listener);
                this.connections.add((Connection)connection);
            }
            catch (JMSException e) {
                logger.error((Object)"Error creating Queue Receiver", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"Error creating Queue Receiver", (Throwable)e);
                throw e;
            }
        } else {
            logger.warn((Object)("Impossible to setup Queue Receiver, Broker epr not specified for the scope: " + this.getCouple().getScope().toString()));
        }
        logger.info((Object)("Started Queue receveiver for topic: " + this.getCouple().getTopicName()));
    }

    @Override
    public void run() {
        try {
            for (Connection connection : this.connections) {
                connection.stop();
                connection.close();
            }
            this.connections.clear();
        }
        catch (JMSException e) {
            logger.debug((Object)"Exception stopping the connection", (Throwable)e);
            this.connections.clear();
        }
        while (true) {
            try {
                this.subscribe();
                return;
            }
            catch (InvalidClientIDException ex) {
                logger.error((Object)"Subscription has not been reset", (Throwable)ex);
                return;
            }
            catch (Exception e) {
                logger.error((Object)"Error on subscription", (Throwable)e);
                try {
                    Thread.sleep(12000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    public void onException(JMSException exce) {
        logger.error((Object)exce.getMessage());
        logger.error((Object)exce);
        this.run();
    }

    public TopicCouple getCouple() {
        return this.couple;
    }

    public void setCouple(TopicCouple couple) {
        this.couple = couple;
    }

    public LISTENER getListener() {
        return this.listener;
    }

    public void setListener(LISTENER listener) {
        this.listener = listener;
    }

    public ArrayList<String> getMessageSelectors() {
        return this.messageSelectors;
    }

    public void setMessageSelectors(ArrayList<String> messageSelectors) {
        this.messageSelectors = messageSelectors;
    }

    public class TopicCouple {
        GCUBEScope scope;
        String topicName;

        public GCUBEScope getScope() {
            return this.scope;
        }

        public void setScope(GCUBEScope scope) {
            this.scope = scope;
        }

        public String getTopicName() {
            return this.topicName;
        }

        public void setTopicName(String topicName) {
            this.topicName = topicName;
        }
    }
}

