/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.activemq.broker.BrokerService;
import org.apache.xerces.dom.DocumentImpl;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.accounting.system.SystemAccounting;
import org.gcube.messaging.accounting.system.SystemAccountingFactory;
import org.gcube.messaging.common.consumer.BrokerSubscription;
import org.gcube.messaging.common.consumer.CustomSubscription;
import org.gcube.messaging.common.consumer.MessageChecker;
import org.gcube.messaging.common.consumer.accounting.NodeAccountingListener;
import org.gcube.messaging.common.consumer.accounting.NodeAccountingMessageChecker;
import org.gcube.messaging.common.consumer.accounting.PortalAccountingListener;
import org.gcube.messaging.common.consumer.accounting.PortalAccountingMessageChecker;
import org.gcube.messaging.common.consumer.accounting.SystemAccountingMessageChecker;
import org.gcube.messaging.common.consumer.db.AccountingDBManager;
import org.gcube.messaging.common.consumer.db.AccountingSystemDBManager;
import org.gcube.messaging.common.consumer.db.MonitoringDBManager;
import org.gcube.messaging.common.consumer.ghn.GHNListener;
import org.gcube.messaging.common.consumer.ghn.GHNMessageChecker;
import org.gcube.messaging.common.consumer.mail.MailClient;
import org.gcube.messaging.common.consumer.mail.MailTemplateParser;
import org.gcube.messaging.common.consumer.notifier.Notifier;
import org.gcube.messaging.common.consumer.ri.RIListener;
import org.gcube.messaging.common.consumer.ri.RIMessageChecker;
import org.gcube.messaging.common.consumer.webserver.WebServer;
import org.gcube.messaging.common.messages.GHNMessage;
import org.gcube.messaging.common.messages.NodeAccountingMessage;
import org.gcube.messaging.common.messages.PortalAccountingMessage;
import org.gcube.messaging.common.messages.RIMessage;
import org.gcube.messaging.common.messages.SystemAccountingMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceContext
extends GCUBEServiceContext {
    GCUBELog logger = new GCUBELog(ServiceContext.class);
    static Properties resources = new Properties();
    private MonitoringDBManager monitoringManager = null;
    private AccountingDBManager accountingManager = null;
    private AccountingSystemDBManager accountingSystemManager = null;
    private Notifier notifier = null;
    private MailClient mailClient = null;
    private MailTemplateParser mailTemplateParser = null;
    private Boolean notifyByMail = false;
    private Boolean useEmbeddedBroker = false;
    private Boolean useEmbeddedDB = false;
    private String dbuser = "";
    private String dbpass = "";
    private String dbhost = "";
    private Long dbport = null;
    private Long maxDBConnections = null;
    private WebServer server = null;
    private HashMap<GCUBEScope, HashMap<Class<? extends GCUBEMessage>, MessageChecker<?>>> messageCheckerMap = null;
    private BrokerService broker = null;
    private ArrayList<String> messagesubscriptionsToload;
    private Map<String, Class<? extends BrokerSubscription<?>>> messagesubscriptions;
    private static ArrayList<BrokerSubscription<?>> subscriptionsList;
    private File httpServerBasePath;
    private int httpServerPort;
    protected static ServiceContext cache;

    private ServiceContext() {
    }

    public static ServiceContext getContext() {
        return cache;
    }

    public Notifier getNotifier() {
        return ServiceContext.cache.notifier;
    }

    public void setNotifier(Notifier notifier) {
        ServiceContext.cache.notifier = notifier;
    }

    public MonitoringDBManager getMonitoringManager() {
        return ServiceContext.cache.monitoringManager;
    }

    public void setMonitoringManager(MonitoringDBManager manager) {
        ServiceContext.cache.monitoringManager = manager;
    }

    public AccountingDBManager getAccountingManager() {
        return ServiceContext.cache.accountingManager;
    }

    public void setAccountingManager(AccountingDBManager manager) {
        ServiceContext.cache.accountingManager = manager;
    }

    public AccountingSystemDBManager getAccountingSystemManager() {
        return this.accountingSystemManager;
    }

    public void setAccountingSystemManager(AccountingSystemDBManager accountingSystemManager) {
        this.accountingSystemManager = accountingSystemManager;
    }

    private void createAndRegisterTopicName(GCUBEScope Scope) {
        for (String subscription : this.messagesubscriptionsToload) {
            BrokerSubscription<?> sub = null;
            try {
                sub = this.messagesubscriptions.get(subscription).newInstance();
                sub.setScope(Scope);
                sub.subscribe();
            }
            catch (Exception e) {
                this.logger.fatal((Object)"Unable to Start Subscription", (Throwable)e);
                continue;
            }
            subscriptionsList.add(sub);
        }
        this.getInstance().setSpecificData(this.generateSpecificDataXML(this.messagesubscriptionsToload));
        this.setStatus(GCUBEServiceContext.Status.UPDATED);
    }

    private String generateSpecificDataXML(ArrayList<String> messagesubscriptions) {
        StringWriter xml = new StringWriter();
        try {
            DocumentImpl xmlReport = new DocumentImpl();
            Element rootReport = xmlReport.createElement("Subscriptions");
            for (String sub : messagesubscriptions) {
                Element e = null;
                e = xmlReport.createElementNS(null, "Subscription");
                e.appendChild(xmlReport.createTextNode(sub));
                rootReport.appendChild(e);
            }
            xmlReport.appendChild(rootReport);
            StreamResult stream = new StreamResult(xml);
            DOMSource source = new DOMSource((Node)xmlReport);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, stream);
            this.logger.debug((Object)("RISpecific data generated: " + xml.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"Unable to generate RI Specific data information", (Throwable)e);
        }
        return xml.toString();
    }

    private void getInput() throws RuntimeException, Exception {
        this.messagesubscriptions = new HashMap();
        this.messagesubscriptionsToload = new ArrayList();
        File subscriptionMappingFile = new File(GHNContext.getContext().getLocation() + File.separator + (String)ServiceContext.getContext().getProperty("configDir", new boolean[0]) + File.separator + (String)ServiceContext.getContext().getProperty("SubscriptionsMapping", new boolean[]{true}));
        try {
            resources.load(new FileReader(subscriptionMappingFile));
            for (Object prop : resources.keySet()) {
                this.logger.debug((Object)("reading key: " + (String)prop));
                this.messagesubscriptions.put((String)prop, Class.forName((String)resources.get(prop)));
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)e);
        }
        this.httpServerBasePath = new File(this.getPersistenceRoot().getAbsolutePath() + File.separator + (String)this.getProperty("httpServerBasePath", new boolean[]{true}));
        this.logger.debug((Object)("HTTP Server Base path = " + this.httpServerBasePath.getAbsolutePath()));
        if (!this.httpServerBasePath.exists()) {
            this.httpServerBasePath.mkdirs();
        }
        this.httpServerPort = Integer.parseInt((String)this.getProperty("httpServerPort", new boolean[]{true}));
        this.logger.debug((Object)("HTTP Server port = " + this.httpServerPort));
        try {
            String[] tokens = ((String)this.getProperty("Subscriptions", new boolean[]{true})).split(",");
            for (int i = 0; i < tokens.length; ++i) {
                this.logger.debug((Object)("Found Subscription: " + tokens[i]));
                this.messagesubscriptionsToload.add(tokens[i].trim());
            }
        }
        catch (RuntimeException e) {
            this.logger.debug((Object)"No Subscription Configuration found to use");
        }
        this.setNotifyByMail((Boolean)this.getProperty("NotifiybyMail", new boolean[0]));
        this.setUseEmbeddedBroker((Boolean)this.getProperty("UseEmbeddedBroker", new boolean[0]));
        this.setDbpass((String)this.getProperty("DBPass", new boolean[0]));
        this.setDbuser((String)this.getProperty("DBUser", new boolean[0]));
        this.setDbhost((String)this.getProperty("DBHost", new boolean[0]));
        this.setDbport((Long)this.getProperty("DBPort", new boolean[0]));
        this.setMaxDBConnections((Long)this.getProperty("MaxDBConnections", new boolean[0]));
        this.setUseEmbeddedDB((Boolean)this.getProperty("UseEmbeddedDB", new boolean[0]));
        this.setMailTemplateParser(new MailTemplateParser(GHNContext.getContext().getLocation() + File.separator + (String)ServiceContext.getContext().getProperty("configDir", new boolean[0]) + File.separator + (String)ServiceContext.getContext().getProperty("MailTemplatesFile", new boolean[]{true})));
        this.getMailTemplateParser().parseMailTemplates();
    }

    public Boolean getNotifyByMail() {
        return this.notifyByMail;
    }

    public void setNotifyByMail(Boolean notifyByMail) {
        this.notifyByMail = notifyByMail;
    }

    public String getJNDIName() {
        return "gcube/messaging/common/consumer";
    }

    private void startWebServer() {
        try {
            String webServerClass = (String)this.getProperty("webServerClass", new boolean[]{true});
            Class<?> cls = Class.forName(webServerClass);
            ServiceContext.cache.server = (WebServer)cls.newInstance();
            ServiceContext.cache.server.initDefaults(this.httpServerBasePath.getAbsolutePath(), this.httpServerPort);
            ServiceContext.cache.server.startServer();
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to Start Web Server", (Throwable)e);
            return;
        }
    }

    private HashMap<Class<? extends GCUBEMessage>, MessageChecker<?>> createMessageCheckerMap(GCUBEScope scope) {
        HashMap map = new HashMap();
        map.put(GHNMessage.class, new GHNMessageChecker(scope));
        map.put(RIMessage.class, new RIMessageChecker(scope));
        map.put(NodeAccountingMessage.class, new NodeAccountingMessageChecker(scope));
        map.put(PortalAccountingMessage.class, new PortalAccountingMessageChecker(scope));
        map.put(SystemAccountingMessage.class, new SystemAccountingMessageChecker(scope));
        return map;
    }

    public HashMap<GCUBEScope, HashMap<Class<? extends GCUBEMessage>, MessageChecker<?>>> getMessageCheckerMap() {
        return this.messageCheckerMap;
    }

    public void setMessageCheckerMap(HashMap<GCUBEScope, HashMap<Class<? extends GCUBEMessage>, MessageChecker<?>>> messageCheckerMap) {
        this.messageCheckerMap = messageCheckerMap;
    }

    private boolean createCustomSubscribers() {
        String brokerEpr = null;
        String[] customTopics = null;
        try {
            customTopics = ((String)this.getProperty("CustomTopics", new boolean[]{true})).split(",");
        }
        catch (RuntimeException e) {
            this.logger.debug((Object)"No Custom topics available");
            return false;
        }
        try {
            brokerEpr = (String)this.getProperty("CustomBrokerURL", new boolean[]{true});
        }
        catch (RuntimeException e) {
            this.logger.debug((Object)"No Custom Broker URL to use");
            return false;
        }
        for (int idx = 0; idx < customTopics.length; ++idx) {
            this.logger.debug((Object)("Trying to Subscribe to Custom topic: " + customTopics[idx]));
            CustomSubscription subscription = new CustomSubscription();
            try {
                subscription.setupCustomDurableSubscriber(customTopics[idx], brokerEpr, new RIListener(), new String[0]);
                subscriptionsList.add(subscription);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error creating Durable Subscriber", (Throwable)e);
            }
            CustomSubscription subscription2 = new CustomSubscription();
            try {
                subscription2.setupCustomDurableSubscriber(customTopics[idx], brokerEpr, new GHNListener(), new String[0]);
                subscriptionsList.add(subscription2);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error creating Durable Subscriber", (Throwable)e);
            }
            CustomSubscription subscription3 = new CustomSubscription();
            try {
                subscription3.setupCustomDurableSubscriber(customTopics[idx], brokerEpr, new PortalAccountingListener(), new String[0]);
                subscriptionsList.add(subscription3);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error creating Durable Subscriber", (Throwable)e);
            }
            CustomSubscription subscription4 = new CustomSubscription();
            try {
                subscription4.setupCustomDurableSubscriber(customTopics[idx], brokerEpr, new NodeAccountingListener(), new String[0]);
                subscriptionsList.add(subscription4);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)"Error creating Durable Subscriber", (Throwable)e);
            }
        }
        for (GCUBEScope scope : this.getStartScopes()) {
            try {
                this.getMailClient().addScope(scope);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error adding Mail configuration for scope: " + scope), (Throwable)e);
            }
        }
        return true;
    }

    protected void onInitialisation() throws Exception {
        subscriptionsList = new ArrayList();
        this.messageCheckerMap = new HashMap();
        this.getInput();
        if (this.getUseEmbeddedBroker().booleanValue()) {
            try {
                this.startEmbeddedBroker();
            }
            catch (RuntimeException e) {
                this.logger.debug((Object)e);
            }
            catch (Exception e) {
                this.logger.debug((Object)e);
            }
        }
        this.setAccountingManager(new AccountingDBManager());
        this.getAccountingManager().open();
        this.setMonitoringManager(new MonitoringDBManager());
        this.getMonitoringManager().open();
        this.setAccountingSystemManager(new AccountingSystemDBManager());
        this.getAccountingSystemManager().open();
        this.setNotifier(new Notifier(this.getNotifyByMail()));
        Thread t = new Thread(this.getNotifier());
        t.start();
        MailClient client = new MailClient();
        client.initialize();
        this.setMailClient(client);
        this.startWebServer();
        if (!this.createCustomSubscribers()) {
            this.getInstance().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new RIResourceConsumer(), new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE});
        }
    }

    protected void onReady() throws Exception {
        SystemAccounting acc = null;
        try {
            acc = SystemAccountingFactory.getSystemAccountingInstance();
            String type = "MessagingConsumerType";
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("restarted", "true");
            parameters.put("timestamp", new Timestamp(System.currentTimeMillis()));
            acc.sendSystemAccountingMessage((GCUBEServiceContext)this, type, parameters, new GCUBEScope[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error sending system accounting message", (Throwable)e);
        }
    }

    protected void onShutdown() throws Exception {
        try {
            this.stopDurableSubscriber();
            this.getAccountingManager().close();
            this.getMonitoringManager().close();
            if (this.broker != null) {
                this.broker.stop();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"ERROR shutting down the service", (Throwable)e);
        }
    }

    public MailClient getMailClient() {
        return ServiceContext.cache.mailClient;
    }

    public void setMailClient(MailClient mailClient) {
        ServiceContext.cache.mailClient = mailClient;
    }

    public Boolean getUseEmbeddedBroker() {
        return ServiceContext.cache.useEmbeddedBroker;
    }

    public void setUseEmbeddedBroker(Boolean useEmbeddedBroker) {
        ServiceContext.cache.useEmbeddedBroker = useEmbeddedBroker;
    }

    private void startEmbeddedBroker() throws RuntimeException, Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(true);
        this.broker.setUseJmx(false);
        this.broker.addConnector("tcp://localhost:61616");
        this.broker.start();
        this.logger.debug((Object)"Starting Embedded Broker");
    }

    public WebServer getServer() {
        return this.server;
    }

    public void setServer(WebServer server) {
        this.server = server;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public void setHttpServerPort(int httpServerPort) {
        this.httpServerPort = httpServerPort;
    }

    public void stopDurableSubscriber() {
        for (BrokerSubscription<?> sub : subscriptionsList) {
            for (Connection connection : sub.getConnections()) {
                try {
                    ((TopicConnection)connection).close();
                }
                catch (JMSException e) {
                    this.logger.error((Object)"Error closing the connection to the broker", (Throwable)e);
                }
            }
        }
    }

    public static ArrayList<BrokerSubscription<?>> getSubscriptionsList() {
        return subscriptionsList;
    }

    public static void setSubscriptionsList(ArrayList<BrokerSubscription<?>> subscriptionsList) {
        ServiceContext.subscriptionsList = subscriptionsList;
    }

    public Boolean getUseEmbeddedDB() {
        return this.useEmbeddedDB;
    }

    public void setUseEmbeddedDB(Boolean useEmbeddedDB) {
        this.useEmbeddedDB = useEmbeddedDB;
    }

    public String getDbuser() {
        return this.dbuser;
    }

    public void setDbuser(String dbuser) {
        this.dbuser = dbuser;
    }

    public String getDbpass() {
        return this.dbpass;
    }

    public void setDbpass(String dbpass) {
        this.dbpass = dbpass;
    }

    public MailTemplateParser getMailTemplateParser() {
        return this.mailTemplateParser;
    }

    public void setMailTemplateParser(MailTemplateParser mailTemplateParser) {
        this.mailTemplateParser = mailTemplateParser;
    }

    public boolean connectToUsermanagementDB() {
        return (Boolean)this.getProperty("connectToUserManagementDB", new boolean[0]);
    }

    public String getDbhost() {
        return this.dbhost;
    }

    public void setDbhost(String dbhost) {
        this.dbhost = dbhost;
    }

    public Long getDbport() {
        return this.dbport;
    }

    public void setDbport(Long dbport) {
        this.dbport = dbport;
    }

    public Long getMaxDBConnections() {
        return this.maxDBConnections;
    }

    public void setMaxDBConnections(Long maxDBConnections) {
        this.maxDBConnections = maxDBConnections;
    }

    static {
        cache = new ServiceContext();
    }

    private class RIResourceConsumer
    extends GCUBEResource.ResourceConsumer {
        private RIResourceConsumer() {
        }

        protected void onAddScope(GCUBEResource.AddScopeEvent event) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (GCUBEScope scope : (GCUBEScope[])event.getPayload()) {
                try {
                    if (scope.getServiceMap() == null || scope.getServiceMap().getEndpoints((Object)"MessageBroker") == null) continue;
                    ServiceContext.this.getMailClient().addScope(scope);
                    ServiceContext.this.messageCheckerMap.put(scope, ServiceContext.this.createMessageCheckerMap(scope));
                    ServiceContext.this.createAndRegisterTopicName(scope);
                }
                catch (GCUBEScopeNotSupportedException e) {
                    ServiceContext.this.logger.error((Object)("Error adding Mail configuration for the given scope: " + scope), (Throwable)e);
                }
                catch (Exception e) {
                    ServiceContext.this.logger.error((Object)("Error adding Mail configuration for the given scope: " + scope), (Throwable)e);
                }
            }
        }
    }
}

